/*******************************************************************************
 *  Copyright (c) 2010 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.parser.ast.type;

import java.util.ArrayList;
import java.util.List;

import org.simantics.databoard.parser.ast.type.visitor.AstTypeVisitor;
import org.simantics.databoard.parser.ast.type.visitor.AstTypeVisitorVoid;

public class AstTypeReference extends AstType {
	public final String name;
	public final List<AstType> parameters;
	public final List<AstAttribute> attributes;
	
	public AstTypeReference(String name) {
		this.name = name;
		this.parameters = new ArrayList<AstType>(0);
		this.attributes = new ArrayList<AstAttribute>(0);
	}
	
	public AstTypeReference(String name, AstType ... parameters) {
		this(name);
		for(AstType parameter : parameters)
			this.parameters.add(parameter);
	}
			
	public AstTypeReference(String name, List<AstType> parameters,
			List<AstAttribute> attributes) {
		this.name = name;
		this.parameters = parameters;
		this.attributes = attributes;
	}

	public void addAttribute(String key, String value) {
		attributes.add(new AstAttribute(key, value));
	}
	
	@Override
	public void accept(AstTypeVisitorVoid v) {
		v.visit(this);
	}		
	
	@Override
	public <T> T accept(AstTypeVisitor<T> v) {
		return v.visit(this);
	}	
}
