package org.simantics.databoard.binding.impl;

import org.simantics.databoard.binding.ByteBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.primitives.UnsignedByte;
import org.simantics.databoard.type.ByteType;

/**
 * Binding of {@link UnsignedByte} to byte type.
 * 
 * @author Toni Kalajainen <toni.kalajainen@iki.fi>
 */
public abstract class UnsignedByteBinding extends ByteBinding {
	
	UnsignedByteBinding(ByteType type) {
		super(type);
	}
	
	public static class Immutable extends UnsignedByteBinding {
		
		public Immutable(ByteType type) {
			super(type);
		}		
		
		@Override
		public Object create(Number value) throws BindingException {
			try {
				return UnsignedByte.valueOf(value.longValue());
			} catch (java.lang.IllegalArgumentException e) {
				throw new BindingException( e );
			}
		}

		@Override
		public Object create(String value) throws BindingException {
			try {
				return UnsignedByte.valueOf( Long.valueOf(value) );
			} catch (java.lang.IllegalArgumentException e) {
				throw new BindingException( e );
			}
		}

		@Override
		public void setValue(Object obj, Number value) throws BindingException {
			throw new BindingException("UnsignedByte is immutable class");
		}

		@Override
		public boolean isImmutable() {
			return true;
		}

		@Override
		public boolean isInstance(Object obj) {
			return obj instanceof UnsignedByte.Immutable;
		}

		@Override
		public Object create(byte value) throws BindingException {
			try {
				return UnsignedByte.valueOf(value);
			} catch (java.lang.IllegalArgumentException e) {
				throw new BindingException( e );
			}
		}

		@Override
		public Object create(Byte value) throws BindingException {
			try {
				return UnsignedByte.valueOf(value);
			} catch (java.lang.IllegalArgumentException e) {
				throw new BindingException( e );
			}
		}

		@Override
		public void setValue(Object obj, byte value) throws BindingException {
			throw new BindingException("UnsignedByte is immutable class");
		}
				
	}
	
	public static class Mutable extends UnsignedByteBinding {
		
		public Mutable(ByteType type) {
			super(type);
		}		

		@Override
		public Object create(Number value) throws BindingException {
			return new UnsignedByte.Mutable(value.longValue());
		}

		@Override
		public Object create(String value) throws BindingException {
			return new UnsignedByte.Mutable(value);
		}

		@Override
		public void setValue(Object obj, Number value) throws BindingException {
			UnsignedByte.Mutable bb = (UnsignedByte.Mutable) obj;
			bb.setBits(value.intValue());
		}

		@Override
		public boolean isImmutable() {
			return false;
		}
		
		@Override
		public boolean isInstance(Object obj) {
			return obj instanceof UnsignedByte.Mutable;
		}

		@Override
		public Object create(byte value) throws BindingException {
			return new UnsignedByte.Mutable(value);
		}

		@Override
		public Object create(Byte value) throws BindingException {
			return new UnsignedByte.Mutable(value);
		}

		@Override
		public void setValue(Object obj, byte value) throws BindingException {
			UnsignedByte.Mutable bb = (UnsignedByte.Mutable) obj;
			bb.setBits(value);
		}		
	}	

	@Override
	public Byte getValue(Object obj) throws BindingException {
		return (byte) ((UnsignedByte)obj).toBits();
	}

	@Override
	public byte getValue_(Object obj) throws BindingException {
		return (byte) ((UnsignedByte)obj).toBits();
	}
	
	@Override
	public String toString(Object value) throws BindingException {
		return value.toString();
	}
	
}
