/*******************************************************************************
 *  Copyright (c) 2010 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.binding.factory;

import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingConstructionException;
import org.simantics.databoard.binding.error.RuntimeBindingConstructionException;
import org.simantics.databoard.type.Datatype;

public interface BindingScheme {

	/**
	 * Get binding of a data type
	 * 
	 * @param type data type
	 * @return binding 
	 * @throws BindingConstructionException if data type is not supported
	 */
	Binding getBinding(Datatype type) throws BindingConstructionException;

	/**
	 * Get binding of a data type
	 * 
	 * @param type data type
	 * @return binding 
	 * @throws RuntimeBindingConstructionException if data type is not supported
	 */
	Binding getBindingUnchecked(Datatype type) throws RuntimeBindingConstructionException;
	
	/**
	 * Tests if the scheme supports a type
	 * 
	 * @param type
	 * @return true if the type is supported by the scheme
	 */
	boolean supportsType(Datatype type);
	
}

