/*******************************************************************************
 * Copyright (c) 2010- Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *    VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.accessor.impl;

import org.simantics.databoard.accessor.CloseableAccessor;
import org.simantics.databoard.accessor.error.AccessorException;

public class ClosableCompositeRecord extends CompositeRecord implements CloseableAccessor {

	public interface CloseListener {
		void onClosed(CompositeRecord sender) throws AccessorException;
	}
	
	CloseListener closeListener;
	
	public ClosableCompositeRecord() {
		super();
	}
	
	public ClosableCompositeRecord(CloseListener closeListener) {
		super();
		this.closeListener = closeListener;
	}
	
	public void setCloseListener(CloseListener closeListener) {
		this.closeListener = closeListener;
	}

	@Override
	public void close() throws AccessorException {
		if (closeListener!=null) closeListener.onClosed(this);
	}

}

