/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.example;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingException;

public class DeepHashcode {

	public static void main(String[] args) throws BindingException {

		// Binding can calculate deep hashcode for any instance
		Binding binding = Bindings.getBindingUnchecked( int[].class );
		
		int[] array1 = new int[] { 1, 2, 3 };
		int[] array2 = new int[] { 1, 2, 3 };
		int[] array3 = new int[] { 2, 3, 4 };
		
		System.out.println( "Hashcode for array1 is " + binding.hashValue( array1 ) );
		System.out.println( "Hashcode for array2 is " + binding.hashValue( array2 ) );
		System.out.println( "Hashcode for array3 is " + binding.hashValue( array3 ) );
		
	}
	
}
