/*******************************************************************************
 * Copyright (c) 2007, 2012 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.compressions.impl;

import java.nio.ByteBuffer;

/**
 * @author Tuukka Lehtonen
 */
public class Buffers {

	public static byte[] getInputArray(ByteBuffer buffer) {
		if (buffer.hasArray())
			return buffer.array();
		// Poor performance fallback involving copying.
		byte[] copy = new byte[buffer.remaining()];
		buffer.get(copy);
		return copy;
	}

	public static byte[] getOutputArray(ByteBuffer buffer) {
		return buffer.hasArray() ? buffer.array() : new byte[buffer.remaining()];
	}

	public static void writeOutput(ByteBuffer buffer, byte[] array) {
		if (buffer.hasArray() && buffer.array() == array)
			return;
		// Poor performance fallback involving copying.
		int pos = buffer.position();
		buffer.put(array);
		buffer.position(pos);
	}

}
