/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.swt;

import java.util.Collections;
import java.util.Set;
import org.eclipse.jface.resource.FontDescriptor;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.NodeQueryManager;
import org.simantics.browsing.ui.content.LabelDecorator;
import org.simantics.browsing.ui.content.PrunedChildrenResult;

public class TreeTruncationDecoratorFactory {
    protected int withStyle;
    protected Set<String> decoratedColumns;

    public TreeTruncationDecoratorFactory(int withStyle) {
        this(withStyle, Collections.singleton("single"));
    }

    public TreeTruncationDecoratorFactory(int withStyle, Set<String> decoratedColumns) {
        this.withStyle = withStyle;
        this.decoratedColumns = decoratedColumns;
    }

    public LabelDecorator create(NodeQueryManager manager, NodeContext context) {
        int finalLength;
        boolean expanded = (Boolean)manager.query(context, BuiltinKeys.IS_EXPANDED);
        if (!expanded) {
            return null;
        }
        PrunedChildrenResult prunedChildren = (PrunedChildrenResult)manager.query(context, BuiltinKeys.PRUNED_CHILDREN);
        NodeContext[] finalChildren = (NodeContext[])manager.query(context, BuiltinKeys.FINAL_CHILDREN);
        final int prunedLength = prunedChildren.getPrunedChildren().length;
        if (prunedLength == (finalLength = finalChildren.length)) {
            if (finalLength >= 10) {
                return new LabelDecorator.Stub(){

                    public String decorateLabel(String label, String column, int itemIndex) {
                        if (TreeTruncationDecoratorFactory.this.decoratedColumns.contains(column)) {
                            return String.valueOf(label) + " [" + finalLength + "]";
                        }
                        return null;
                    }

                    public <F> F decorateFont(F font, String column, int itemIndex) {
                        return null;
                    }
                };
            }
            return null;
        }
        return new LabelDecorator.Stub(){

            public String decorateLabel(String label, String column, int itemIndex) {
                if (TreeTruncationDecoratorFactory.this.decoratedColumns.contains(column)) {
                    return String.valueOf(label) + " [showing " + finalLength + "/" + prunedLength + "]";
                }
                return null;
            }

            public <F> F decorateFont(F font, String column, int itemIndex) {
                if (TreeTruncationDecoratorFactory.this.decoratedColumns.contains(column)) {
                    return (F)((FontDescriptor)font).withStyle(TreeTruncationDecoratorFactory.this.withStyle);
                }
                return null;
            }
        };
    }
}

