/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.swt;

import java.util.List;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.jface.viewers.ISelection;
import org.simantics.DatabaseJob;
import org.simantics.Simantics;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.common.node.IDeletable;
import org.simantics.browsing.ui.common.node.IModifiable;
import org.simantics.browsing.ui.common.node.IRefreshable;
import org.simantics.browsing.ui.model.queries.IsNodeContextModifiable;
import org.simantics.browsing.ui.model.queries.IsNodeContextRemovable;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.procedure.adapter.TransientCacheListener;
import org.simantics.db.common.utils.RequestUtil;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.SelectionHints;
import org.simantics.db.procedure.Procedure;
import org.simantics.db.request.Read;
import org.simantics.ui.SimanticsUI;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.ui.ISelectionUtils;

public class NodePropertyTester
extends PropertyTester {
    private static final String NODE_CLASS = "nodeClass";
    private static final String DELETABLE = "deletable";
    private static final String MODIFIABLE = "modifiable";
    private static final String REFRESHABLE = "refreshable";
    ContextTester deletableTester = new DeletableTester();
    ContextTester modifiableTester = new ModifiableTester();
    ContextTester refreshableTester = new RefreshableTester();

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (!(receiver instanceof ISelection)) {
            return false;
        }
        List ncs = ISelectionUtils.getPossibleKeys((Object)((ISelection)receiver), (IHintContext.Key)SelectionHints.KEY_MAIN, NodeContext.class);
        if (ncs.isEmpty()) {
            return false;
        }
        if (NODE_CLASS.equals(property)) {
            return this.testCollection(ncs, new NodeClassTester(args));
        }
        if (DELETABLE.equals(property)) {
            return this.testCollection(ncs, this.deletableTester);
        }
        if (MODIFIABLE.equals(property)) {
            if (ncs.size() == 1) {
                return this.testCollection(ncs, this.modifiableTester);
            }
            return false;
        }
        if (REFRESHABLE.equals(property)) {
            return this.testCollection(ncs, this.refreshableTester);
        }
        return false;
    }

    private boolean testCollection(List<NodeContext> receiver, ContextTester tester) {
        if (receiver.isEmpty()) {
            return false;
        }
        int fails = 0;
        for (NodeContext nc : receiver) {
            if (tester.test(nc)) continue;
            ++fails;
        }
        return fails <= 0;
    }

    static interface ContextTester {
        public boolean test(NodeContext var1);
    }

    public static class DeletableTester
    implements ContextTester {
        @Override
        public boolean test(NodeContext nc) {
            Object input = nc.getConstant(BuiltinKeys.INPUT);
            if (input instanceof Resource) {
                Session session = Simantics.peekSession();
                try {
                    if (session != null && !DatabaseJob.inProgress()) {
                        return (Boolean)RequestUtil.trySyncRequest((Session)session, (long)SimanticsUI.UI_THREAD_REQUEST_START_TIMEOUT, (long)SimanticsUI.UI_THREAD_REQUEST_EXECUTION_TIMEOUT, (Object)false, (Read)new IsNodeContextRemovable(nc), (Procedure)TransientCacheListener.instance());
                    }
                }
                catch (InterruptedException | DatabaseException throwable) {}
                return false;
            }
            return input instanceof IDeletable;
        }
    }

    public static class ModifiableTester
    implements ContextTester {
        @Override
        public boolean test(NodeContext nc) {
            Object input = nc.getConstant(BuiltinKeys.INPUT);
            if (input instanceof Resource) {
                Session session = Simantics.peekSession();
                try {
                    if (session != null && !DatabaseJob.inProgress()) {
                        return (Boolean)RequestUtil.trySyncRequest((Session)session, (long)SimanticsUI.UI_THREAD_REQUEST_START_TIMEOUT, (long)SimanticsUI.UI_THREAD_REQUEST_EXECUTION_TIMEOUT, (Object)false, (Read)new IsNodeContextModifiable(nc), (Procedure)TransientCacheListener.instance());
                    }
                }
                catch (InterruptedException | DatabaseException throwable) {}
                return false;
            }
            return input instanceof IModifiable;
        }
    }

    public static class NodeClassTester
    implements ContextTester {
        Object[] args;

        NodeClassTester(Object[] args) {
            this.args = args;
        }

        @Override
        public boolean test(NodeContext nc) {
            try {
                Object input = nc.getConstant(BuiltinKeys.INPUT);
                Class<?> inputClass = input.getClass();
                boolean assignable = false;
                Object[] objectArray = this.args;
                int n = this.args.length;
                int n2 = 0;
                while (n2 < n) {
                    Object o = objectArray[n2];
                    Class<?> clazz = Class.forName((String)o, true, input.getClass().getClassLoader());
                    if (clazz.isAssignableFrom(inputClass)) {
                        assignable = true;
                        break;
                    }
                    ++n2;
                }
                return assignable;
            }
            catch (ClassNotFoundException classNotFoundException) {
                return false;
            }
        }
    }

    public static class RefreshableTester
    implements ContextTester {
        @Override
        public boolean test(NodeContext nc) {
            return nc.getConstant(BuiltinKeys.INPUT) instanceof IRefreshable;
        }
    }
}

