/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.swt;

import gnu.trove.map.hash.THashMap;
import gnu.trove.procedure.TObjectProcedure;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.AssertionFailedException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.resource.ColorDescriptor;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.DeviceResourceException;
import org.eclipse.jface.resource.DeviceResourceManager;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.swt.IFocusService;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.CheckedState;
import org.simantics.browsing.ui.Column;
import org.simantics.browsing.ui.DataSource;
import org.simantics.browsing.ui.ExplorerState;
import org.simantics.browsing.ui.GraphExplorer;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.NodeContextPath;
import org.simantics.browsing.ui.NodeQueryManager;
import org.simantics.browsing.ui.NodeQueryProcessor;
import org.simantics.browsing.ui.PrimitiveQueryProcessor;
import org.simantics.browsing.ui.SelectionDataResolver;
import org.simantics.browsing.ui.SelectionFilter;
import org.simantics.browsing.ui.StatePersistor;
import org.simantics.browsing.ui.common.AdaptableHintContext;
import org.simantics.browsing.ui.common.ErrorLogger;
import org.simantics.browsing.ui.common.NodeContextBuilder;
import org.simantics.browsing.ui.common.NodeContextUtil;
import org.simantics.browsing.ui.common.internal.GECache;
import org.simantics.browsing.ui.common.internal.GENodeQueryManager;
import org.simantics.browsing.ui.common.internal.IGECache;
import org.simantics.browsing.ui.common.internal.IGraphExplorerContext;
import org.simantics.browsing.ui.common.internal.UIElementReference;
import org.simantics.browsing.ui.common.processors.DefaultCheckedStateProcessor;
import org.simantics.browsing.ui.common.processors.DefaultComparableChildrenProcessor;
import org.simantics.browsing.ui.common.processors.DefaultFinalChildrenProcessor;
import org.simantics.browsing.ui.common.processors.DefaultHasChildrenProcessor;
import org.simantics.browsing.ui.common.processors.DefaultImageDecoratorProcessor;
import org.simantics.browsing.ui.common.processors.DefaultImagerFactoriesProcessor;
import org.simantics.browsing.ui.common.processors.DefaultImagerProcessor;
import org.simantics.browsing.ui.common.processors.DefaultLabelDecoratorProcessor;
import org.simantics.browsing.ui.common.processors.DefaultLabelerFactoriesProcessor;
import org.simantics.browsing.ui.common.processors.DefaultLabelerProcessor;
import org.simantics.browsing.ui.common.processors.DefaultPrunedChildrenProcessor;
import org.simantics.browsing.ui.common.processors.DefaultSelectedImageDecoratorFactoriesProcessor;
import org.simantics.browsing.ui.common.processors.DefaultSelectedLabelDecoratorFactoriesProcessor;
import org.simantics.browsing.ui.common.processors.DefaultSelectedLabelerProcessor;
import org.simantics.browsing.ui.common.processors.DefaultSelectedViewpointFactoryProcessor;
import org.simantics.browsing.ui.common.processors.DefaultSelectedViewpointProcessor;
import org.simantics.browsing.ui.common.processors.DefaultViewpointContributionProcessor;
import org.simantics.browsing.ui.common.processors.DefaultViewpointContributionsProcessor;
import org.simantics.browsing.ui.common.processors.DefaultViewpointProcessor;
import org.simantics.browsing.ui.common.processors.IsExpandedProcessor;
import org.simantics.browsing.ui.common.processors.NoSelectionRequestProcessor;
import org.simantics.browsing.ui.common.processors.ProcessorLifecycle;
import org.simantics.browsing.ui.common.state.ExplorerStates;
import org.simantics.browsing.ui.content.ImageDecorator;
import org.simantics.browsing.ui.content.Imager;
import org.simantics.browsing.ui.content.LabelDecorator;
import org.simantics.browsing.ui.content.Labeler;
import org.simantics.browsing.ui.content.PrunedChildrenResult;
import org.simantics.browsing.ui.model.nodetypes.EntityNodeType;
import org.simantics.browsing.ui.model.nodetypes.NodeType;
import org.simantics.browsing.ui.swt.DefaultImageDecoratorsProcessor;
import org.simantics.browsing.ui.swt.DefaultIsExpandedProcessor;
import org.simantics.browsing.ui.swt.DefaultLabelDecoratorsProcessor;
import org.simantics.browsing.ui.swt.DefaultSelectedImagerProcessor;
import org.simantics.browsing.ui.swt.DefaultShowMaxChildrenProcessor;
import org.simantics.browsing.ui.swt.GraphExplorerImplBase;
import org.simantics.browsing.ui.swt.GraphExplorerToolTip;
import org.simantics.browsing.ui.swt.ImageLoaderJob;
import org.simantics.browsing.ui.swt.TreeItemReference;
import org.simantics.browsing.ui.swt.UpdateRunner;
import org.simantics.browsing.ui.swt.internal.Threads;
import org.simantics.db.layer0.SelectionHints;
import org.simantics.utils.ObjectUtils;
import org.simantics.utils.datastructures.BijectionMap;
import org.simantics.utils.datastructures.disposable.AbstractDisposable;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.SWTThread;
import org.simantics.utils.threads.ThreadUtils;
import org.simantics.utils.ui.ISelectionUtils;
import org.simantics.utils.ui.SWTUtils;
import org.simantics.utils.ui.jface.BasePostSelectionProvider;
import org.simantics.utils.ui.widgets.VetoingEventHandler;
import org.simantics.utils.ui.workbench.WorkbenchUtils;

class GraphExplorerImpl
extends GraphExplorerImplBase
implements Listener,
GraphExplorer {
    private static final String INLINE_EDITING_UI_CONTEXT = "org.simantics.browsing.ui.inlineEditing";
    private static final String KEY_DRAG_COLUMN = "dragColumn";
    private static final boolean DEBUG_SELECTION_LISTENERS = false;
    private static final int DEFAULT_CONSECUTIVE_LABEL_REFRESH_DELAY = 200;
    public static final int DEFAULT_MAX_CHILDREN = 1000;
    private static final long POST_SELECTION_DELAY = 300L;
    private static final long SELECTION_CHANGE_QUIET_TIME = 150L;
    private final IThreadWorkQueue thread;
    private final LocalResourceManager localResourceManager;
    private final ResourceManager resourceManager;
    Tree tree;
    final HashMap<NodeContext.CacheKey<?>, NodeQueryProcessor> processors = new HashMap();
    final HashMap<Object, PrimitiveQueryProcessor> primitiveProcessors = new HashMap();
    final HashMap<Class, DataSource> dataSources = new HashMap();
    GraphExplorerContext explorerContext = new GraphExplorerContext();
    HashSet<TreeItem> pendingItems = new HashSet();
    boolean updating = false;
    boolean pendingRoot = false;
    GraphExplorer.ModificationContext modificationContext = null;
    NodeContext rootContext;
    StatePersistor persistor = null;
    boolean editable = true;
    BijectionMap<NodeContext, TreeItem> contextToItem = new BijectionMap();
    Column[] columns = new Column[0];
    Map<String, Integer> columnKeyToIndex = new HashMap<String, Integer>();
    boolean refreshingColumnSizes = false;
    boolean columnsAreVisible = true;
    Image[] columnImageArray = new Image[1];
    Object[] columnDescOrImageArray = new Object[1];
    final ExecutorService queryUpdateScheduler = Threads.getExecutor();
    final ScheduledExecutorService uiUpdateScheduler = ThreadUtils.getNonBlockingWorkExecutor();
    private boolean disposed = false;
    private final CopyOnWriteArrayList<FocusListener> focusListeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<MouseListener> mouseListeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<KeyListener> keyListeners = new CopyOnWriteArrayList();
    private GraphExplorerPostSelectionProvider postSelectionProvider = new GraphExplorerPostSelectionProvider(this);
    protected BasePostSelectionProvider selectionProvider = new BasePostSelectionProvider();
    protected SelectionDataResolver selectionDataResolver;
    protected SelectionFilter selectionFilter;
    protected BiFunction<GraphExplorer, Object[], Object[]> selectionTransformation = new BiFunction<GraphExplorer, Object[], Object[]>(){

        @Override
        public Object[] apply(GraphExplorer explorer, Object[] objects) {
            Object[] result = new Object[objects.length];
            int i = 0;
            while (i < objects.length) {
                AdaptableHintContext context = new AdaptableHintContext(new IHintContext.Key[]{SelectionHints.KEY_MAIN});
                context.setHint(SelectionHints.KEY_MAIN, objects[i]);
                result[i] = context;
                ++i;
            }
            return result;
        }
    };
    protected FontDescriptor originalFont;
    protected ColorDescriptor originalForeground;
    protected ColorDescriptor originalBackground;
    private final Map<TreeItem, NodeContext> selectedItems = new HashMap<TreeItem, NodeContext>();
    private final Set<NodeContext> selectionRefreshContexts = new HashSet<NodeContext>();
    private int autoExpandLevel = 0;
    private IServiceLocator serviceLocator;
    private IContextService contextService = null;
    private IFocusService focusService = null;
    private IContextActivation editingContext = null;
    ImageLoaderJob imageLoaderJob;
    Map<TreeItem, ImageTask> imageTasks = new THashMap();
    private boolean verticalBarVisible = false;
    private TransientStateImpl transientState = new TransientStateImpl();
    int updateCounter = 0;
    private int maxChildren = 1000;
    private Set<NodeContext> currentlyModifiedNodes = new THashSet();
    private final TreeEditor editor;
    private Color invalidModificationColor = null;
    TreeItem previousSingleSelection = null;
    long focusGainedAt = Long.MIN_VALUE;
    protected GraphExplorerToolTip toolTip;
    int postSelectionModCount = 0;
    long lastSelectionModTime = System.currentTimeMillis() - 10000L;
    long selectionSetTargetTime = 0L;
    boolean delayedSelectionScheduled = false;
    Runnable SELECTION_DELAY = new Runnable(){

        @Override
        public void run() {
            if (GraphExplorerImpl.this.tree.isDisposed()) {
                return;
            }
            long now = System.currentTimeMillis();
            long waitTimeLeft = GraphExplorerImpl.this.selectionSetTargetTime - now;
            if (waitTimeLeft > 0L) {
                GraphExplorerImpl.this.delayedSelectionScheduled = true;
                GraphExplorerImpl.this.tree.getDisplay().timerExec((int)waitTimeLeft, (Runnable)this);
            } else {
                GraphExplorerImpl.this.delayedSelectionScheduled = false;
                GraphExplorerImpl.this.resetSelection();
            }
        }
    };
    private Set<String> uiContexts;
    Point previousTreeSize;
    Point previousTreeParentSize;
    boolean activatedBefore = false;
    private static final String LISTENER_SET_INDICATOR = "LSI";
    private static final String PENDING = "PENDING";
    private int contextSelectionChangeModCount = 0;
    Listener resizeListener = new Listener(){

        public void handleEvent(Event event) {
            if (GraphExplorerImpl.this.refreshingColumnSizes) {
                return;
            }
            GraphExplorerImpl.this.refreshColumnSizes();
        }
    };
    Listener itemDisposeListener = new Listener(){

        public void handleEvent(Event event) {
            if (event.type == 12 && event.widget instanceof TreeItem) {
                TreeItem ti = (TreeItem)event.widget;
                NodeContext cfr_ignored_0 = (NodeContext)GraphExplorerImpl.this.contextToItem.removeWithRight((Object)ti);
            }
        }
    };
    Labeler.LabelerListener labelListener = new Labeler.LabelerListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean columnModified(final NodeContext context, final String key, String newLabel) {
            if (GraphExplorerImpl.this.tree.isDisposed()) {
                return false;
            }
            Map<NodeContext, Runnable> map = GraphExplorerImpl.this.labelRefreshRunnables;
            synchronized (map) {
                Runnable refresher = new Runnable(){

                    @Override
                    public void run() {
                        TreeItem item = (TreeItem)(this).GraphExplorerImpl.this.contextToItem.getRight((Object)context);
                        if (item == null || item.isDisposed()) {
                            return;
                        }
                        Integer index = (this).GraphExplorerImpl.this.columnKeyToIndex.get(key);
                        if (index == null) {
                            return;
                        }
                        try {
                            GENodeQueryManager manager = new GENodeQueryManager((IGraphExplorerContext)(this).GraphExplorerImpl.this.explorerContext, null, null, null);
                            int itemIndex = 0;
                            TreeItem parentItem = item.getParentItem();
                            itemIndex = parentItem == null ? (this).GraphExplorerImpl.this.tree.indexOf(item) : parentItem.indexOf(item);
                            GraphExplorerImpl.this.setTextAndImage(item, (NodeQueryManager)manager, context, itemIndex);
                        }
                        catch (SWTException e) {
                            ErrorLogger.defaultLogError((Throwable)e);
                        }
                    }
                };
                GraphExplorerImpl.this.labelRefreshRunnables.put(context, refresher);
                if (!GraphExplorerImpl.this.refreshIsQueued) {
                    GraphExplorerImpl.this.refreshIsQueued = true;
                    long delay = 0L;
                    long now = System.currentTimeMillis();
                    long elapsed = now - GraphExplorerImpl.this.lastLabelRefreshScheduled;
                    if (elapsed < 200L) {
                        delay = 200L - elapsed;
                    }
                    if (delay > 0L) {
                        ThreadUtils.getNonBlockingWorkExecutor().schedule(new Runnable(){

                            @Override
                            public void run() {
                                GraphExplorerImpl.this.scheduleImmediateLabelRefresh();
                            }
                        }, delay, TimeUnit.MILLISECONDS);
                    } else {
                        GraphExplorerImpl.this.scheduleImmediateLabelRefresh();
                    }
                    GraphExplorerImpl.this.lastLabelRefreshScheduled = now;
                }
            }
            return true;
        }

        public boolean columnsModified(NodeContext context, Map<String, String> columns) {
            System.out.println("TODO: implement GraphExplorerImpl.labelListener.columnsModified");
            return false;
        }
    };
    long lastLabelRefreshScheduled = 0L;
    boolean refreshIsQueued = false;
    Map<NodeContext, Runnable> labelRefreshRunnables = new HashMap<NodeContext, Runnable>();

    boolean scheduleUpdater() {
        if (this.tree.isDisposed()) {
            return false;
        }
        if (this.pendingRoot || !this.pendingItems.isEmpty()) {
            assert (!this.tree.isDisposed());
            int activity = this.explorerContext.activityInt;
            long delay = 30L;
            if (activity >= 100) {
                delay = activity < 1000 ? 500L : 3000L;
            }
            this.updateCounter = 0;
            this.uiUpdateScheduler.schedule(new Runnable(){

                @Override
                public void run() {
                    if (GraphExplorerImpl.this.tree.isDisposed()) {
                        return;
                    }
                    if (GraphExplorerImpl.this.updateCounter > 0) {
                        GraphExplorerImpl.this.updateCounter = 0;
                        GraphExplorerImpl.this.uiUpdateScheduler.schedule(this, 50L, TimeUnit.MILLISECONDS);
                    } else {
                        GraphExplorerImpl.this.tree.getDisplay().asyncExec((Runnable)new UpdateRunner(GraphExplorerImpl.this, GraphExplorerImpl.this.explorerContext));
                    }
                }
            }, delay, TimeUnit.MILLISECONDS);
            this.updating = true;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void update(TreeItem item) {
        HashSet<TreeItem> hashSet = this.pendingItems;
        synchronized (hashSet) {
            ++this.updateCounter;
            if (item == null) {
                this.pendingRoot = true;
            } else {
                this.pendingItems.add(item);
            }
            if (this.updating) {
                return;
            }
            this.scheduleUpdater();
        }
    }

    public int getMaxChildren() {
        return this.maxChildren;
    }

    public int getMaxChildren(NodeQueryManager manager, NodeContext context) {
        Integer result = (Integer)manager.query(context, BuiltinKeys.SHOW_MAX_CHILDREN);
        if (result != null) {
            if (result < 0) {
                throw new AssertionError((Object)("BuiltinKeys.SHOW_MAX_CHILDREN query must never return < 0, got " + result));
            }
            return result;
        }
        return this.maxChildren;
    }

    public void setMaxChildren(int maxChildren) {
        this.maxChildren = maxChildren;
    }

    public void setModificationContext(GraphExplorer.ModificationContext modificationContext) {
        this.modificationContext = modificationContext;
    }

    public GraphExplorerImpl(Composite parent) {
        this(parent, 2818);
    }

    private String startEditing(TreeItem item, int columnIndex, String columnKey) {
        Labeler.Modifier modifier;
        NodeContext context;
        if (!this.editable) {
            return "Rename not supported for selection";
        }
        GENodeQueryManager manager = new GENodeQueryManager((IGraphExplorerContext)this.explorerContext, null, null, (UIElementReference)TreeItemReference.create(item.getParentItem()));
        Labeler labeler = (Labeler)manager.query(context = (NodeContext)item.getData(), BuiltinKeys.SELECTED_LABELER);
        if (labeler == null) {
            return "Rename not supported for selection";
        }
        if (columnKey == null) {
            columnKey = this.columns[columnIndex].getKey();
        }
        if ((modifier = labeler.getModifier(this.modificationContext, columnKey)) == null) {
            if (columnKey.startsWith("#")) {
                modifier = labeler.getModifier(this.modificationContext, columnKey.substring(1));
            }
            if (modifier == null) {
                return "Rename not supported for selection";
            }
        }
        if (modifier instanceof Labeler.DeniedModifier) {
            Labeler.DeniedModifier dm = (Labeler.DeniedModifier)modifier;
            return dm.getMessage();
        }
        if (this.currentlyModifiedNodes.contains(context)) {
            return "Rename not supported for selection";
        }
        Control oldEditor = this.editor.getEditor();
        if (oldEditor != null) {
            oldEditor.dispose();
        }
        if (modifier instanceof Labeler.DialogModifier) {
            this.performDialogEditing(item, columnIndex, context, (Labeler.DialogModifier)modifier);
        } else if (modifier instanceof Labeler.CustomModifier) {
            this.startCustomEditing(item, columnIndex, context, (Labeler.CustomModifier)modifier);
        } else if (modifier instanceof Labeler.EnumerationModifier) {
            this.startEnumerationEditing(item, columnIndex, context, (Labeler.EnumerationModifier)modifier);
        } else {
            this.startTextEditing(item, columnIndex, context, modifier);
        }
        return null;
    }

    void performDialogEditing(TreeItem item, int columnIndex, NodeContext context, Labeler.DialogModifier modifier) {
        AtomicBoolean disposed = new AtomicBoolean(false);
        Consumer<String> callback = result -> {
            if (disposed.get()) {
                return;
            }
            String error = modifier.isValid(result);
            if (error == null) {
                modifier.modify(result);
                if (!item.isDisposed()) {
                    item.setText(columnIndex, result);
                    this.queueSelectionRefresh(context);
                }
            }
        };
        this.currentlyModifiedNodes.add(context);
        try {
            String status = modifier.query((Object)this.tree, (Object)item, columnIndex, context, callback);
            if (status != null) {
                ErrorLogger.defaultLog((IStatus)new Status(1, "org.simantics.browsing.ui.swt", status));
            }
        }
        finally {
            this.currentlyModifiedNodes.remove(context);
            disposed.set(true);
        }
    }

    private void reconfigureTreeEditor(TreeItem item, int columnIndex, Control control, int widthHint, int heightHint, int insetX, int insetY) {
        Point size = control.computeSize(widthHint, heightHint);
        this.editor.horizontalAlignment = 16384;
        Rectangle itemRect = item.getBounds(columnIndex);
        Rectangle rect = this.tree.getClientArea();
        this.editor.minimumWidth = Math.max(size.x, itemRect.width) + insetX * 2;
        int left = itemRect.x;
        int right = rect.x + rect.width;
        this.editor.minimumWidth = Math.min(this.editor.minimumWidth, right - left);
        this.editor.minimumHeight = size.y + insetY * 2;
        this.editor.layout();
    }

    void reconfigureTreeEditorForText(TreeItem item, int columnIndex, Control control, String text, int heightHint, int insetX, int insetY) {
        GC gc = new GC((Drawable)control);
        Point size = gc.textExtent(text);
        gc.dispose();
        this.reconfigureTreeEditor(item, columnIndex, control, size.x, -1, insetX, insetY);
    }

    void startCustomEditing(TreeItem item, int columnIndex, final NodeContext context, Labeler.CustomModifier modifier) {
        Object obj = modifier.createControl((Object)this.tree, (Object)item, columnIndex, context);
        if (!(obj instanceof Control)) {
            throw new UnsupportedOperationException("SWT control required, got " + obj + " from CustomModifier.createControl(Object)");
        }
        Control control = (Control)obj;
        control.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                GraphExplorerImpl.this.currentlyModifiedNodes.remove(context);
                GraphExplorerImpl.this.queueSelectionRefresh(context);
                GraphExplorerImpl.this.deactivateEditingContext();
            }
        });
        if (!(control instanceof Shell)) {
            this.editor.setEditor(control, item, columnIndex);
        }
        control.setFocus();
        this.reconfigureTreeEditor(item, columnIndex, control, -1, -1, 0, 0);
        this.activateEditingContext(control);
        this.currentlyModifiedNodes.add(context);
    }

    void startEnumerationEditing(final TreeItem item, final int columnIndex, final NodeContext context, final Labeler.EnumerationModifier modifier) {
        String selectedValue;
        String initialText = modifier.getValue();
        if (initialText == null) {
            throw new AssertionError((Object)"Labeler.Modifier.getValue() returned null");
        }
        List values = modifier.getValues();
        int selectedIndex = values.indexOf(selectedValue = modifier.getValue());
        if (selectedIndex == -1) {
            throw new AssertionFailedException(modifier + " EnumerationModifier.getValue returned '" + selectedValue + "' which is not among the possible values returned by EnumerationModifier.getValues(): " + values);
        }
        final CCombo combo = new CCombo((Composite)this.tree, 0x80080C);
        combo.setVisibleItemCount(10);
        for (String value : values) {
            combo.add(value);
        }
        combo.select(selectedIndex);
        Listener comboListener = new Listener(){
            boolean arrowTraverseUsed = false;

            public void handleEvent(Event e) {
                block0 : switch (e.type) {
                    case 1: {
                        if (e.character == '\r') {
                            String text = combo.getText();
                            modifier.modify(text);
                            if (!item.isDisposed()) {
                                item.setText(columnIndex, text);
                                GraphExplorerImpl.this.queueSelectionRefresh(context);
                            }
                            combo.dispose();
                            e.doit = false;
                            break;
                        }
                        if (e.keyCode != 27) break;
                        combo.dispose();
                        e.doit = false;
                        break;
                    }
                    case 13: {
                        if (this.arrowTraverseUsed) {
                            this.arrowTraverseUsed = false;
                            return;
                        }
                        String text = combo.getText();
                        modifier.modify(text);
                        if (!item.isDisposed()) {
                            item.setText(columnIndex, text);
                            GraphExplorerImpl.this.queueSelectionRefresh(context);
                        }
                        combo.dispose();
                        break;
                    }
                    case 16: {
                        String text = combo.getText();
                        modifier.modify(text);
                        if (!item.isDisposed()) {
                            item.setText(columnIndex, text);
                            GraphExplorerImpl.this.queueSelectionRefresh(context);
                        }
                        combo.dispose();
                        break;
                    }
                    case 31: {
                        switch (e.detail) {
                            case 4: {
                                String text = combo.getText();
                                modifier.modify(text);
                                if (!item.isDisposed()) {
                                    item.setText(columnIndex, text);
                                    GraphExplorerImpl.this.queueSelectionRefresh(context);
                                }
                                this.arrowTraverseUsed = false;
                            }
                            case 2: {
                                combo.dispose();
                                e.doit = false;
                                break block0;
                            }
                            case 32: 
                            case 64: {
                                this.arrowTraverseUsed = true;
                                break block0;
                            }
                        }
                        break;
                    }
                    case 12: {
                        GraphExplorerImpl.this.currentlyModifiedNodes.remove(context);
                        GraphExplorerImpl.this.deactivateEditingContext();
                    }
                }
            }
        };
        combo.addListener(37, (Listener)VetoingEventHandler.INSTANCE);
        combo.addListener(1, comboListener);
        combo.addListener(16, comboListener);
        combo.addListener(31, comboListener);
        combo.addListener(13, comboListener);
        combo.addListener(12, comboListener);
        this.editor.setEditor((Control)combo, item, columnIndex);
        combo.setFocus();
        this.reconfigureTreeEditorForText(item, columnIndex, (Control)combo, combo.getText(), -1, 0, 0);
        this.activateEditingContext((Control)combo);
        this.currentlyModifiedNodes.add(context);
        combo.setListVisible(true);
    }

    void startTextEditing(final TreeItem item, final int columnIndex, final NodeContext context, final Labeler.Modifier modifier) {
        String initialText = modifier.getValue();
        if (initialText == null) {
            throw new AssertionError((Object)("Labeler.Modifier.getValue() returned null, modifier=" + modifier));
        }
        final Composite composite = new Composite((Composite)this.tree, 0);
        final Text text = new Text(composite, 2048);
        composite.addListener(11, new Listener(){

            public void handleEvent(Event e) {
                Rectangle rect = composite.getClientArea();
                text.setBounds(rect.x + 0, rect.y + 0, rect.width - 0, rect.height - 0);
            }
        });
        final Labeler.FilteringModifier filter = modifier instanceof Labeler.FilteringModifier ? (Labeler.FilteringModifier)modifier : null;
        Listener textListener = new Listener(){
            boolean modified = false;

            public void handleEvent(Event e) {
                block0 : switch (e.type) {
                    case 16: {
                        String newText;
                        String error;
                        if (this.modified && (error = modifier.isValid(newText = text.getText())) == null) {
                            modifier.modify(newText);
                            if (!item.isDisposed()) {
                                item.setText(columnIndex, newText);
                                GraphExplorerImpl.this.queueSelectionRefresh(context);
                            }
                        }
                        composite.dispose();
                        break;
                    }
                    case 24: {
                        String newText = text.getText();
                        String error = modifier.isValid(newText);
                        if (error != null) {
                            text.setBackground(GraphExplorerImpl.this.invalidModificationColor);
                            GraphExplorerImpl.this.errorStatus(error);
                        } else {
                            text.setBackground(null);
                            GraphExplorerImpl.this.errorStatus(null);
                        }
                        this.modified = true;
                        break;
                    }
                    case 25: {
                        if (item.isDisposed()) {
                            return;
                        }
                        e.text = filter != null ? filter.filter(e.text) : e.text;
                        String newText = text.getText();
                        String leftText = newText.substring(0, e.start);
                        String rightText = newText.substring(e.end, newText.length());
                        GraphExplorerImpl.this.reconfigureTreeEditorForText(item, columnIndex, (Control)text, String.valueOf(leftText) + e.text + rightText, -1, 0, 0);
                        break;
                    }
                    case 31: {
                        switch (e.detail) {
                            case 4: {
                                String newText;
                                String error;
                                if (this.modified && (error = modifier.isValid(newText = text.getText())) == null) {
                                    modifier.modify(newText);
                                    if (!item.isDisposed()) {
                                        item.setText(columnIndex, newText);
                                        GraphExplorerImpl.this.queueSelectionRefresh(context);
                                    }
                                }
                            }
                            case 2: {
                                composite.dispose();
                                e.doit = false;
                                break block0;
                            }
                        }
                        break;
                    }
                    case 12: {
                        GraphExplorerImpl.this.currentlyModifiedNodes.remove(context);
                        GraphExplorerImpl.this.deactivateEditingContext();
                        GraphExplorerImpl.this.errorStatus(null);
                    }
                }
            }
        };
        text.setText(initialText);
        text.addListener(16, textListener);
        text.addListener(31, textListener);
        text.addListener(25, textListener);
        text.addListener(24, textListener);
        text.addListener(12, textListener);
        this.editor.setEditor((Control)composite, item, columnIndex);
        text.selectAll();
        text.setFocus();
        this.reconfigureTreeEditorForText(item, columnIndex, (Control)text, initialText, -1, 0, 0);
        this.currentlyModifiedNodes.add(context);
        this.activateEditingContext((Control)text);
    }

    protected void errorStatus(String error) {
        IStatusLineManager status = this.getStatusLineManager();
        if (status != null) {
            status.setErrorMessage(error);
        }
    }

    protected IStatusLineManager getStatusLineManager() {
        if (this.serviceLocator instanceof IWorkbenchPart) {
            return WorkbenchUtils.getStatusLine((IWorkbenchPart)((IWorkbenchPart)this.serviceLocator));
        }
        if (this.serviceLocator instanceof IWorkbenchSite) {
            return WorkbenchUtils.getStatusLine((IWorkbenchSite)((IWorkbenchSite)this.serviceLocator));
        }
        return null;
    }

    protected void activateEditingContext(Control control) {
        if (this.contextService != null) {
            this.editingContext = this.contextService.activateContext(INLINE_EDITING_UI_CONTEXT);
        }
        if (control != null && this.focusService != null) {
            this.focusService.addFocusTracker(control, INLINE_EDITING_UI_CONTEXT);
        }
    }

    protected void deactivateEditingContext() {
        IContextActivation a = this.editingContext;
        if (a != null) {
            this.editingContext = null;
            this.contextService.deactivateContext(a);
        }
    }

    void queueSelectionRefresh(NodeContext forContext) {
        this.selectionRefreshContexts.add(forContext);
    }

    public String startEditing(NodeContext context, String columnKey_) {
        Integer columnIndex;
        this.assertNotDisposed();
        if (!this.thread.currentThreadAccess()) {
            throw new IllegalStateException("not in SWT display thread " + this.thread.getThread());
        }
        String columnKey = columnKey_;
        if (columnKey.startsWith("#")) {
            columnKey = columnKey.substring(1);
        }
        if ((columnIndex = this.columnKeyToIndex.get(columnKey)) == null) {
            return "Rename not supported for selection";
        }
        TreeItem item = (TreeItem)this.contextToItem.getRight((Object)context);
        if (item == null) {
            return "Rename not supported for selection";
        }
        return this.startEditing(item, columnIndex, columnKey_);
    }

    public String startEditing(String columnKey) {
        ISelection selection = this.postSelectionProvider.getSelection();
        if (selection == null) {
            return "Rename not supported for selection";
        }
        NodeContext context = (NodeContext)ISelectionUtils.filterSingleSelection((Object)selection, NodeContext.class);
        if (context == null) {
            return "Rename not supported for selection";
        }
        return this.startEditing(context, columnKey);
    }

    public GraphExplorerImpl(Composite parent, int style) {
        this.setServiceLocator(null);
        this.localResourceManager = new LocalResourceManager(JFaceResources.getResources());
        this.resourceManager = new DeviceResourceManager((Device)parent.getDisplay());
        this.imageLoaderJob = new ImageLoaderJob(this);
        this.imageLoaderJob.setPriority(50);
        this.invalidModificationColor = (Color)this.localResourceManager.get((DeviceResourceDescriptor)ColorDescriptor.createFrom((RGB)new RGB(255, 128, 128)));
        this.thread = SWTThread.getThreadAccess((Widget)parent);
        int i = 0;
        while (i < 10) {
            this.explorerContext.activity.push(0);
            ++i;
        }
        this.tree = new Tree(parent, style);
        this.tree.addListener(36, (Listener)this);
        this.tree.addListener(17, (Listener)this);
        this.tree.addListener(12, (Listener)this);
        this.tree.addListener(26, (Listener)this);
        this.tree.setData("GraphExplorer", (Object)this);
        parent.addListener(11, (Listener)this);
        this.tree.addListener(11, (Listener)this);
        this.originalFont = JFaceResources.getDefaultFontDescriptor();
        this.tree.setFont((Font)this.localResourceManager.get((DeviceResourceDescriptor)this.originalFont));
        this.columns = new Column[]{new Column("single")};
        this.columnKeyToIndex = Collections.singletonMap("single", 0);
        this.editor = new TreeEditor(this.tree);
        this.editor.horizontalAlignment = 16384;
        this.editor.grabHorizontal = true;
        this.editor.minimumWidth = 50;
        this.setBasicListeners();
        this.setDefaultProcessors();
        this.toolTip = new GraphExplorerToolTip(this.explorerContext, this.tree);
    }

    public IThreadWorkQueue getThread() {
        return this.thread;
    }

    protected void setBasicListeners() {
        this.tree.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TreeItem[] selection = GraphExplorerImpl.this.tree.getSelection();
                GraphExplorerImpl.this.previousSingleSelection = selection.length == 1 ? selection[0] : null;
            }
        });
        Listener mouseEditListener = new Listener(){
            Future<?> startEdit = null;

            public void handleEvent(Event event) {
                if (event.type == 29) {
                    this.cancelEdit();
                    return;
                }
                if (event.button == 1) {
                    long eventTime = (long)event.time & 0xFFFFFFFFL;
                    if (eventTime - GraphExplorerImpl.this.focusGainedAt < 250L) {
                        return;
                    }
                    Point point = new Point(event.x, event.y);
                    TreeItem item = GraphExplorerImpl.this.tree.getItem(point);
                    if (item == null) {
                        return;
                    }
                    if (!item.equals(GraphExplorerImpl.this.previousSingleSelection)) {
                        this.cancelEdit();
                        return;
                    }
                    if (GraphExplorerImpl.this.tree.getColumnCount() > 1) {
                        int i = 0;
                        while (i < GraphExplorerImpl.this.tree.getColumnCount()) {
                            if (item.getBounds(i).contains(point)) {
                                this.tryScheduleEdit(event, item, point, 100L, i);
                                return;
                            }
                            ++i;
                        }
                    } else if (item.getBounds().contains(point)) {
                        if (event.count == 1) {
                            this.tryScheduleEdit(event, item, point, 500L, 0);
                        } else {
                            this.cancelEdit();
                        }
                    }
                }
            }

            void tryScheduleEdit(Event event, final TreeItem item, Point point, long delayMs, final int column) {
                if (!this.cancelEdit()) {
                    return;
                }
                this.startEdit = ThreadUtils.getNonBlockingWorkExecutor().schedule(new Runnable(){

                    @Override
                    public void run() {
                        ThreadUtils.asyncExec((IThreadWorkQueue)(this).GraphExplorerImpl.this.thread, (Runnable)new Runnable(){

                            @Override
                            public void run() {
                                if (item.isDisposed()) {
                                    return;
                                }
                                GraphExplorerImpl.this.startEditing(item, column, null);
                            }
                        });
                    }
                }, delayMs, TimeUnit.MILLISECONDS);
            }

            boolean cancelEdit() {
                Future<?> f = this.startEdit;
                if (f != null) {
                    this.startEdit = null;
                    if (!f.isDone()) {
                        boolean ret = f.cancel(false);
                        return ret;
                    }
                }
                return true;
            }
        };
        this.tree.addListener(3, mouseEditListener);
        this.tree.addListener(29, mouseEditListener);
        this.tree.addListener(29, new Listener(){

            public void handleEvent(Event event) {
                Point test = new Point(event.x, event.y);
                TreeItem item = GraphExplorerImpl.this.tree.getItem(test);
                if (item != null) {
                    int i = 0;
                    while (i < GraphExplorerImpl.this.tree.getColumnCount()) {
                        Rectangle rect = item.getBounds(i);
                        if (rect.contains(test)) {
                            GraphExplorerImpl.this.tree.setData(GraphExplorerImpl.KEY_DRAG_COLUMN, (Object)i);
                            return;
                        }
                        ++i;
                    }
                }
                GraphExplorerImpl.this.tree.setData(GraphExplorerImpl.KEY_DRAG_COLUMN, (Object)-1);
            }
        });
        this.tree.addListener(5, new Listener(){

            public void handleEvent(Event event) {
                Point test = new Point(event.x, event.y);
                TreeItem item = GraphExplorerImpl.this.tree.getItem(test);
                if (item != null) {
                    int i = 0;
                    while (i < GraphExplorerImpl.this.tree.getColumnCount()) {
                        Rectangle rect = item.getBounds(i);
                        if (rect.contains(test)) {
                            GraphExplorerImpl.this.transientState.setActiveColumn(i);
                            return;
                        }
                        ++i;
                    }
                }
                GraphExplorerImpl.this.transientState.setActiveColumn(null);
            }
        });
        this.tree.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                GraphExplorerImpl.this.focusGainedAt = (long)e.time & 0xFFFFFFFFL;
                for (FocusListener listener : GraphExplorerImpl.this.focusListeners) {
                    listener.focusGained(e);
                }
            }

            public void focusLost(FocusEvent e) {
                for (FocusListener listener : GraphExplorerImpl.this.focusListeners) {
                    listener.focusLost(e);
                }
            }
        });
        this.tree.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                for (MouseListener listener : GraphExplorerImpl.this.mouseListeners) {
                    listener.mouseDoubleClick(e);
                }
            }

            public void mouseDown(MouseEvent e) {
                for (MouseListener listener : GraphExplorerImpl.this.mouseListeners) {
                    listener.mouseDown(e);
                }
            }

            public void mouseUp(MouseEvent e) {
                for (MouseListener listener : GraphExplorerImpl.this.mouseListeners) {
                    listener.mouseUp(e);
                }
            }
        });
        this.tree.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                for (KeyListener listener : GraphExplorerImpl.this.keyListeners) {
                    listener.keyPressed(e);
                }
            }

            public void keyReleased(KeyEvent e) {
                for (KeyListener listener : GraphExplorerImpl.this.keyListeners) {
                    listener.keyReleased(e);
                }
            }
        });
        this.tree.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                GraphExplorerImpl.this.widgetSelectionChanged(false);
            }
        });
        this.selectionProvider.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Set set = ISelectionUtils.filterSetSelection((Object)event.getSelection(), NodeContext.class);
                GraphExplorerImpl.this.selectedItems.clear();
                for (NodeContext nc : set) {
                    TreeItem item = (TreeItem)GraphExplorerImpl.this.contextToItem.getRight((Object)nc);
                    if (item == null) continue;
                    GraphExplorerImpl.this.selectedItems.put(item, nc);
                }
            }
        });
    }

    private void widgetSelectionChanged(boolean forceSelectionChange) {
        long modTime = System.currentTimeMillis();
        long delta = modTime - this.lastSelectionModTime;
        this.lastSelectionModTime = modTime;
        if (!forceSelectionChange && delta < 150L) {
            long msToWait = 150L - delta;
            this.selectionSetTargetTime = modTime + msToWait;
            if (!this.delayedSelectionScheduled) {
                this.delayedSelectionScheduled = true;
                this.tree.getDisplay().timerExec((int)msToWait, this.SELECTION_DELAY);
            }
            ++this.postSelectionModCount;
            return;
        }
        this.resetSelection();
    }

    private void resetSelection() {
        final ISelection selection = this.getWidgetSelection();
        this.selectionProvider.setAndFireNonEqualSelection(selection);
        final int count = ++this.postSelectionModCount;
        ThreadUtils.getNonBlockingWorkExecutor().schedule(new Runnable(){

            @Override
            public void run() {
                int newCount = GraphExplorerImpl.this.postSelectionModCount;
                if (newCount != count) {
                    return;
                }
                if (GraphExplorerImpl.this.tree.isDisposed()) {
                    return;
                }
                GraphExplorerImpl.this.tree.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if ((this).GraphExplorerImpl.this.tree.isDisposed() || (this).GraphExplorerImpl.this.selectionProvider == null) {
                            return;
                        }
                        (this).GraphExplorerImpl.this.selectionProvider.firePostSelection(selection);
                    }
                });
            }
        }, 300L, TimeUnit.MILLISECONDS);
    }

    protected void setDefaultProcessors() {
        this.setProcessor((NodeQueryProcessor)new DefaultComparableChildrenProcessor());
        this.setProcessor((NodeQueryProcessor)new DefaultLabelDecoratorsProcessor());
        this.setProcessor((NodeQueryProcessor)new DefaultImageDecoratorsProcessor());
        this.setProcessor((NodeQueryProcessor)new DefaultSelectedLabelerProcessor());
        this.setProcessor((NodeQueryProcessor)new DefaultLabelerFactoriesProcessor());
        this.setProcessor((NodeQueryProcessor)new DefaultSelectedImagerProcessor());
        this.setProcessor((NodeQueryProcessor)new DefaultImagerFactoriesProcessor());
        this.setPrimitiveProcessor((PrimitiveQueryProcessor)new DefaultLabelerProcessor());
        this.setPrimitiveProcessor((PrimitiveQueryProcessor)new DefaultCheckedStateProcessor());
        this.setPrimitiveProcessor((PrimitiveQueryProcessor)new DefaultImagerProcessor());
        this.setPrimitiveProcessor((PrimitiveQueryProcessor)new DefaultLabelDecoratorProcessor());
        this.setPrimitiveProcessor((PrimitiveQueryProcessor)new DefaultImageDecoratorProcessor());
        this.setPrimitiveProcessor((PrimitiveQueryProcessor)new NoSelectionRequestProcessor());
        this.setProcessor((NodeQueryProcessor)new DefaultFinalChildrenProcessor((GraphExplorer)this));
        this.setProcessor((NodeQueryProcessor)new DefaultHasChildrenProcessor());
        this.setProcessor((NodeQueryProcessor)new DefaultPrunedChildrenProcessor());
        this.setProcessor((NodeQueryProcessor)new DefaultSelectedViewpointProcessor());
        this.setProcessor((NodeQueryProcessor)new DefaultSelectedLabelDecoratorFactoriesProcessor());
        this.setProcessor((NodeQueryProcessor)new DefaultSelectedImageDecoratorFactoriesProcessor());
        this.setProcessor((NodeQueryProcessor)new DefaultViewpointContributionsProcessor());
        this.setPrimitiveProcessor((PrimitiveQueryProcessor)new DefaultViewpointProcessor());
        this.setPrimitiveProcessor((PrimitiveQueryProcessor)new DefaultViewpointContributionProcessor());
        this.setPrimitiveProcessor((PrimitiveQueryProcessor)new DefaultSelectedViewpointFactoryProcessor());
        this.setPrimitiveProcessor((PrimitiveQueryProcessor)new DefaultIsExpandedProcessor());
        this.setPrimitiveProcessor((PrimitiveQueryProcessor)new DefaultShowMaxChildrenProcessor());
    }

    public <T> void setProcessor(NodeQueryProcessor<T> processor) {
        this.assertNotDisposed();
        if (processor == null) {
            throw new IllegalArgumentException("null processor");
        }
        this.processors.put((NodeContext.CacheKey<?>)processor.getIdentifier(), (NodeQueryProcessor)processor);
    }

    public <T> void setPrimitiveProcessor(PrimitiveQueryProcessor<T> processor) {
        this.assertNotDisposed();
        if (processor == null) {
            throw new IllegalArgumentException("null processor");
        }
        PrimitiveQueryProcessor<T> oldProcessor = this.primitiveProcessors.put(processor.getIdentifier(), processor);
        if (oldProcessor instanceof ProcessorLifecycle) {
            ((ProcessorLifecycle)oldProcessor).detached((GraphExplorer)this);
        }
        if (processor instanceof ProcessorLifecycle) {
            ((ProcessorLifecycle)processor).attached((GraphExplorer)this);
        }
    }

    public <T> void setDataSource(DataSource<T> provider) {
        this.assertNotDisposed();
        if (provider == null) {
            throw new IllegalArgumentException("null provider");
        }
        this.dataSources.put(provider.getProvidedClass(), provider);
    }

    public <T> DataSource<T> removeDataSource(Class<T> forProvidedClass) {
        this.assertNotDisposed();
        if (forProvidedClass == null) {
            throw new IllegalArgumentException("null class");
        }
        return this.dataSources.remove(forProvidedClass);
    }

    public void setPersistor(StatePersistor persistor) {
        this.persistor = persistor;
    }

    public SelectionDataResolver getSelectionDataResolver() {
        return this.selectionDataResolver;
    }

    public void setSelectionDataResolver(SelectionDataResolver r) {
        this.selectionDataResolver = r;
    }

    public SelectionFilter getSelectionFilter() {
        return this.selectionFilter;
    }

    public void setSelectionFilter(SelectionFilter f) {
        this.selectionFilter = f;
    }

    public void setSelectionTransformation(BiFunction<GraphExplorer, Object[], Object[]> f) {
        this.selectionTransformation = f;
    }

    public <T> void addListener(T listener) {
        if (listener instanceof FocusListener) {
            this.focusListeners.add((FocusListener)listener);
        } else if (listener instanceof MouseListener) {
            this.mouseListeners.add((MouseListener)listener);
        } else if (listener instanceof KeyListener) {
            this.keyListeners.add((KeyListener)listener);
        }
    }

    public <T> void removeListener(T listener) {
        if (listener instanceof FocusListener) {
            this.focusListeners.remove(listener);
        } else if (listener instanceof MouseListener) {
            this.mouseListeners.remove(listener);
        } else if (listener instanceof KeyListener) {
            this.keyListeners.remove(listener);
        }
    }

    public void addSelectionListener(SelectionListener listener) {
        this.tree.addSelectionListener(listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.tree.removeSelectionListener(listener);
    }

    public void setUIContexts(Set<String> contexts) {
        this.uiContexts = contexts;
    }

    public void setRoot(Object root) {
        if (this.uiContexts != null && this.uiContexts.size() == 1) {
            this.setRootContext0(NodeContextBuilder.buildWithData((Object[])new Object[]{BuiltinKeys.INPUT, root, BuiltinKeys.UI_CONTEXT, this.uiContexts.iterator().next()}));
        } else {
            this.setRootContext0(NodeContextBuilder.buildWithData((Object[])new Object[]{BuiltinKeys.INPUT, root}));
        }
    }

    public void setRootContext(NodeContext context) {
        this.setRootContext0(context);
    }

    private void setRootContext0(final NodeContext context) {
        Assert.isNotNull((Object)context, (String)"root must not be null");
        if (this.isDisposed() || this.tree.isDisposed()) {
            return;
        }
        Display display = this.tree.getDisplay();
        if (display.getThread() == Thread.currentThread()) {
            this.doSetRoot(context);
        } else {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    GraphExplorerImpl.this.doSetRoot(context);
                }
            });
        }
    }

    private void initializeState() {
        if (this.persistor == null) {
            return;
        }
        ExplorerStates.scheduleRead((NodeContext)this.getRoot(), (StatePersistor)this.persistor).thenAccept(state -> {
            boolean bl = SWTUtils.asyncExec((Widget)this.tree, () -> this.restoreState((ExplorerState)state));
        });
    }

    private void restoreState(ExplorerState state) {
        PrimitiveQueryProcessor processor = this.getPrimitiveProcessor(BuiltinKeys.IS_EXPANDED);
        if (processor instanceof DefaultIsExpandedProcessor) {
            DefaultIsExpandedProcessor isExpandedProcessor = (DefaultIsExpandedProcessor)processor;
            for (NodeContext expanded : state.expandedNodes) {
                isExpandedProcessor.replaceExpanded(expanded, true);
            }
        }
    }

    private void saveState() {
        TreeColumn[] columns;
        PrimitiveQueryProcessor processor;
        NodeContext topNode;
        if (this.persistor == null) {
            return;
        }
        NodeContext[] topNodePath = NodeContext.NONE;
        int[] topNodePathChildIndex = new int[]{};
        Collection<Object> expandedNodes = Collections.emptyList();
        Map<String, Integer> columnWidths = Collections.emptyMap();
        TreeItem topItem = this.tree.getTopItem();
        if (topItem != null && (topNode = (NodeContext)topItem.getData()) != null) {
            topNodePath = this.getNodeContextPathSegments(topNode);
            topNodePathChildIndex = new int[topNodePath.length];
            int i = 0;
            while (i < topNodePath.length) {
                topNodePathChildIndex[i] = 0;
                ++i;
            }
        }
        if ((processor = this.getPrimitiveProcessor(BuiltinKeys.IS_EXPANDED)) instanceof IsExpandedProcessor) {
            IsExpandedProcessor isExpandedProcessor = (IsExpandedProcessor)processor;
            expandedNodes = isExpandedProcessor.getExpanded();
        }
        if ((columns = this.tree.getColumns()).length > 1) {
            columnWidths = new HashMap();
            int i = 0;
            while (i < columns.length) {
                columnWidths.put(columns[i].getText(), columns[i].getWidth());
                ++i;
            }
        }
        this.persistor.serialize(ExplorerStates.explorerStateLocation(), this.getRoot(), new ExplorerState(topNodePath, topNodePathChildIndex, expandedNodes, columnWidths));
    }

    private void doSetRoot(NodeContext root) {
        if (this.tree.isDisposed()) {
            return;
        }
        if (root.getConstant(BuiltinKeys.INPUT) == null) {
            ErrorLogger.defaultLogError((String)("root node context does not contain BuiltinKeys.INPUT key. Node = " + root), (Throwable)new Exception("trace"));
            return;
        }
        GraphExplorerContext oldContext = this.explorerContext;
        GraphExplorerContext newContext = new GraphExplorerContext();
        GENodeQueryManager manager = new GENodeQueryManager((IGraphExplorerContext)newContext, null, null, (UIElementReference)TreeItemReference.create(null));
        this.explorerContext = newContext;
        oldContext.safeDispose();
        this.toolTip.setGraphExplorerContext(this.explorerContext);
        this.clearPrimitiveProcessors();
        this.rootContext = root.getConstant(BuiltinKeys.IS_ROOT) != null ? root : NodeContextUtil.withConstant((NodeContext)root, (NodeContext.ConstantKey)BuiltinKeys.IS_ROOT, (Object)Boolean.TRUE);
        this.explorerContext.getCache().incRef(this.rootContext);
        this.initializeState();
        NodeContext[] contexts = (NodeContext[])manager.query(this.rootContext, BuiltinKeys.FINAL_CHILDREN);
        this.tree.setItemCount(contexts.length);
        this.select(this.rootContext);
        this.refreshColumnSizes();
    }

    public NodeContext getRoot() {
        return this.rootContext;
    }

    public NodeContext getParentContext(NodeContext context) {
        if (this.disposed) {
            throw new IllegalStateException("disposed");
        }
        if (!this.thread.currentThreadAccess()) {
            throw new IllegalStateException("not in SWT display thread " + this.thread.getThread());
        }
        TreeItem item = (TreeItem)this.contextToItem.getRight((Object)context);
        if (item == null) {
            return null;
        }
        TreeItem parentItem = item.getParentItem();
        if (parentItem == null) {
            return null;
        }
        return (NodeContext)parentItem.getData();
    }

    public void handleEvent(Event event) {
        switch (event.type) {
            case 17: {
                if ((this.tree.getStyle() & 0x10000000) != 0) {
                    this.expandVirtual(event);
                    break;
                }
                System.out.println("TODO: non-virtual tree item expand");
                break;
            }
            case 36: {
                if (this.disposed) {
                    return;
                }
                this.setData(event);
                break;
            }
            case 26: {
                if (this.activatedBefore) break;
                this.refreshColumnSizes();
                this.activatedBefore = true;
                break;
            }
            case 12: {
                if (this.disposed) {
                    return;
                }
                this.disposed = true;
                this.doDispose();
                break;
            }
            case 11: {
                if (event.widget == this.tree) {
                    Point size = this.tree.getSize();
                    int dx = 0;
                    if (this.previousTreeSize != null) {
                        dx = size.x - this.previousTreeSize.x;
                    }
                    this.previousTreeSize = size;
                    if (dx <= 0) break;
                    this.tree.setRedraw(false);
                    this.refreshColumnSizes(size);
                    this.tree.setRedraw(true);
                    break;
                }
                if (event.widget != this.tree.getParent()) break;
                Composite parent = this.tree.getParent();
                Point size = parent.getSize();
                size.x -= this.tree.getParent().getBorderWidth() * 2;
                ScrollBar vBar = parent.getVerticalBar();
                if (vBar != null && vBar.isVisible()) {
                    size.x -= vBar.getSize().x;
                }
                int dx = 0;
                if (this.previousTreeParentSize != null) {
                    dx = size.x - this.previousTreeParentSize.x;
                }
                this.previousTreeParentSize = size;
                if (dx >= 0) break;
                this.tree.setRedraw(false);
                this.refreshColumnSizes(size);
                this.tree.setRedraw(true);
                break;
            }
        }
    }

    protected void refreshColumnSizes() {
        Point size = this.tree.getSize();
        this.refreshColumnSizes(size);
        this.tree.getParent().layout();
    }

    protected void refreshColumnSizes(Point toSize) {
    }

    private void doDispose() {
        this.explorerContext.dispose();
        this.processors.clear();
        this.detachPrimitiveProcessors();
        this.primitiveProcessors.clear();
        this.dataSources.clear();
        this.pendingItems.clear();
        this.rootContext = null;
        this.contextToItem.clear();
        this.mouseListeners.clear();
        this.selectionProvider.clearListeners();
        this.selectionProvider = null;
        this.selectionDataResolver = null;
        this.selectionRefreshContexts.clear();
        this.selectedItems.clear();
        this.originalFont = null;
        this.localResourceManager.dispose();
        this.imageLoaderJob.dispose();
        this.imageLoaderJob.cancel();
        try {
            this.imageLoaderJob.join();
        }
        catch (InterruptedException e) {
            ErrorLogger.defaultLogError((Throwable)e);
        }
        this.resourceManager.dispose();
        this.postSelectionProvider.dispose();
    }

    private void expandVirtual(Event event) {
        int maxChildren;
        TreeItem item = (TreeItem)event.item;
        assert (item != null);
        NodeContext context = (NodeContext)item.getData();
        assert (context != null);
        GENodeQueryManager manager = new GENodeQueryManager((IGraphExplorerContext)this.explorerContext, null, null, (UIElementReference)TreeItemReference.create(item));
        NodeContext[] children = (NodeContext[])manager.query(context, BuiltinKeys.FINAL_CHILDREN);
        item.setItemCount(children.length < (maxChildren = this.getMaxChildren((NodeQueryManager)manager, context)) ? children.length : maxChildren);
    }

    private NodeContext getNodeContext(TreeItem item) {
        assert (item != null);
        NodeContext context = (NodeContext)item.getData();
        assert (context != null);
        return context;
    }

    private NodeContext getParentContext(TreeItem item) {
        TreeItem parentItem = item.getParentItem();
        if (parentItem != null) {
            return this.getNodeContext(parentItem);
        }
        return this.rootContext;
    }

    private void setData(Event event) {
        boolean currentlyVerticalBarVisible;
        ScrollBar verticalBar;
        NodeContext selectedContext;
        boolean isExpanded;
        assert (event != null);
        TreeItem item = (TreeItem)event.item;
        assert (item != null);
        if (item.isDisposed() || item.getData(PENDING) != null) {
            return;
        }
        GENodeQueryManager manager = new GENodeQueryManager((IGraphExplorerContext)this.explorerContext, null, null, (UIElementReference)TreeItemReference.create(item.getParentItem()));
        NodeContext parentContext = this.getParentContext(item);
        assert (parentContext != null);
        NodeContext[] parentChildren = (NodeContext[])manager.query(parentContext, BuiltinKeys.FINAL_CHILDREN);
        if (event.index < 0) {
            ErrorLogger.defaultLogError((String)("GraphExplorer.setData: how can event.index be < 0: " + event.index + " ??"), (Throwable)new Exception());
            return;
        }
        if (event.index >= parentChildren.length) {
            return;
        }
        NodeContext context = parentChildren[event.index];
        assert (context != null);
        item.setData((Object)context);
        this.contextToItem.map((Object)context, (Object)item);
        if (item.getData(LISTENER_SET_INDICATOR) == null) {
            item.setData(LISTENER_SET_INDICATOR, (Object)LISTENER_SET_INDICATOR);
            item.addListener(12, this.itemDisposeListener);
        }
        if ((isExpanded = ((Boolean)manager.query(context, BuiltinKeys.IS_EXPANDED)).booleanValue()) || item.getItemCount() > 1) {
            PrunedChildrenResult children = (PrunedChildrenResult)manager.query(context, BuiltinKeys.PRUNED_CHILDREN);
            int maxChildren = this.getMaxChildren((NodeQueryManager)manager, context);
            NodeContext[] pruned = children.getPrunedChildren();
            int count = Math.min(pruned.length, maxChildren);
            item.setItemCount(count);
            TreeItem[] childItems = item.getItems();
            int i = 0;
            while (i < count) {
                this.contextToItem.map((Object)pruned[i], (Object)childItems[i]);
                ++i;
            }
        } else {
            Boolean hasChildren = (Boolean)manager.query(context, BuiltinKeys.HAS_CHILDREN);
            item.setItemCount(hasChildren != false ? 1 : 0);
        }
        this.setTextAndImage(item, (NodeQueryManager)manager, context, event.index);
        if (!(this.autoExpandLevel != -1 && this.autoExpandLevel <= 1 || isExpanded)) {
            int level = this.getTreeItemLevel(item);
            if (!(this.autoExpandLevel != -1 && level > this.autoExpandLevel || this.explorerContext.autoExpanded.containsKey(context))) {
                this.explorerContext.autoExpanded.put(context, Boolean.TRUE);
                this.setExpanded(context, true);
            }
        }
        item.setExpanded(isExpanded);
        if ((this.tree.getStyle() & 0x20) != 0) {
            CheckedState checked = (CheckedState)manager.query(context, BuiltinKeys.IS_CHECKED);
            item.setChecked(CheckedState.CHECKED_STATES.contains(checked));
            item.setGrayed(CheckedState.GRAYED == checked);
        }
        if ((selectedContext = this.selectedItems.get(item)) != null && !selectedContext.equals(context)) {
            final int modCount = ++this.contextSelectionChangeModCount;
            ThreadUtils.asyncExec((IThreadWorkQueue)this.thread, (Runnable)new Runnable(){

                @Override
                public void run() {
                    if (GraphExplorerImpl.this.isDisposed()) {
                        return;
                    }
                    int count = GraphExplorerImpl.this.contextSelectionChangeModCount;
                    if (modCount != count) {
                        return;
                    }
                    GraphExplorerImpl.this.widgetSelectionChanged(true);
                }
            });
        }
        if (this.selectionRefreshContexts.remove(context)) {
            final ISelection currentSelection = this.selectionProvider.getSelection();
            ThreadUtils.asyncExec((IThreadWorkQueue)this.thread, (Runnable)new Runnable(){

                @Override
                public void run() {
                    if (GraphExplorerImpl.this.isDisposed()) {
                        return;
                    }
                    GraphExplorerImpl.this.setSelection(currentSelection, true);
                }
            });
        }
        if ((verticalBar = this.tree.getVerticalBar()) != null && this.verticalBarVisible != (currentlyVerticalBarVisible = verticalBar.isVisible())) {
            this.verticalBarVisible = currentlyVerticalBarVisible;
            Composite parent = this.tree.getParent();
            if (parent != null) {
                parent.layout();
            }
        }
    }

    private int getTreeItemLevel(TreeItem item) {
        if (item == null) {
            return 0;
        }
        int level = 1;
        TreeItem parent = item;
        while (parent != null) {
            parent = parent.getParentItem();
            ++level;
        }
        return level;
    }

    private NodeContext[] getNodeContextPathSegments(NodeContext node) {
        TreeItem item = (TreeItem)this.contextToItem.getRight((Object)node);
        if (item == null) {
            return NodeContext.NONE;
        }
        int level = this.getTreeItemLevel(item);
        if (level == 0) {
            return NodeContext.NONE;
        }
        NodeContext[] segments = new NodeContext[--level];
        TreeItem parent = item;
        while (parent != null) {
            NodeContext ctx = (NodeContext)item.getData();
            if (ctx == null) {
                return NodeContext.NONE;
            }
            segments[level - 1] = ctx;
            parent = parent.getParentItem();
            --level;
        }
        return segments;
    }

    private NodeContextPath getNodeContextPath(NodeContext node) {
        NodeContext[] path = this.getNodeContextPathSegments(node);
        return new NodeContextPath(path);
    }

    void setImage(NodeContext node, TreeItem item, Imager imager, Collection<ImageDecorator> decorators, int itemIndex) {
        Object[] images = this.columnImageArray;
        Arrays.fill(images, null);
        if (imager == null) {
            item.setImage((Image[])images);
            return;
        }
        Object[] descOrImage = this.columnDescOrImageArray;
        Arrays.fill(descOrImage, null);
        boolean finishLoadingInJob = false;
        int index = 0;
        Column[] columnArray = this.columns;
        int n = this.columns.length;
        int n2 = 0;
        while (n2 < n) {
            Column column = columnArray[n2];
            String key = column.getKey();
            ImageDescriptor desc = (ImageDescriptor)imager.getImage(key);
            if (desc != null) {
                Object img;
                if (!decorators.isEmpty()) {
                    for (ImageDecorator id : decorators) {
                        ImageDescriptor ds = (ImageDescriptor)id.decorateImage((Object)desc, key, itemIndex);
                        if (ds == null) continue;
                        desc = ds;
                    }
                }
                if ((img = this.localResourceManager.find((DeviceResourceDescriptor)desc)) == null) {
                    img = this.resourceManager.find((DeviceResourceDescriptor)desc);
                }
                images[index] = img != null ? (Image)img : null;
                descOrImage[index] = img == null ? desc : img;
                finishLoadingInJob |= img == null;
            }
            ++index;
            ++n2;
        }
        if (finishLoadingInJob) {
            int c = 0;
            while (c < this.columns.length) {
                Image img = item.getImage(c);
                if (img != null) {
                    images[c] = img;
                }
                ++c;
            }
            item.setImage((Image[])images);
            this.queueImageTask(item, new ImageTask(node, item, Arrays.copyOf(descOrImage, descOrImage.length)));
        } else {
            item.setImage((Image[])images);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueImageTask(TreeItem item, ImageTask task) {
        Map<TreeItem, ImageTask> map = this.imageTasks;
        synchronized (map) {
            this.imageTasks.put(item, task);
        }
        this.imageLoaderJob.scheduleIfNecessary(100L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IStatus setPendingImages(IProgressMonitor monitor) {
        ImageTask[] tasks = null;
        Map<TreeItem, ImageTask> map = this.imageTasks;
        synchronized (map) {
            tasks = this.imageTasks.values().toArray(new ImageTask[this.imageTasks.size()]);
            this.imageTasks.clear();
        }
        if (tasks.length == 0) {
            return Status.OK_STATUS;
        }
        IStatus status = null;
        ImageTask[] imageTaskArray = tasks;
        int n = tasks.length;
        int n2 = 0;
        while (n2 < n) {
            ImageTask task = imageTaskArray[n2];
            Object[] descs = task.descsOrImages;
            int i = 0;
            while (i < descs.length) {
                Object obj = descs[i];
                if (obj instanceof ImageDescriptor) {
                    ImageDescriptor desc = (ImageDescriptor)obj;
                    try {
                        descs[i] = this.resourceManager.get((DeviceResourceDescriptor)desc);
                    }
                    catch (DeviceResourceException e) {
                        if (status == null) {
                            status = new MultiStatus("org.simantics.browsing.ui.swt", 0, "Problems loading images:", null);
                        }
                        status.add((IStatus)new Status(4, "org.simantics.browsing.ui.swt", "Image descriptor loading failed: " + desc, (Throwable)e));
                    }
                }
                ++i;
            }
            ++n2;
        }
        final ImageTask[] _tasks = tasks;
        this.thread.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!GraphExplorerImpl.this.tree.isDisposed()) {
                    GraphExplorerImpl.this.tree.setRedraw(false);
                    GraphExplorerImpl.this.setImages(_tasks);
                    GraphExplorerImpl.this.tree.setRedraw(true);
                }
            }
        });
        return status != null ? status : Status.OK_STATUS;
    }

    void setImages(ImageTask[] tasks) {
        ImageTask[] imageTaskArray = tasks;
        int n = tasks.length;
        int n2 = 0;
        while (n2 < n) {
            ImageTask task = imageTaskArray[n2];
            if (task != null) {
                this.setImage(task);
            }
            ++n2;
        }
    }

    void setImage(ImageTask task) {
        if (task.item.isDisposed()) {
            return;
        }
        if (!this.contextToItem.contains((Object)task.node, (Object)task.item)) {
            return;
        }
        Object[] descs = task.descsOrImages;
        Object[] images = this.columnImageArray;
        Arrays.fill(images, null);
        int i = 0;
        while (i < descs.length) {
            Object desc = descs[i];
            if (desc instanceof Image) {
                images[i] = (Image)desc;
            }
            ++i;
        }
        task.item.setImage((Image[])images);
    }

    void setText(TreeItem item, Labeler labeler, Collection<LabelDecorator> decorators, int itemIndex) {
        if (labeler != null) {
            String[] texts = new String[this.columns.length];
            int index = 0;
            Map labels = labeler.getLabels();
            Map runtimeLabels = labeler.getRuntimeLabels();
            Column[] columnArray = this.columns;
            int n = this.columns.length;
            int n2 = 0;
            while (n2 < n) {
                Column column = columnArray[n2];
                String key = column.getKey();
                String s = null;
                if (runtimeLabels != null) {
                    s = (String)runtimeLabels.get(key);
                }
                if (s == null) {
                    s = (String)labels.get(key);
                }
                if (s != null) {
                    FontDescriptor font = this.originalFont;
                    ColorDescriptor bg = this.originalBackground;
                    ColorDescriptor fg = this.originalForeground;
                    if (!decorators.isEmpty()) {
                        for (LabelDecorator ld : decorators) {
                            ColorDescriptor dfg;
                            ColorDescriptor dbg;
                            FontDescriptor dfont;
                            String ds = ld.decorateLabel(s, key, itemIndex);
                            if (ds != null) {
                                s = ds;
                            }
                            if ((dfont = (FontDescriptor)ld.decorateFont((Object)font, key, itemIndex)) != null) {
                                font = dfont;
                            }
                            if ((dbg = (ColorDescriptor)ld.decorateBackground((Object)bg, key, itemIndex)) != null) {
                                bg = dbg;
                            }
                            if ((dfg = (ColorDescriptor)ld.decorateForeground((Object)fg, key, itemIndex)) == null) continue;
                            fg = dfg;
                        }
                    }
                    if (font != this.originalFont) {
                        item.setFont(index, (Font)this.localResourceManager.get((DeviceResourceDescriptor)font));
                    }
                    if (bg != this.originalBackground) {
                        item.setBackground(index, (Color)this.localResourceManager.get((DeviceResourceDescriptor)bg));
                    }
                    if (fg != this.originalForeground) {
                        item.setForeground(index, (Color)this.localResourceManager.get((DeviceResourceDescriptor)fg));
                    }
                    texts[index] = s;
                }
                ++index;
                ++n2;
            }
            item.setText(texts);
        } else {
            item.setText("<no label>");
        }
    }

    void setTextAndImage(TreeItem item, NodeQueryManager manager, NodeContext context, int itemIndex) {
        Labeler labeler = (Labeler)manager.query(context, BuiltinKeys.SELECTED_LABELER);
        if (labeler != null) {
            labeler.setListener(this.labelListener);
        }
        Imager imager = (Imager)manager.query(context, BuiltinKeys.SELECTED_IMAGER);
        Collection labelDecorators = (Collection)manager.query(context, BuiltinKeys.LABEL_DECORATORS);
        Collection imageDecorators = (Collection)manager.query(context, BuiltinKeys.IMAGE_DECORATORS);
        this.setText(item, labeler, labelDecorators, itemIndex);
        this.setImage(context, item, imager, imageDecorators, itemIndex);
    }

    public void setFocus() {
        this.tree.setFocus();
    }

    public <T> T query(NodeContext context, NodeContext.CacheKey<T> key) {
        return (T)this.explorerContext.cache.get(context, key);
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    protected void assertNotDisposed() {
        if (this.isDisposed()) {
            throw new IllegalStateException("disposed");
        }
    }

    public void setSelection(final ISelection selection, boolean forceControlUpdate) {
        this.assertNotDisposed();
        boolean equalsOld = this.selectionProvider.selectionEquals(selection);
        if (equalsOld && !forceControlUpdate) {
            this.selectionProvider.setSelection(selection);
        } else {
            if (this.tree.isDisposed()) {
                return;
            }
            Display d = this.tree.getDisplay();
            if (d.getThread() == Thread.currentThread()) {
                this.updateSelectionToControl(selection);
            } else {
                d.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (GraphExplorerImpl.this.tree.isDisposed()) {
                            return;
                        }
                        GraphExplorerImpl.this.updateSelectionToControl(selection);
                    }
                });
            }
        }
    }

    private void updateSelectionToControl(ISelection selection) {
        if (this.selectionDataResolver == null) {
            return;
        }
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection iss = (IStructuredSelection)selection;
        final THashMap statusMap = new THashMap(iss.size());
        for (Object selectionElement : iss) {
            Object resolvedElement = this.selectionDataResolver.resolve(selectionElement);
            statusMap.put(resolvedElement, (Object)new SelectionResolutionStatus());
        }
        this.iterateTreeItems(new TObjectProcedure<TreeItem>(){

            public boolean execute(TreeItem treeItem) {
                NodeContext nodeContext = (NodeContext)treeItem.getData();
                if (nodeContext == null) {
                    return true;
                }
                SelectionResolutionStatus status = (SelectionResolutionStatus)statusMap.get((Object)nodeContext);
                if (status != null) {
                    status.bestPriority = 0;
                    status.bestItem = treeItem;
                    return true;
                }
                Object input = nodeContext.getConstant(BuiltinKeys.INPUT);
                status = (SelectionResolutionStatus)statusMap.get(input);
                if (status != null) {
                    int curPriority;
                    NodeType nodeType = (NodeType)nodeContext.getConstant(NodeType.TYPE);
                    int n = curPriority = nodeType instanceof EntityNodeType ? 1 : 2;
                    if (curPriority < status.bestPriority) {
                        status.bestPriority = curPriority;
                        status.bestItem = treeItem;
                    }
                }
                return true;
            }
        });
        ArrayList<TreeItem> items = new ArrayList<TreeItem>(statusMap.size());
        for (SelectionResolutionStatus status : statusMap.values()) {
            if (status.bestItem == null) continue;
            items.add(status.bestItem);
        }
        this.select(items.toArray(new TreeItem[items.size()]));
    }

    public ISelection getWidgetSelection() {
        TreeItem[] items = this.tree.getSelection();
        if (items.length == 0) {
            return StructuredSelection.EMPTY;
        }
        ArrayList<NodeContext> nodes = new ArrayList<NodeContext>(items.length);
        GENodeQueryManager manager = null;
        NodeContext lastParentContext = null;
        NodeContext[] lastChildren = null;
        int i = 0;
        while (i < items.length) {
            TreeItem item = items[i];
            NodeContext ctx = (NodeContext)item.getData();
            if (ctx != null) {
                nodes.add(ctx);
            } else {
                NodeContext parentContext;
                TreeItem parentItem = item.getParentItem();
                NodeContext nodeContext = parentContext = parentItem != null ? this.getNodeContext(parentItem) : this.rootContext;
                if (parentContext != null) {
                    NodeContext child;
                    int index;
                    NodeContext[] children = lastChildren;
                    if (parentContext != lastParentContext) {
                        if (manager == null) {
                            manager = new GENodeQueryManager((IGraphExplorerContext)this.explorerContext, null, null, null);
                        }
                        lastChildren = children = (NodeContext[])manager.query(parentContext, BuiltinKeys.FINAL_CHILDREN);
                        lastParentContext = parentContext;
                    }
                    int n = index = parentItem != null ? parentItem.indexOf(item) : this.tree.indexOf(item);
                    if (index >= 0 && index < children.length && (child = children[index]) != null) {
                        nodes.add(child);
                        item.setData((Object)child);
                    }
                }
            }
            ++i;
        }
        ISelection selection = this.constructSelection(nodes.toArray(NodeContext.NONE));
        return selection;
    }

    public GraphExplorer.TransientExplorerState getTransientState() {
        if (!this.thread.currentThreadAccess()) {
            throw new AssertionError((Object)(String.valueOf(this.getClass().getSimpleName()) + ".getActiveColumn called from non SWT-thread: " + Thread.currentThread()));
        }
        return this.transientState;
    }

    private void select(TreeItem item) {
        this.tree.setSelection(item);
        this.tree.showSelection();
        this.selectionProvider.setAndFireNonEqualSelection(this.constructSelection((NodeContext)item.getData()));
    }

    private void select(TreeItem[] items) {
        this.tree.setSelection(items);
        this.tree.showSelection();
        NodeContext[] data = new NodeContext[items.length];
        int i = 0;
        while (i < data.length) {
            data[i] = (NodeContext)items[i].getData();
            ++i;
        }
        this.selectionProvider.setAndFireNonEqualSelection(this.constructSelection(data));
    }

    private void iterateTreeItems(TObjectProcedure<TreeItem> procedure) {
        TreeItem[] treeItemArray = this.tree.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            if (!this.iterateTreeItems(item, procedure)) {
                return;
            }
            ++n2;
        }
    }

    private boolean iterateTreeItems(TreeItem item, TObjectProcedure<TreeItem> procedure) {
        if (!procedure.execute((Object)item)) {
            return false;
        }
        if (item.getExpanded()) {
            TreeItem[] treeItemArray = item.getItems();
            int n = treeItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem child = treeItemArray[n2];
                if (!this.iterateTreeItems(child, procedure)) {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    private boolean trySelect(TreeItem item, Object input) {
        NodeContext itemCtx = (NodeContext)item.getData();
        if (itemCtx != null && input.equals(itemCtx.getConstant(BuiltinKeys.INPUT))) {
            this.select(item);
            return true;
        }
        if (item.getExpanded()) {
            TreeItem[] treeItemArray = item.getItems();
            int n = treeItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem child = treeItemArray[n2];
                if (this.trySelect(child, input)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private boolean equalsEnough(NodeContext c1, NodeContext c2) {
        Object type2;
        Object input2;
        Object input1 = c1.getConstant(BuiltinKeys.INPUT);
        if (!ObjectUtils.objectEquals((Object)input1, (Object)(input2 = c2.getConstant(BuiltinKeys.INPUT)))) {
            return false;
        }
        Object type1 = c1.getConstant(NodeType.TYPE);
        return ObjectUtils.objectEquals((Object)type1, (Object)(type2 = c2.getConstant(NodeType.TYPE)));
    }

    private NodeContext tryFind(NodeContext context) {
        TreeItem[] treeItemArray = this.tree.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            NodeContext found = this.tryFind(item, context);
            if (found != null) {
                return found;
            }
            ++n2;
        }
        return null;
    }

    private NodeContext tryFind(TreeItem item, NodeContext context) {
        NodeContext itemCtx = (NodeContext)item.getData();
        if (itemCtx != null && this.equalsEnough(context, itemCtx)) {
            return itemCtx;
        }
        if (item.getExpanded()) {
            TreeItem[] treeItemArray = item.getItems();
            int n = treeItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem child = treeItemArray[n2];
                NodeContext found = this.tryFind(child, context);
                if (found != null) {
                    return found;
                }
                ++n2;
            }
        }
        return null;
    }

    public boolean select(NodeContext context) {
        this.assertNotDisposed();
        if (context == null || context.equals(this.rootContext)) {
            this.tree.deselectAll();
            this.selectionProvider.setAndFireNonEqualSelection((ISelection)TreeSelection.EMPTY);
            return true;
        }
        Object input = context.getConstant(BuiltinKeys.INPUT);
        TreeItem[] treeItemArray = this.tree.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            if (this.trySelect(item, input)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private NodeContext tryFind2(NodeContext context) {
        Set ctxs = this.contextToItem.getLeftSet();
        for (NodeContext c : ctxs) {
            if (!this.equalsEnough(c, context)) continue;
            return c;
        }
        return null;
    }

    private boolean waitVisible(NodeContext parent, NodeContext context) {
        long duration;
        long start = System.nanoTime();
        TreeItem parentItem = (TreeItem)this.contextToItem.getRight((Object)parent);
        if (parentItem == null) {
            return false;
        }
        do {
            NodeContext target;
            if ((target = this.tryFind2(context)) != null) {
                TreeItem item = (TreeItem)this.contextToItem.getRight((Object)target);
                if (!item.getParentItem().equals(parentItem)) {
                    return false;
                }
                this.tree.setTopItem(item);
                return true;
            }
            Display.getCurrent().readAndDispatch();
        } while (!((double)(duration = System.nanoTime() - start) > 1.0E10));
        return false;
    }

    private boolean selectPathInternal(NodeContext[] contexts, int position) {
        NodeContext head = this.tryFind(contexts[position]);
        if (head == null) {
            return false;
        }
        if (position == contexts.length - 1) {
            return this.select(head);
        }
        if (!this.waitVisible(head, contexts[position + 1])) {
            return false;
        }
        this.setExpanded(head, true);
        return this.selectPathInternal(contexts, position + 1);
    }

    public boolean selectPath(Collection<NodeContext> contexts) {
        if (contexts == null) {
            throw new IllegalArgumentException("Null list is not allowed");
        }
        if (contexts.isEmpty()) {
            throw new IllegalArgumentException("Empty list is not allowed");
        }
        return this.selectPathInternal(contexts.toArray(new NodeContext[contexts.size()]), 0);
    }

    public boolean isVisible(NodeContext context) {
        TreeItem[] treeItemArray = this.tree.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            NodeContext found = this.tryFind(item, context);
            if (found != null) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected ISelection constructSelection(NodeContext ... contexts) {
        if (contexts == null) {
            throw new IllegalArgumentException("null contexts");
        }
        if (contexts.length == 0) {
            return StructuredSelection.EMPTY;
        }
        if (this.selectionFilter == null) {
            return new StructuredSelection(this.transformSelection(contexts));
        }
        return new StructuredSelection(this.transformSelection(GraphExplorerImpl.filter(this.selectionFilter, contexts)));
    }

    protected Object[] transformSelection(Object[] objects) {
        return this.selectionTransformation.apply(this, objects);
    }

    protected static Object[] filter(SelectionFilter filter, NodeContext[] contexts) {
        int len = contexts.length;
        Object[] objects = new Object[len];
        int i = 0;
        while (i < len) {
            objects[i] = filter.filter(contexts[i]);
            ++i;
        }
        return objects;
    }

    public void setExpanded(final NodeContext context, final boolean expanded) {
        this.assertNotDisposed();
        ThreadUtils.asyncExec((IThreadWorkQueue)this.thread, (Runnable)new Runnable(){

            @Override
            public void run() {
                if (!GraphExplorerImpl.this.isDisposed()) {
                    GraphExplorerImpl.this.doSetExpanded(context, expanded);
                }
            }
        });
    }

    private void doSetExpanded(NodeContext context, boolean expanded) {
        PrimitiveQueryProcessor pqp;
        TreeItem item = (TreeItem)this.contextToItem.getRight((Object)context);
        if (item != null) {
            item.setExpanded(expanded);
        }
        if ((pqp = this.explorerContext.getPrimitiveProcessor(BuiltinKeys.IS_EXPANDED)) instanceof IsExpandedProcessor) {
            IsExpandedProcessor iep = (IsExpandedProcessor)pqp;
            iep.replaceExpanded(context, expanded);
        }
    }

    public void setColumnsVisible(boolean visible) {
        this.columnsAreVisible = visible;
        if (this.tree != null) {
            this.tree.setHeaderVisible(this.columnsAreVisible);
        }
    }

    public void setColumns(Column[] columns) {
        this.setColumns(columns, null);
    }

    public void setColumns(Column[] columns, Consumer<Map<Column, Object>> callback) {
        this.assertNotDisposed();
        this.checkUniqueColumnKeys(columns);
        Display d = this.tree.getDisplay();
        if (d.getThread() == Thread.currentThread()) {
            this.doSetColumns(columns, callback);
        } else {
            d.asyncExec(() -> {
                if (this.tree.isDisposed()) {
                    return;
                }
                this.doSetColumns(columns, callback);
            });
        }
    }

    private void checkUniqueColumnKeys(Column[] cols) {
        HashSet<String> usedColumnKeys = new HashSet<String>();
        ArrayList<Column> duplicateColumns = new ArrayList<Column>();
        Column[] columnArray = cols;
        int n = cols.length;
        int n2 = 0;
        while (n2 < n) {
            Column c = columnArray[n2];
            if (!usedColumnKeys.add(c.getKey())) {
                duplicateColumns.add(c);
            }
            ++n2;
        }
        if (!duplicateColumns.isEmpty()) {
            throw new IllegalArgumentException("All columns do not have unique keys: " + cols + ", overlapping: " + duplicateColumns);
        }
    }

    private void doSetColumns(Column[] cols, Consumer<Map<Column, Object>> callback) {
        HashMap<String, Integer> prevWidths = new HashMap<String, Integer>();
        TreeColumn[] treeColumnArray = this.tree.getColumns();
        int n = treeColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeColumn column = treeColumnArray[n2];
            Column c = (Column)column.getData();
            if (c != null) {
                prevWidths.put(c.getKey(), column.getWidth());
                column.dispose();
            }
            ++n2;
        }
        HashMap<String, Integer> keyToIndex = new HashMap<String, Integer>();
        int i = 0;
        while (i < cols.length) {
            keyToIndex.put(cols[i].getKey(), i);
            ++i;
        }
        this.columns = Arrays.copyOf(cols, cols.length);
        this.columnKeyToIndex = keyToIndex;
        this.columnImageArray = new Image[cols.length];
        this.columnDescOrImageArray = new Object[cols.length];
        HashMap<Column, TreeColumn> map = new HashMap<Column, TreeColumn>();
        this.tree.setHeaderVisible(this.columnsAreVisible);
        Column[] columnArray = this.columns;
        int n3 = this.columns.length;
        int n4 = 0;
        while (n4 < n3) {
            Column column = columnArray[n4];
            TreeColumn c = new TreeColumn(this.tree, this.toSWT(column.getAlignment()));
            map.put(column, c);
            c.setData((Object)column);
            c.setText(column.getLabel());
            c.setToolTipText(column.getTooltip());
            int cw = column.getWidth();
            Integer w = (Integer)prevWidths.get(column.getKey());
            if (w != null) {
                c.setWidth(w.intValue());
            } else if (cw != -1) {
                c.setWidth(cw);
            } else if ("Property".equals(column.getKey())) {
                c.setWidth(150);
            } else {
                c.setWidth(50);
            }
            ++n4;
        }
        if (callback != null) {
            callback.accept(map);
        }
        SWTUtils.asyncExec((Widget)this.tree, () -> {
            if (!this.tree.isDisposed()) {
                this.refreshColumnSizes();
            }
        });
    }

    int toSWT(Column.Align alignment) {
        switch (alignment) {
            case LEFT: {
                return 16384;
            }
            case CENTER: {
                return 0x1000000;
            }
            case RIGHT: {
                return 131072;
            }
        }
        throw new Error("unhandled alignment: " + alignment);
    }

    public Column[] getColumns() {
        return Arrays.copyOf(this.columns, this.columns.length);
    }

    private void detachPrimitiveProcessors() {
        for (PrimitiveQueryProcessor p : this.primitiveProcessors.values()) {
            if (!(p instanceof ProcessorLifecycle)) continue;
            ((ProcessorLifecycle)p).detached((GraphExplorer)this);
        }
    }

    private void clearPrimitiveProcessors() {
        for (PrimitiveQueryProcessor p : this.primitiveProcessors.values()) {
            if (!(p instanceof ProcessorLifecycle)) continue;
            ((ProcessorLifecycle)p).clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleImmediateLabelRefresh() {
        Runnable[] runnables = null;
        Map<NodeContext, Runnable> map = this.labelRefreshRunnables;
        synchronized (map) {
            if (this.labelRefreshRunnables.isEmpty()) {
                return;
            }
            runnables = this.labelRefreshRunnables.values().toArray(new Runnable[this.labelRefreshRunnables.size()]);
            this.labelRefreshRunnables.clear();
            this.refreshIsQueued = false;
        }
        final Runnable[] rs = runnables;
        if (this.tree.isDisposed()) {
            return;
        }
        this.tree.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (GraphExplorerImpl.this.tree.isDisposed()) {
                    return;
                }
                GraphExplorerImpl.this.tree.setRedraw(false);
                Runnable[] runnableArray = rs;
                int n = rs.length;
                int n2 = 0;
                while (n2 < n) {
                    Runnable r = runnableArray[n2];
                    r.run();
                    ++n2;
                }
                GraphExplorerImpl.this.tree.setRedraw(true);
            }
        });
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (ISelectionProvider.class == adapter) {
            return (T)this.postSelectionProvider;
        }
        if (IPostSelectionProvider.class == adapter) {
            return (T)this.postSelectionProvider;
        }
        return null;
    }

    public <T> T getControl() {
        return (T)this.tree;
    }

    public void setAutoExpandLevel(int level) {
        this.autoExpandLevel = level;
    }

    public <T> NodeQueryProcessor<T> getProcessor(NodeContext.QueryKey<T> key) {
        return this.explorerContext.getProcessor(key);
    }

    public <T> PrimitiveQueryProcessor<T> getPrimitiveProcessor(NodeContext.PrimitiveQueryKey<T> key) {
        return this.explorerContext.getPrimitiveProcessor(key);
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        if (!this.thread.currentThreadAccess()) {
            throw new IllegalStateException("not in SWT display thread " + this.thread.getThread());
        }
        this.editable = editable;
        Display display = this.tree.getDisplay();
        this.tree.setBackground(editable ? null : display.getSystemColor(22));
    }

    public void setServiceLocator(IServiceLocator serviceLocator) {
        if (serviceLocator == null && PlatformUI.isWorkbenchRunning()) {
            serviceLocator = PlatformUI.getWorkbench();
        }
        this.serviceLocator = serviceLocator;
        if (serviceLocator != null) {
            this.contextService = (IContextService)serviceLocator.getService(IContextService.class);
            this.focusService = (IFocusService)serviceLocator.getService(IFocusService.class);
        }
    }

    public Object getClicked(Object event) {
        Point point;
        MouseEvent e = (MouseEvent)event;
        Tree tree = (Tree)e.getSource();
        TreeItem item = tree.getItem(point = new Point(e.x, e.y));
        if (item == null) {
            return null;
        }
        Object data = item.getData();
        return data;
    }

    class GraphExplorerContext
    extends AbstractDisposable
    implements IGraphExplorerContext {
        int queryIndent = 0;
        GECache cache = new GECache();
        AtomicBoolean propagating = new AtomicBoolean(false);
        Object propagateList = new Object();
        Object propagate = new Object();
        List<Runnable> scheduleList = new ArrayList<Runnable>();
        final Deque<Integer> activity = new LinkedList<Integer>();
        int activityInt = 0;
        AtomicReference<Runnable> currentQueryUpdater = new AtomicReference();
        Map<NodeContext, Boolean> autoExpanded = new WeakHashMap<NodeContext, Boolean>();
        Runnable QUERY_UPDATE_SCHEDULER = new Runnable(){

            @Override
            public void run() {
                Runnable r = GraphExplorerContext.this.currentQueryUpdater.getAndSet(null);
                if (r != null) {
                    r.run();
                }
            }
        };

        GraphExplorerContext() {
        }

        protected void doDispose() {
            GraphExplorerImpl.this.saveState();
            this.autoExpanded.clear();
        }

        public IGECache getCache() {
            return this.cache;
        }

        public int queryIndent() {
            return this.queryIndent;
        }

        public int queryIndent(int offset) {
            this.queryIndent += offset;
            return this.queryIndent;
        }

        public <T> NodeQueryProcessor<T> getProcessor(Object o) {
            return GraphExplorerImpl.this.processors.get(o);
        }

        public <T> PrimitiveQueryProcessor<T> getPrimitiveProcessor(Object o) {
            return GraphExplorerImpl.this.primitiveProcessors.get(o);
        }

        public <T> DataSource<T> getDataSource(Class<T> clazz) {
            return GraphExplorerImpl.this.dataSources.get(clazz);
        }

        public void update(UIElementReference ref) {
            TreeItemReference tiref = (TreeItemReference)ref;
            TreeItem item = tiref.getItem();
            GraphExplorerImpl.this.update(item);
        }

        public Object getPropagateLock() {
            return this.propagate;
        }

        public Object getPropagateListLock() {
            return this.propagateList;
        }

        public boolean isPropagating() {
            return this.propagating.get();
        }

        public void setPropagating(boolean b) {
            this.propagating.set(b);
        }

        public List<Runnable> getScheduleList() {
            return this.scheduleList;
        }

        public void setScheduleList(List<Runnable> list) {
            this.scheduleList = list;
        }

        public Deque<Integer> getActivity() {
            return this.activity;
        }

        public void setActivityInt(int i) {
            this.activityInt = i;
        }

        public int getActivityInt() {
            return this.activityInt;
        }

        public void scheduleQueryUpdate(Runnable r) {
            if (GraphExplorerImpl.this.isDisposed() || GraphExplorerImpl.this.queryUpdateScheduler.isShutdown()) {
                return;
            }
            if (this.currentQueryUpdater.compareAndSet(null, r)) {
                GraphExplorerImpl.this.queryUpdateScheduler.execute(this.QUERY_UPDATE_SCHEDULER);
            }
        }
    }

    private static class GraphExplorerPostSelectionProvider
    implements IPostSelectionProvider {
        private GraphExplorerImpl ge;

        GraphExplorerPostSelectionProvider(GraphExplorerImpl ge) {
            this.ge = ge;
        }

        void dispose() {
            this.ge = null;
        }

        public void setSelection(ISelection selection) {
            if (this.ge == null) {
                return;
            }
            this.ge.setSelection(selection, false);
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            if (this.ge == null) {
                return;
            }
            if (this.ge.isDisposed()) {
                return;
            }
            this.ge.selectionProvider.removeSelectionChangedListener(listener);
        }

        public void addPostSelectionChangedListener(ISelectionChangedListener listener) {
            if (this.ge == null) {
                return;
            }
            if (!this.ge.thread.currentThreadAccess()) {
                throw new AssertionError((Object)(String.valueOf(this.getClass().getSimpleName()) + ".addPostSelectionChangedListener called from non SWT-thread: " + Thread.currentThread()));
            }
            if (this.ge.isDisposed()) {
                System.out.println("Client BUG: GraphExplorerImpl is disposed in addPostSelectionChangedListener: " + listener);
                return;
            }
            this.ge.selectionProvider.addPostSelectionChangedListener(listener);
        }

        public void removePostSelectionChangedListener(ISelectionChangedListener listener) {
            if (this.ge == null) {
                return;
            }
            if (this.ge.isDisposed()) {
                return;
            }
            this.ge.selectionProvider.removePostSelectionChangedListener(listener);
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            if (this.ge == null) {
                return;
            }
            if (!this.ge.thread.currentThreadAccess()) {
                throw new AssertionError((Object)(String.valueOf(this.getClass().getSimpleName()) + ".addSelectionChangedListener called from non SWT-thread: " + Thread.currentThread()));
            }
            if (this.ge.tree.isDisposed() || this.ge.selectionProvider == null) {
                System.out.println("Client BUG: GraphExplorerImpl is disposed in addSelectionChangedListener: " + listener);
                return;
            }
            this.ge.selectionProvider.addSelectionChangedListener(listener);
        }

        public ISelection getSelection() {
            if (this.ge == null) {
                return StructuredSelection.EMPTY;
            }
            if (!this.ge.thread.currentThreadAccess()) {
                throw new AssertionError((Object)(String.valueOf(this.getClass().getSimpleName()) + ".getSelection called from non SWT-thread: " + Thread.currentThread()));
            }
            if (this.ge.tree.isDisposed() || this.ge.selectionProvider == null) {
                return StructuredSelection.EMPTY;
            }
            return this.ge.selectionProvider.getSelection();
        }
    }

    static class ImageTask {
        NodeContext node;
        TreeItem item;
        Object[] descsOrImages;

        public ImageTask(NodeContext node, TreeItem item, Object[] descsOrImages) {
            this.node = node;
            this.item = item;
            this.descsOrImages = descsOrImages;
        }
    }

    private static class SelectionResolutionStatus {
        int bestPriority = Integer.MAX_VALUE;
        TreeItem bestItem;

        private SelectionResolutionStatus() {
        }
    }

    static class TransientStateImpl
    implements GraphExplorer.TransientExplorerState {
        private Integer activeColumn = null;

        TransientStateImpl() {
        }

        public synchronized Integer getActiveColumn() {
            return this.activeColumn;
        }

        public synchronized void setActiveColumn(Integer column) {
            this.activeColumn = column;
        }
    }
}

