/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui;

import java.util.EnumSet;

/**
 * Describes the checked state of a NodeContext in the browsing framework.
 * Commonly in a viewer (for example SWT/JFace) viewed items can have have a
 * check-box attached to them telling, e.g. are they selected or not.
 * 
 * @author Tuukka Lehtonen
 * 
 * @see BuiltinKeys#IS_CHECKED
 */
public enum CheckedState {

    /**
     * Node is checked.
     */
    CHECKED,

    /**
     * Node is "grayed", e.g. indirectly selected.
     */
    GRAYED,

    /**
     * Node is not checked.
     */
    NOT_CHECKED
    ;

    public static final EnumSet<CheckedState> CHECKED_STATES = EnumSet.of(CHECKED, GRAYED);

    public static CheckedState of(boolean b) {
        return b ? CHECKED : NOT_CHECKED;
    }

}
