/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.platform;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

import org.simantics.browsing.ui.graph.contributor.viewpoint.ViewpointContributor;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.Valuations;

final public class VariablesContributor extends ViewpointContributor<VariablesInput> {
    
    @Override
    public String getViewpointId() {
        return "Variables";
    }

	@Override
	public Collection<?> getContribution(ReadGraph graph, VariablesInput input) throws DatabaseException {
		
    	System.out.println("VariablesContributor " + input);
    	
    	Valuations vs = graph.adapt(input.getResource(), Valuations.class);
    	if(vs == null) return Collections.emptyList();
    	Resource valueSpace = vs.getValue(graph, null, "BaseRealization");

    	ArrayList<Resource> values = new ArrayList<Resource>();
    	for(Resource value : graph.getObjects(valueSpace, L0.ConsistsOf)) {
    		values.add(value);
    	}
    	
    	return values;
        
	}

}
