/*******************************************************************************
 * Copyright (c) 2010, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.model.imagedecorators;

import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.content.ImageDecorator;
import org.simantics.browsing.ui.model.InvalidContribution;
import org.simantics.browsing.ui.model.nodetypes.NodeType;
import org.simantics.browsing.ui.model.tests.Test;
import org.simantics.browsing.ui.model.visuals.VisualsContribution;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;

/**
 * Produces image decorators for nodes of given node type.
 * @author Hannu Niemistö
 */
public class ImageDecorationContribution extends VisualsContribution {
    ImageDecorationRule imageDecorationRule;
    
    public ImageDecorationContribution(NodeType nodeType, Test test, ImageDecorationRule imageDecorationRule, double priority) throws InvalidContribution {
        super(nodeType, test, priority);
        if(!imageDecorationRule.isCompatible(
                nodeType.getContentType()
                ))
            throw new InvalidContribution("Image decoration rule is not compatible with the content type.");
        this.imageDecorationRule = imageDecorationRule;
    }
       
    /**
     * Returns an image decorator for the node or null, if contribution is
     * not suitable for the input.
     */
    public ImageDecorator getImageDecorator(ReadGraph graph, NodeContext context) {
        Object content = context.getConstant(BuiltinKeys.INPUT);
        try {
            if(test == null || test.test(graph, content))
                return imageDecorationRule.getImageDecorator(graph, content);
            else
                return null;
        } catch(DatabaseException e) {
            // TODO reconsider
            return null;
        }
    }    
}
