/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.graph.impl.contributor.labeler;

import java.util.Map;

import org.simantics.browsing.ui.BuiltinKeys.LabelerKey;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.PrimitiveQueryUpdater;
import org.simantics.browsing.ui.Tester;
import org.simantics.browsing.ui.content.Contributor;
import org.simantics.browsing.ui.content.Labeler;
import org.simantics.browsing.ui.content.Labeler.Modifier;
import org.simantics.browsing.ui.content.LabelerFactory;
import org.simantics.browsing.ui.graph.impl.contribution.LabelerContributionImpl;
import org.simantics.db.ReadGraph;
import org.simantics.db.UndoContext;
import org.simantics.db.exception.DatabaseException;

abstract public class ContextColumnLabelerContributorImpl implements Contributor<LabelerFactory> {

    abstract public Map<String, String> getLabel(ReadGraph graph, NodeContext input) throws DatabaseException;

    public int getCategory(ReadGraph graph, NodeContext input) throws DatabaseException {
        return 0;
    }

    public Modifier getModifier(ReadGraph graph, NodeContext input, String columnKey) throws DatabaseException {
        return null;
    }

    final private Class<?> clazz;

    @Override
    public Tester getNodeContextTester() {
        return null;
    }

    public ContextColumnLabelerContributorImpl() {
        clazz = Object.class;
    }

    public ContextColumnLabelerContributorImpl(Class<?> clazz) {
        this.clazz = clazz;
    }

    @Override
    public LabelerFactory getFactory() {

        return new LabelerFactory() {

            @Override
            public Labeler create(final PrimitiveQueryUpdater updater, NodeContext context, final LabelerKey key) {

                return new LabelerContributionImpl(updater, context, key) {

                    @Override
                    public Map<String, String> labels(ReadGraph graph, NodeContext context) throws DatabaseException {

                        return ContextColumnLabelerContributorImpl.this.getLabel(graph, context);

                    }


                    @Override
                    public Modifier getModifier(ReadGraph graph, UndoContext undoContext, NodeContext context, String columnKey) throws DatabaseException {

                        return ContextColumnLabelerContributorImpl.this.getModifier(graph, context, columnKey);

                    }

                    @Override
                    public int category(ReadGraph graph, NodeContext context) throws DatabaseException {

                        return ContextColumnLabelerContributorImpl.this.getCategory(graph, context);

                    }

                    @Override
                    public String toString() {
                        return ContextColumnLabelerContributorImpl.this.toString();
                    }

                };

            }

        };

    }

    @Override
    public Class<?> getInputClass() {
        return clazz;
    }

}
