/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.graph.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;

import org.simantics.browsing.ui.common.modifiers.EnumeratedValue;
import org.simantics.browsing.ui.common.modifiers.Enumeration;
import org.simantics.browsing.ui.common.modifiers.EnumerationValue;
import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.common.utils.CommonDBUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;

/**
 * @author Tuukka Lehtonen
 */
public class GetEnumerationValue extends ResourceRead<EnumerationValue<Resource>> {

    public GetEnumerationValue(Resource resource) {
        super(resource);
    }

    @Override
    public EnumerationValue<Resource> perform(ReadGraph graph) throws DatabaseException {
        return enumerate(graph, resource);
    }

    @Deprecated
    public static String getEnumerationValueName(ReadGraph graph, Resource resource) throws DatabaseException {
        return CommonDBUtils.getEnumerationValueName(graph, resource);
    }
    
    public static EnumerationValue<Resource> enumerate(ReadGraph graph, Resource resource) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance(graph);
        Set<Resource> types = graph.getTypes(resource);

        // FIXME: this is a hack to make boolean values editable through a combo-box like other enumerations
        if (types.contains(l0.Boolean)) {
            List<EnumeratedValue<Resource>> values = new ArrayList<EnumeratedValue<Resource>>(2);
            values.add(new EnumeratedValue<Resource>(Boolean.FALSE.toString(), l0.False));
            values.add(new EnumeratedValue<Resource>(Boolean.TRUE.toString(), l0.True));
            Boolean currentValue = graph.getPossibleValue(resource, Bindings.BOOLEAN);
            Enumeration<Resource> enumeration = new Enumeration<Resource>(values);
            EnumeratedValue<Resource> current = Boolean.TRUE.equals(currentValue) ? values.get(1) : values.get(0);
            return new EnumerationValue<Resource>(enumeration, current);
        } else {
            for (Resource type : types) {
                if (graph.hasStatement(type, l0.Enumeration, type)) {
                    Collection<Resource> values = graph.getObjects(type, l0.ConsistsOf);
                    List<EnumeratedValue<Resource>> result = new ArrayList<EnumeratedValue<Resource>>(values.size());
                    for (Resource value : values) {
                        result.add(new EnumeratedValue<Resource>(CommonDBUtils.getEnumerationValueName(graph, value), value));
                    }
                    Enumeration<Resource> enumeration = new Enumeration<Resource>(result);
                    return new EnumerationValue<Resource>(enumeration, enumeration.find(resource));
                }
            }
        }
        return null;
    }

}
