/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.common.processors;

import java.util.Arrays;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.GraphExplorer;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.NodeQueryManager;
import org.simantics.browsing.ui.common.processors.AbstractNodeQueryProcessor;
import org.simantics.browsing.ui.content.ComparableContext;
import org.simantics.browsing.ui.content.PrunedChildrenResult;

public class DefaultFinalChildrenProcessor
extends AbstractNodeQueryProcessor<NodeContext[]> {
    private final GraphExplorer explorer;

    public DefaultFinalChildrenProcessor(GraphExplorer explorer) {
        this.explorer = explorer;
    }

    public NodeContext.QueryKey<NodeContext[]> getIdentifier() {
        return BuiltinKeys.FINAL_CHILDREN;
    }

    public NodeContext[] query(NodeQueryManager manager, NodeContext context) {
        Object[] comparables;
        int maxChildren = Integer.MAX_VALUE;
        if (this.explorer != null) {
            maxChildren = this.explorer.getMaxChildren(manager, context);
        }
        if ((comparables = (ComparableContext[])manager.query(context, BuiltinKeys.COMPARABLE_CHILDREN)) == null) {
            PrunedChildrenResult pruned = (PrunedChildrenResult)manager.query(context, BuiltinKeys.PRUNED_CHILDREN);
            int length = Math.min(pruned.getPrunedChildren().length, maxChildren);
            if (length < pruned.getPrunedChildren().length) {
                NodeContext[] truncated = new NodeContext[length];
                System.arraycopy(pruned.getPrunedChildren(), 0, truncated, 0, length);
                return truncated;
            }
            return pruned.getPrunedChildren();
        }
        if (comparables.length == 0) {
            return NodeContext.NONE;
        }
        if (comparables.length == 1) {
            return new NodeContext[]{comparables[0].getContext()};
        }
        Arrays.sort(comparables);
        int length = Math.min(comparables.length, maxChildren);
        NodeContext[] result = new NodeContext[length];
        int i = 0;
        while (i < length) {
            result[i] = comparables[i].getContext();
            ++i;
        }
        return result;
    }

    @Override
    public String toString() {
        return "FinalChildrenProcessor";
    }
}

