/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.common.processors;

import java.util.Collection;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.NodeQueryManager;
import org.simantics.browsing.ui.common.processors.AbstractNodeQueryProcessor;
import org.simantics.browsing.ui.content.ComparableContext;
import org.simantics.browsing.ui.content.ComparableContextFactory;
import org.simantics.browsing.ui.content.PrunedChildrenResult;

public class ComparableSelectorQueryProcessor
extends AbstractNodeQueryProcessor<ComparableContext[]> {
    public NodeContext.QueryKey<ComparableContext[]> getIdentifier() {
        return BuiltinKeys.COMPARABLE_CHILDREN;
    }

    private ComparableContext[] build(NodeQueryManager manager, NodeContext context, ComparableContextFactory factory) {
        PrunedChildrenResult pruned = (PrunedChildrenResult)manager.query(context, BuiltinKeys.PRUNED_CHILDREN);
        NodeContext[] prunedChildren = pruned.getPrunedChildren();
        return factory.create(manager, context, prunedChildren);
    }

    public ComparableContext[] query(NodeQueryManager manager, NodeContext context) {
        Collection comparators = (Collection)manager.query(context, BuiltinKeys.COMPARABLE_FACTORIES);
        if (comparators.isEmpty()) {
            return null;
        }
        ComparableContextFactory selectedFactory = (ComparableContextFactory)manager.query(context, (NodeContext.PrimitiveQueryKey)new BuiltinKeys.SelectedComparableFactoryKey(comparators));
        if (selectedFactory == null) {
            return null;
        }
        return this.build(manager, context, selectedFactory);
    }

    @Override
    public String toString() {
        return "SelectedComparableProcessor";
    }
}

