/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.common;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.simantics.browsing.ui.common.EvaluatorData;
import org.simantics.browsing.ui.common.EvaluatorImpl;

public class EvaluatorDataImpl
implements EvaluatorData {
    private static final boolean DEBUG = false;
    protected HashMap<Class<?>, Collection<EvaluatorData.Evaluator>> originals = new HashMap();
    protected HashMap<Class<?>, Collection<EvaluatorData.Evaluator>> evaluators = new HashMap();
    private Object browseContext;

    public void setBrowseContext(Object browseContext) {
        this.browseContext = browseContext;
    }

    @Override
    public EvaluatorData.Evaluator newEvaluator() {
        return new EvaluatorImpl();
    }

    private synchronized void addEvaluator(HashMap<Class<?>, Collection<EvaluatorData.Evaluator>> map, Class<?> clazz, EvaluatorData.Evaluator eval) {
        Collection<EvaluatorData.Evaluator> es = map.get(clazz);
        if (es == null) {
            es = new ArrayList<EvaluatorData.Evaluator>();
            map.put(clazz, es);
        }
        es.add(eval);
    }

    private synchronized void addEvaluators(HashMap<Class<?>, Collection<EvaluatorData.Evaluator>> map, Class<?> clazz, Collection<EvaluatorData.Evaluator> evals) {
        Collection<EvaluatorData.Evaluator> es = map.get(clazz);
        if (es == null) {
            es = new ArrayList<EvaluatorData.Evaluator>();
            map.put(clazz, es);
        }
        es.addAll(evals);
    }

    @Override
    public synchronized void addEvaluator(Class<?> clazz, EvaluatorData.Evaluator eval) {
        this.addEvaluator(this.originals, clazz, eval);
    }

    public synchronized void addEvaluators(Class<?> clazz, Collection<EvaluatorData.Evaluator> evals) {
        this.addEvaluators(this.originals, clazz, evals);
    }

    @Override
    public Collection<EvaluatorData.Evaluator> get(Object object) {
        Class<?> clazz = object.getClass();
        Collection<EvaluatorData.Evaluator> evaluator = this.evaluators.get(clazz);
        if (evaluator != null) {
            return evaluator;
        }
        Collection<EvaluatorData.Evaluator> evals = this.findAndCacheEvaluatorsForClass(clazz);
        return evals;
    }

    private synchronized Collection<EvaluatorData.Evaluator> findAndCacheEvaluatorsForClass(Class<?> clazz) {
        HashSet<Class> usedClasses = new HashSet<Class>();
        HashSet<EvaluatorData.Evaluator> used = new HashSet<EvaluatorData.Evaluator>();
        ArrayList<EvaluatorData.Evaluator> result = new ArrayList();
        ArrayDeque fifo = new ArrayDeque();
        fifo.add(clazz);
        while (!fifo.isEmpty()) {
            Class c = (Class)fifo.removeFirst();
            if (!usedClasses.add(c)) continue;
            Class superClass = c.getSuperclass();
            if (superClass != null) {
                fifo.addLast(superClass);
            }
            Class<?>[] classArray = c.getInterfaces();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> i = classArray[n2];
                fifo.addLast(i);
                ++n2;
            }
            Collection<EvaluatorData.Evaluator> evals = this.originals.get(c);
            if (evals == null) continue;
            for (EvaluatorData.Evaluator eval : evals) {
                if (!used.add(eval)) continue;
                result.add(eval);
            }
        }
        if (result.isEmpty()) {
            result = Collections.emptyList();
        }
        this.evaluators.put(clazz, result);
        return result;
    }

    @Override
    public Collection<EvaluatorData.EvaluatorEntry> enumEvaluators() {
        ArrayList<EvaluatorData.EvaluatorEntry> result = new ArrayList<EvaluatorData.EvaluatorEntry>();
        for (Map.Entry<Class<?>, Collection<EvaluatorData.Evaluator>> entry : this.originals.entrySet()) {
            result.add(new EvaluatorEntryImpl(entry.getKey(), entry.getValue()));
        }
        return result;
    }

    @Override
    public <T> T getBrowseContext() {
        return (T)this.browseContext;
    }

    static class EvaluatorEntryImpl
    implements EvaluatorData.EvaluatorEntry {
        private final Class<?> clazz;
        private final Collection<EvaluatorData.Evaluator> evaluators;

        public EvaluatorEntryImpl(Class<?> clazz, Collection<EvaluatorData.Evaluator> evaluators) {
            this.clazz = clazz;
            this.evaluators = evaluators;
        }

        @Override
        public Class<?> getClazz() {
            return this.clazz;
        }

        @Override
        public Collection<EvaluatorData.Evaluator> getEvaluators() {
            return this.evaluators;
        }

        public String toString() {
            return "class " + this.clazz.getSimpleName();
        }
    }
}

