/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.audit.server;

import javax.servlet.Servlet;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;
import org.simantics.audit.server.AuditLoggingAPI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditLoggingServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuditLoggingServer.class);
    private static AuditLoggingServer INSTANCE = null;
    private static Server server;
    private static ServiceServerThread serverThread;

    private AuditLoggingServer(String token, int preferablePort) {
        ResourceConfig config = new ResourceConfig();
        config.register(JacksonFeature.class);
        config.register(AuditLoggingAPI.class);
        ServletHolder holder = new ServletHolder((Servlet)new ServletContainer(config));
        server = new Server();
        ServerConnector connector = new ServerConnector(server);
        connector.setPort(preferablePort);
        server.setConnectors(new Connector[]{connector});
        ServletContextHandler context = new ServletContextHandler((HandlerContainer)server, "/", 1);
        context.addServlet(holder, "/*");
    }

    private static synchronized AuditLoggingServer getInstance(String token, int port) {
        try {
            if (INSTANCE == null) {
                INSTANCE = new AuditLoggingServer(token, port);
            }
        }
        catch (Exception e) {
            LOGGER.error("Could not initialize SCL REST server", (Throwable)e);
        }
        return INSTANCE;
    }

    public static synchronized void start(String token, int port) throws Exception {
        AuditLoggingServer.getInstance(token, port);
        if (serverThread == null && server != null) {
            serverThread = new ServiceServerThread();
            serverThread.start();
        }
    }

    public static synchronized void stop() throws Exception {
        if (server != null) {
            server.stop();
        }
        serverThread = null;
    }

    private static class ServiceServerThread
    extends Thread {
        private ServiceServerThread() {
        }

        @Override
        public void run() {
            try {
                server.start();
                server.join();
            }
            catch (Exception e) {
                LOGGER.error("Could not start server ", (Throwable)e);
            }
        }
    }
}

