/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.application.db;

import java.io.IOException;
import org.simantics.application.arguments.Arguments;
import org.simantics.application.arguments.IArguments;
import org.simantics.application.arguments.SimanticsArguments;
import org.simantics.application.db.DatabaseUtils;
import org.simantics.application.db.IDatabaseHandle;
import org.simantics.db.ServerI;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.service.LifecycleSupport;
import org.simantics.utils.datastructures.disposable.AbstractDisposable;
import org.simantics.utils.datastructures.disposable.IDisposable;

public class DatabaseHandle
extends AbstractDisposable
implements IDatabaseHandle,
IDisposable {
    private ServerI server;
    private Session session;
    private final boolean deleteAtDispose;

    public static DatabaseHandle open(String[] arguments) throws Exception {
        IArguments args = Arguments.parse(arguments, SimanticsArguments.SERVER);
        if (!args.contains(SimanticsArguments.SERVER)) {
            throw new IllegalArgumentException("Missing " + SimanticsArguments.SERVER.getArgument() + " argument, a server is required.");
        }
        DatabaseHandle handle = new DatabaseHandle();
        handle.init(args.get(SimanticsArguments.SERVER), false);
        return handle;
    }

    public static DatabaseHandle open(String serverAddress) throws Exception {
        return new DatabaseHandle().init(serverAddress, false);
    }

    public static DatabaseHandle checkout(String serverAddress) throws Exception {
        return new DatabaseHandle().init(serverAddress, true);
    }

    private DatabaseHandle() {
        this.deleteAtDispose = false;
    }

    public DatabaseHandle(String[] arguments, boolean deleteAtDispose) throws Exception {
        this.deleteAtDispose = deleteAtDispose;
        IArguments args = Arguments.parse(arguments, SimanticsArguments.SERVER, SimanticsArguments.CHECKOUT);
        if (!args.contains(SimanticsArguments.SERVER)) {
            throw new IllegalArgumentException("Missing " + SimanticsArguments.SERVER.getArgument() + " argument, a server is required.");
        }
        boolean checkout = args.contains(SimanticsArguments.CHECKOUT);
        this.init(args.get(SimanticsArguments.SERVER), checkout);
    }

    private DatabaseHandle init(String serverAddress, boolean checkout) throws IOException, Exception {
        if (checkout) {
            throw new UnsupportedOperationException("re-implement checkout");
        }
        this.session = DatabaseUtils.connect(serverAddress);
        return this;
    }

    protected void doDispose() {
        if (this.session != null) {
            try {
                LifecycleSupport support = (LifecycleSupport)this.session.getService(LifecycleSupport.class);
                support.close(-1L, false);
                this.session = null;
            }
            catch (DatabaseException databaseException) {}
        }
    }

    @Override
    public ServerI getServer() {
        return this.server;
    }

    @Override
    public Session getSession() {
        return this.session;
    }
}

