/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.application.template;

import org.eclipse.equinox.app.IApplicationContext;
import org.simantics.application.db.HeadlessDatabaseApplication;
import org.simantics.db.ReadGraph;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;

/**
 * @author Tuukka Lehtonen
 */
public class TemplateDatabaseApplication extends HeadlessDatabaseApplication {

    @Override
    protected void beforeConnect(IApplicationContext context) {
        // Do something..
    }

    @Override
    protected void afterConnect() {
        Session s = getSession();

        String ret;
        try {
            ret = s.syncRequest(new Read<String>() {
                @Override
                public String perform(ReadGraph graph) throws DatabaseException {
                    // read something...
                    return "";
                }
            });
            System.out.println("read: " + ret);
        } catch (DatabaseException e) {
            e.printStackTrace();
        }
    }

}
