/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.application.arguments;

import java.util.Arrays;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeMap;

import org.simantics.application.arguments.IArgument;
import org.simantics.application.arguments.IArgumentFactory;

public class Arguments implements IArguments {

    private Map<String, IArgument<?>> args = new TreeMap<String, IArgument<?>>();

    /* (non-Javadoc)
     * @see org.simantics.application.arguments.IArguments#put(org.simantics.application.arguments.IArgument)
     */
    public void put(IArgument<?> arg) {
        args.put(arg.getArgument(), arg);
    }

    /* (non-Javadoc)
     * @see org.simantics.application.arguments.IArguments#putAll(org.simantics.application.arguments.IArguments)
     */
    @Override
    public void putAll(IArguments args) {
        for (IArgument<?> arg : args.toArray()) {
            put(arg);
        }
    }

    @SuppressWarnings("unchecked")
    public <T> IArgument<T> remove(IArgumentFactory<T> key) {
        return (IArgument<T>) args.remove(key.getArgument());
    }

    /* (non-Javadoc)
     * @see org.simantics.application.arguments.IArguments#contains(org.simantics.application.arguments.IArgumentFactory)
     */
    public <T> boolean contains(IArgumentFactory<T> key) {
        return args.containsKey(key.getArgument());
    }

    /* (non-Javadoc)
     * @see org.simantics.application.arguments.IArguments#get(org.simantics.application.arguments.IArgumentFactory)
     */
    @SuppressWarnings("unchecked")
    public <T> T get(IArgumentFactory<T> key) {
        IArgument<T> a = (IArgument<T>) args.get(key.getArgument());
        return a == null ? null : a.getValue();
    }

    @SuppressWarnings("unchecked")
    @Override
    public <T> T get(IArgumentFactory<T> key, T defaultValue) {
        IArgument<T> a = (IArgument<T>) args.get(key.getArgument());
        return a == null ? defaultValue : a.getValue();
    }

    /* (non-Javadoc)
     * @see org.simantics.application.arguments.IArguments#toArray()
     */
    public IArgument<?>[] toArray() {
        int size = args.size();
        return args.values().toArray(new IArgument<?>[size]);
    }

    /**
     * @param args
     * @param parsedArguments
     * @return
     */
    public static IArguments parse(String[] args, IArgumentFactory<?>... parsedArguments) {
        ListIterator<String> iter = Arrays.asList(args).listIterator();
        IArguments result = new Arguments();
        while (iter.hasNext()) {
            String arg = iter.next();

            IArgument<?> ret = null;
            for (IArgumentFactory<?> factory : parsedArguments) {
                try {
                    if ((ret = factory.parse(arg, iter)) != null)
                        break;
                } catch (IllegalArgumentException e) {
                    // Argument matched, but the argument value was invalid.
                    // TODO: react to this.
                }
            }
            if (ret != null)
                result.put(ret);
        }
        
        return result;
    }

}
