/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.annotation.ui.modelBrowser2.model;

import java.util.Map;

import org.simantics.browsing.ui.common.ColumnKeys;
import org.simantics.browsing.ui.model.labels.LabelRule;
import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.utils.datastructures.ArrayMap;

/**
 * @author Antti Villberg
 */
public enum AnnotationTypeLabelRule implements LabelRule {

    INSTANCE;

    public static AnnotationTypeLabelRule get() {
        return INSTANCE;
    }

    @Override
    public boolean isCompatible(Class<?> contentType) {
        return contentType.equals(Resource.class);
    }

    @Override
    public Map<String, String> getLabel(ReadGraph graph, Object content) throws DatabaseException {
        Resource type = (Resource) content;

        Layer0 L0 = Layer0.getInstance(graph);
        Resource property = graph.getPossibleObject(type, L0.HasRange_Inverse);
        String name = "";
        if (property != null) {
            String pname = graph.getPossibleRelatedValue(property, L0.HasName, Bindings.STRING);
            if (pname != null)
                name = pname;
        }

        return ArrayMap.make(ColumnKeys.KEYS_SINGLE, new String[] { name });
    }

}
