/*
 * Decompiled with CFR 0.152.
 */
package vtk;

import java.io.File;
import vtk.vtkFileOutputWindow;

public enum vtkNativeLibrary {
    VTKACCELERATORSVTKM("vtkAcceleratorsVTKmJava", false),
    VTKCHARTSCORE("vtkChartsCoreJava", true),
    VTKCOMMONCOLOR("vtkCommonColorJava", true),
    VTKCOMMONCOMPUTATIONALGEOMETRY("vtkCommonComputationalGeometryJava", true),
    VTKCOMMONCORE("vtkCommonCoreJava", true),
    VTKCOMMONDATAMODEL("vtkCommonDataModelJava", true),
    VTKCOMMONEXECUTIONMODEL("vtkCommonExecutionModelJava", true),
    VTKCOMMONMATH("vtkCommonMathJava", true),
    VTKCOMMONMISC("vtkCommonMiscJava", true),
    VTKCOMMONSYSTEM("vtkCommonSystemJava", true),
    VTKCOMMONTRANSFORMS("vtkCommonTransformsJava", true),
    VTKDOMAINSCHEMISTRY("vtkDomainsChemistryJava", true),
    VTKDOMAINSCHEMISTRYOPENGL2("vtkDomainsChemistryOpenGL2Java", true),
    VTKDOMAINSMICROSCOPY("vtkDomainsMicroscopyJava", false),
    VTKDOMAINSPARALLELCHEMISTRY("vtkDomainsParallelChemistryJava", false),
    VTKFILTERSAMR("vtkFiltersAMRJava", true),
    VTKFILTERSCORE("vtkFiltersCoreJava", true),
    VTKFILTERSEXTRACTION("vtkFiltersExtractionJava", true),
    VTKFILTERSFLOWPATHS("vtkFiltersFlowPathsJava", true),
    VTKFILTERSGENERAL("vtkFiltersGeneralJava", true),
    VTKFILTERSGENERIC("vtkFiltersGenericJava", true),
    VTKFILTERSGEOMETRY("vtkFiltersGeometryJava", true),
    VTKFILTERSHYBRID("vtkFiltersHybridJava", true),
    VTKFILTERSHYPERTREE("vtkFiltersHyperTreeJava", true),
    VTKFILTERSIMAGING("vtkFiltersImagingJava", true),
    VTKFILTERSMODELING("vtkFiltersModelingJava", true),
    VTKFILTERSOPENTURNS("vtkFiltersOpenTurnsJava", false),
    VTKFILTERSPARALLEL("vtkFiltersParallelJava", true),
    VTKFILTERSPARALLELFLOWPATHS("vtkFiltersParallelFlowPathsJava", false),
    VTKFILTERSPARALLELGEOMETRY("vtkFiltersParallelGeometryJava", false),
    VTKFILTERSPARALLELIMAGING("vtkFiltersParallelImagingJava", true),
    VTKFILTERSPARALLELMPI("vtkFiltersParallelMPIJava", false),
    VTKFILTERSPARALLELSTATISTICS("vtkFiltersParallelStatisticsJava", false),
    VTKFILTERSPARALLELVERDICT("vtkFiltersParallelVerdictJava", false),
    VTKFILTERSPOINTS("vtkFiltersPointsJava", true),
    VTKFILTERSPROGRAMMABLE("vtkFiltersProgrammableJava", true),
    VTKFILTERSREEBGRAPH("vtkFiltersReebGraphJava", false),
    VTKFILTERSSMP("vtkFiltersSMPJava", true),
    VTKFILTERSSELECTION("vtkFiltersSelectionJava", true),
    VTKFILTERSSOURCES("vtkFiltersSourcesJava", true),
    VTKFILTERSSTATISTICS("vtkFiltersStatisticsJava", true),
    VTKFILTERSTEXTURE("vtkFiltersTextureJava", true),
    VTKFILTERSTOPOLOGY("vtkFiltersTopologyJava", true),
    VTKFILTERSVERDICT("vtkFiltersVerdictJava", true),
    VTKGEOVISCORE("vtkGeovisCoreJava", true),
    VTKGEOVISGDAL("vtkGeovisGDALJava", false),
    VTKIOADIOS("vtkIOADIOSJava", false),
    VTKIOAMR("vtkIOAMRJava", true),
    VTKIOASYNCHRONOUS("vtkIOAsynchronousJava", true),
    VTKIOCITYGML("vtkIOCityGMLJava", true),
    VTKIOCORE("vtkIOCoreJava", true),
    VTKIOENSIGHT("vtkIOEnSightJava", true),
    VTKIOEXODUS("vtkIOExodusJava", true),
    VTKIOEXPORT("vtkIOExportJava", true),
    VTKIOEXPORTOPENGL2("vtkIOExportOpenGL2Java", true),
    VTKIOEXPORTPDF("vtkIOExportPDFJava", true),
    VTKIOFFMPEG("vtkIOFFMPEGJava", false),
    VTKIOGDAL("vtkIOGDALJava", false),
    VTKIOGEOJSON("vtkIOGeoJSONJava", false),
    VTKIOGEOMETRY("vtkIOGeometryJava", true),
    VTKIOIMAGE("vtkIOImageJava", true),
    VTKIOIMPORT("vtkIOImportJava", true),
    VTKIOINFOVIS("vtkIOInfovisJava", true),
    VTKIOLAS("vtkIOLASJava", false),
    VTKIOLSDYNA("vtkIOLSDynaJava", true),
    VTKIOLEGACY("vtkIOLegacyJava", true),
    VTKIOMINC("vtkIOMINCJava", true),
    VTKIOMPIIMAGE("vtkIOMPIImageJava", false),
    VTKIOMPIPARALLEL("vtkIOMPIParallelJava", false),
    VTKIOMOTIONFX("vtkIOMotionFXJava", false),
    VTKIOMOVIE("vtkIOMovieJava", true),
    VTKIOMYSQL("vtkIOMySQLJava", false),
    VTKIONETCDF("vtkIONetCDFJava", true),
    VTKIOODBC("vtkIOODBCJava", false),
    VTKIOPDAL("vtkIOPDALJava", false),
    VTKIOPLY("vtkIOPLYJava", true),
    VTKIOPARALLEL("vtkIOParallelJava", true),
    VTKIOPARALLELEXODUS("vtkIOParallelExodusJava", false),
    VTKIOPARALLELLSDYNA("vtkIOParallelLSDynaJava", false),
    VTKIOPARALLELNETCDF("vtkIOParallelNetCDFJava", false),
    VTKIOPARALLELXML("vtkIOParallelXMLJava", true),
    VTKIOPARALLELXDMF3("vtkIOParallelXdmf3Java", false),
    VTKIOPOSTGRESQL("vtkIOPostgreSQLJava", false),
    VTKIOSQL("vtkIOSQLJava", true),
    VTKIOSEGY("vtkIOSegYJava", true),
    VTKIOTRUCHAS("vtkIOTRUCHASJava", false),
    VTKIOTECPLOTTABLE("vtkIOTecplotTableJava", true),
    VTKIOVPIC("vtkIOVPICJava", false),
    VTKIOVERAOUT("vtkIOVeraOutJava", true),
    VTKIOVIDEO("vtkIOVideoJava", true),
    VTKIOXML("vtkIOXMLJava", true),
    VTKIOXMLPARSER("vtkIOXMLParserJava", true),
    VTKIOXDMF2("vtkIOXdmf2Java", false),
    VTKIOXDMF3("vtkIOXdmf3Java", false),
    VTKIMAGINGCOLOR("vtkImagingColorJava", true),
    VTKIMAGINGCORE("vtkImagingCoreJava", true),
    VTKIMAGINGFOURIER("vtkImagingFourierJava", true),
    VTKIMAGINGGENERAL("vtkImagingGeneralJava", true),
    VTKIMAGINGHYBRID("vtkImagingHybridJava", true),
    VTKIMAGINGMATH("vtkImagingMathJava", true),
    VTKIMAGINGMORPHOLOGICAL("vtkImagingMorphologicalJava", true),
    VTKIMAGINGOPENGL2("vtkImagingOpenGL2Java", false),
    VTKIMAGINGSOURCES("vtkImagingSourcesJava", true),
    VTKIMAGINGSTATISTICS("vtkImagingStatisticsJava", true),
    VTKIMAGINGSTENCIL("vtkImagingStencilJava", true),
    VTKINFOVISBOOSTGRAPHALGORITHMS("vtkInfovisBoostGraphAlgorithmsJava", false),
    VTKINFOVISCORE("vtkInfovisCoreJava", true),
    VTKINFOVISLAYOUT("vtkInfovisLayoutJava", true),
    VTKINTERACTIONIMAGE("vtkInteractionImageJava", true),
    VTKINTERACTIONSTYLE("vtkInteractionStyleJava", true),
    VTKINTERACTIONWIDGETS("vtkInteractionWidgetsJava", true),
    VTKPARALLELCORE("vtkParallelCoreJava", true),
    VTKPARALLELMPI("vtkParallelMPIJava", false),
    VTKRENDERINGANNOTATION("vtkRenderingAnnotationJava", true),
    VTKRENDERINGCONTEXT2D("vtkRenderingContext2DJava", true),
    VTKRENDERINGCONTEXTOPENGL2("vtkRenderingContextOpenGL2Java", true),
    VTKRENDERINGCORE("vtkRenderingCoreJava", true),
    VTKRENDERINGEXTERNAL("vtkRenderingExternalJava", false),
    VTKRENDERINGFREETYPE("vtkRenderingFreeTypeJava", true),
    VTKRENDERINGGL2PSOPENGL2("vtkRenderingGL2PSOpenGL2Java", true),
    VTKRENDERINGIMAGE("vtkRenderingImageJava", true),
    VTKRENDERINGLICOPENGL2("vtkRenderingLICOpenGL2Java", false),
    VTKRENDERINGLOD("vtkRenderingLODJava", true),
    VTKRENDERINGLABEL("vtkRenderingLabelJava", true),
    VTKRENDERINGMATPLOTLIB("vtkRenderingMatplotlibJava", false),
    VTKRENDERINGOSPRAY("vtkRenderingOSPRayJava", false),
    VTKRENDERINGOPENGL2("vtkRenderingOpenGL2Java", true),
    VTKRENDERINGOPENVR("vtkRenderingOpenVRJava", false),
    VTKRENDERINGOPTIX("vtkRenderingOptiXJava", false),
    VTKRENDERINGPARALLEL("vtkRenderingParallelJava", false),
    VTKRENDERINGPARALLELLIC("vtkRenderingParallelLICJava", false),
    VTKRENDERINGQT("vtkRenderingQtJava", false),
    VTKRENDERINGSCENEGRAPH("vtkRenderingSceneGraphJava", false),
    VTKRENDERINGVOLUME("vtkRenderingVolumeJava", true),
    VTKRENDERINGVOLUMEAMR("vtkRenderingVolumeAMRJava", false),
    VTKRENDERINGVOLUMEOPENGL2("vtkRenderingVolumeOpenGL2Java", true),
    VTKTESTINGRENDERING("vtkTestingRenderingJava", false),
    VTKVIEWSCONTEXT2D("vtkViewsContext2DJava", true),
    VTKVIEWSCORE("vtkViewsCoreJava", true),
    VTKVIEWSGEOVIS("vtkViewsGeovisJava", false),
    VTKVIEWSINFOVIS("vtkViewsInfovisJava", true),
    VTKWEBCORE("vtkWebCoreJava", false),
    VTKWEBGLEXPORTER("vtkWebGLExporterJava", false);

    private String nativeLibraryName;
    private boolean loaded;
    private boolean built;

    public static boolean LoadAllNativeLibraries() {
        boolean isEveryThingLoaded = true;
        vtkNativeLibrary[] vtkNativeLibraryArray = vtkNativeLibrary.values();
        int n = vtkNativeLibraryArray.length;
        int n2 = 0;
        while (n2 < n) {
            vtkNativeLibrary lib = vtkNativeLibraryArray[n2];
            try {
                if (lib.IsBuilt()) {
                    lib.LoadLibrary();
                }
            }
            catch (UnsatisfiedLinkError e) {
                isEveryThingLoaded = false;
                e.printStackTrace();
            }
            ++n2;
        }
        return isEveryThingLoaded;
    }

    public static void LoadNativeLibraries(vtkNativeLibrary ... nativeLibraries) {
        vtkNativeLibrary[] vtkNativeLibraryArray = nativeLibraries;
        int n = nativeLibraries.length;
        int n2 = 0;
        while (n2 < n) {
            vtkNativeLibrary lib = vtkNativeLibraryArray[n2];
            lib.LoadLibrary();
            ++n2;
        }
    }

    public static void DisableOutputWindow(File logFile) {
        if (logFile == null) {
            logFile = new File("vtkError.txt");
        }
        vtkFileOutputWindow outputError = new vtkFileOutputWindow();
        outputError.SetFileName(logFile.getAbsolutePath());
        outputError.SetInstance(outputError);
    }

    private vtkNativeLibrary(String nativeLibraryName, boolean built) {
        this.nativeLibraryName = nativeLibraryName;
        this.loaded = false;
        this.built = built;
    }

    public void LoadLibrary() throws UnsatisfiedLinkError {
        if (!this.loaded) {
            if (System.getProperty("vtk.lib.dir") != null) {
                File dir = new File(System.getProperty("vtk.lib.dir"));
                vtkNativeLibrary.patchJavaLibraryPath(dir.getAbsolutePath());
                File libPath = new File(dir, System.mapLibraryName(this.nativeLibraryName));
                if (libPath.exists()) {
                    try {
                        Runtime.getRuntime().load(libPath.getAbsolutePath());
                        this.loaded = true;
                        return;
                    }
                    catch (UnsatisfiedLinkError e) {
                        e.printStackTrace();
                    }
                }
            }
            System.loadLibrary(this.nativeLibraryName);
        }
        this.loaded = true;
    }

    public boolean IsLoaded() {
        return this.loaded;
    }

    public boolean IsBuilt() {
        return this.built;
    }

    public String GetLibraryName() {
        return this.nativeLibraryName;
    }

    private static void patchJavaLibraryPath(String vtkLibDir) {
        if (vtkLibDir != null) {
            String path_separator = System.getProperty("path.separator");
            String s = System.getProperty("java.library.path");
            if (!s.contains(vtkLibDir)) {
                s = String.valueOf(s) + path_separator + vtkLibDir;
                System.setProperty("java.library.path", s);
            }
        }
    }
}

