/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.plant3d.scenegraph;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.vecmath.Quat4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple4d;
import javax.vecmath.Vector3d;
import org.simantics.g3d.math.MathTools;
import org.simantics.g3d.property.annotations.CompoundGetPropertyValue;
import org.simantics.g3d.property.annotations.CompoundSetPropertyValue;
import org.simantics.g3d.property.annotations.GetPropertyValue;
import org.simantics.g3d.property.annotations.PropertyContributor;
import org.simantics.g3d.scenegraph.base.ParentNode;
import org.simantics.objmap.graph.annotations.CompoundRelatedGetValue;
import org.simantics.objmap.graph.annotations.CompoundRelatedSetValue;
import org.simantics.objmap.graph.annotations.RelatedGetObj;
import org.simantics.objmap.graph.annotations.RelatedSetObj;
import org.simantics.plant3d.scenegraph.GeometryNode;
import org.simantics.plant3d.scenegraph.PipeRun;
import org.simantics.plant3d.scenegraph.TurnComponent;
import org.simantics.plant3d.scenegraph.controlpoint.PipeControlPoint;

@PropertyContributor
public abstract class PipelineComponent
extends GeometryNode {
    static boolean DEBUG = false;
    private PipeRun pipeRun;
    private PipeRun alternativePipeRun;
    private PipelineComponent next;
    private PipelineComponent previous;
    private PipelineComponent branch0;
    boolean syncnext = false;
    boolean syncprev = false;
    boolean syncbr0 = false;
    private String error;

    public PipeRun getPipeRun() {
        return this.pipeRun;
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        if (DEBUG) {
            System.out.println("Create " + this.toDebugString());
        }
    }

    public void setParent(ParentNode<?> parent, String name) {
        super.setParent(parent, name);
        if (DEBUG) {
            System.out.println("Set parent " + this.toDebugString() + " " + parent);
        }
    }

    public void setPipeRun(PipeRun pipeRun) {
        if (pipeRun == this.pipeRun) {
            return;
        }
        this.pipeRun = pipeRun;
        if (DEBUG) {
            System.out.println("Set " + this.toDebugString() + " run " + pipeRun);
        }
        if (this.getControlPoint() != null) {
            this.getControlPoint().deattach();
            if (pipeRun != null) {
                pipeRun.addChild(this.getControlPoint());
            }
        }
        if (pipeRun != null) {
            this.updateParameters();
        }
    }

    @RelatedGetObj(value="http://www.simantics.org/Plant3D-0.1/HasAlternativePipeRun")
    public PipeRun getAlternativePipeRun() {
        return this.alternativePipeRun;
    }

    @RelatedSetObj(value="http://www.simantics.org/Plant3D-0.1/HasAlternativePipeRun")
    public void setAlternativePipeRun(PipeRun pipeRun) {
        PipeControlPoint sub;
        if (this.alternativePipeRun == pipeRun) {
            return;
        }
        this.alternativePipeRun = pipeRun;
        if (this.getControlPoint().isDualInline() && (sub = this.getControlPoint().getDualSub()).getParent() != this.alternativePipeRun) {
            if (this.alternativePipeRun != null) {
                this.alternativePipeRun.addChild(sub);
            } else if (sub.getPipeRun() != null) {
                sub.getPipeRun().remChild(sub);
            }
        }
        this.firePropertyChanged("http://www.simantics.org/Plant3D-0.1/HasAlternativePipeRun");
    }

    @Override
    public void updateParameters() {
        this.setParameterMap(this.updateParameterMap());
        super.updateParameters();
    }

    @Override
    @CompoundRelatedGetValue(objRelation="http://www.simantics.org/Plant3D-0.1/hasParameter", objType="http://www.simantics.org/Plant3D-0.1/Parameter", valRelation="http://www.simantics.org/Plant3D-0.1/hasParameterValue")
    public Map<String, Object> getParameterMap() {
        return super.getParameterMap();
    }

    @Override
    @CompoundRelatedSetValue(value="http://www.simantics.org/Plant3D-0.1/hasParameter")
    public void setParameterMap(Map<String, Object> parameters) {
        Double length;
        super.setParameterMap(parameters);
        if (this.getControlPoint() != null && (length = (Double)parameters.get("length")) != null) {
            this.getControlPoint().setLength(length);
        }
    }

    @CompoundGetPropertyValue(name="Parameters", tabId="Parameters", value="parameters")
    public Map<String, Object> getParameterMapUI() {
        HashMap<String, Object> map = new HashMap<String, Object>(this.getParameterMap());
        map.remove("radius");
        map.remove("radius2");
        map.remove("offset");
        return map;
    }

    @CompoundSetPropertyValue(value="parameters")
    public void setParameterMapUI(Map<String, Object> parameters) {
        Map<String, Object> curr = this.getParameterMap();
        for (Map.Entry<String, Object> entry : curr.entrySet()) {
            if (parameters.containsKey(entry.getKey())) continue;
            parameters.put(entry.getKey(), entry.getValue());
        }
        this.setParameterMap(parameters);
    }

    public void setParameter(String name, Object value) {
        HashMap<String, Object> parameters = new HashMap<String, Object>(this.getParameterMap());
        parameters.put(name, value);
        this.setParameterMap(parameters);
    }

    public abstract void setType(String var1) throws Exception;

    @RelatedGetObj(value="http://www.simantics.org/Plant3D-0.1/HasNext")
    public PipelineComponent getNext() {
        return this.next;
    }

    @RelatedSetObj(value="http://www.simantics.org/Plant3D-0.1/HasNext")
    public void setNext(PipelineComponent comp) {
        if (this.next == comp) {
            this.syncNext();
            return;
        }
        if (this.next != null) {
            this.next._removeRef(this);
        }
        this._setNext(comp);
        this.syncnext = false;
        if (DEBUG) {
            System.out.println(String.valueOf(this.toDebugString()) + " next " + (comp != null ? comp.toDebugString() : null));
        }
        this.syncNext();
        this.firePropertyChanged("http://www.simantics.org/Plant3D-0.1/HasNext");
        if (comp != null) {
            comp.sync();
        }
    }

    protected void _setNext(PipelineComponent comp) {
        if (DEBUG) {
            System.out.println(String.valueOf(this.toDebugString()) + " _next " + (comp != null ? comp.toDebugString() : null));
        }
        this.next = comp;
    }

    @RelatedGetObj(value="http://www.simantics.org/Plant3D-0.1/HasPrevious")
    public PipelineComponent getPrevious() {
        return this.previous;
    }

    @RelatedSetObj(value="http://www.simantics.org/Plant3D-0.1/HasPrevious")
    public void setPrevious(PipelineComponent comp) {
        if (this.previous == comp) {
            this.syncPrevious();
            return;
        }
        if (this.previous != null) {
            this.previous._removeRef(this);
        }
        this._setPrevious(comp);
        this.syncprev = false;
        if (DEBUG) {
            System.out.println(String.valueOf(this.toDebugString()) + " prev " + (comp != null ? comp.toDebugString() : null));
        }
        this.syncPrevious();
        this.firePropertyChanged("http://www.simantics.org/Plant3D-0.1/HasPrevious");
        if (comp != null) {
            comp.sync();
        }
    }

    protected void _setPrevious(PipelineComponent comp) {
        if (DEBUG) {
            System.out.println(String.valueOf(this.toDebugString()) + " _prev " + (comp != null ? comp.toDebugString() : null));
        }
        this.previous = comp;
    }

    @RelatedGetObj(value="http://www.simantics.org/Plant3D-0.1/HasBranch0")
    public PipelineComponent getBranch0() {
        return this.branch0;
    }

    @RelatedSetObj(value="http://www.simantics.org/Plant3D-0.1/HasBranch0")
    public void setBranch0(PipelineComponent comp) {
        if (this.branch0 == comp) {
            this.syncBranch0();
            return;
        }
        if (this.branch0 != null) {
            this.branch0._removeRef(this);
        }
        this.branch0 = comp;
        this.syncbr0 = false;
        if (DEBUG) {
            System.out.println(String.valueOf(this.toDebugString()) + " br0 " + (comp != null ? comp.toDebugString() : null));
        }
        this.syncBranch0();
        this.firePropertyChanged("http://www.simantics.org/Plant3D-0.1/HasBranch0");
        if (comp != null) {
            comp.sync();
        }
    }

    @GetPropertyValue(name="Previous", tabId="Debug", value="http://www.simantics.org/Plant3D-0.1/HasPrevious")
    public String getPreviousDebug() {
        if (this.previous == null) {
            return null;
        }
        return this.previous.getName();
    }

    @GetPropertyValue(name="Next", tabId="Debug", value="http://www.simantics.org/Plant3D-0.1/HasNext")
    public String getNextDebug() {
        if (this.next == null) {
            return null;
        }
        return this.next.getName();
    }

    @GetPropertyValue(name="Branch0", tabId="Debug", value="http://www.simantics.org/Plant3D-0.1/HasBranch0")
    public String getBR0Debug() {
        if (this.branch0 == null) {
            return null;
        }
        return this.branch0.getName();
    }

    @GetPropertyValue(name="PipeRun", tabId="Debug", value="http://www.simantics.org/Plant3D-0.1/HasPipeRun")
    public String getPRDebug() {
        if (this.pipeRun == null) {
            return null;
        }
        return this.pipeRun.getName();
    }

    @GetPropertyValue(name="PipeRunAlt", tabId="Debug", value="http://www.simantics.org/Plant3D-0.1/HasAlternativePipeRun")
    public String getPRAltDebug() {
        if (this.alternativePipeRun == null) {
            return null;
        }
        return this.alternativePipeRun.getName();
    }

    private PipeControlPoint getBranchPoint() {
        PipeControlPoint branchPoint;
        if (this.getControlPoint().getChildPoints().size() > 0) {
            branchPoint = this.getControlPoint().getChildPoints().get(0);
        } else {
            if (this.branch0.getPipeRun() == null) {
                return null;
            }
            branchPoint = new PipeControlPoint(this, this.branch0.getPipeRun());
            branchPoint.setFixed(false);
            branchPoint.setType(PipeControlPoint.PointType.END);
            branchPoint.parent = this.getControlPoint();
            this.getControlPoint().children.add(branchPoint);
            branchPoint.setWorldOrientation(this.getControlPoint().getWorldOrientation());
            branchPoint.setWorldPosition(this.getControlPoint().getWorldPosition());
        }
        return branchPoint;
    }

    private boolean _connectNext(PipeControlPoint pcp, PipeControlPoint nextPCP) {
        if (nextPCP == null) {
            return false;
        }
        if (pcp.getNext() != nextPCP) {
            pcp.setNext(nextPCP);
        }
        return true;
    }

    private boolean _connectPrev(PipeControlPoint pcp, PipeControlPoint prevPCP) {
        if (prevPCP == null) {
            return false;
        }
        if (pcp.getPrevious() != prevPCP) {
            pcp.setPrevious(prevPCP);
        }
        return true;
    }

    private void _removeRef(PipelineComponent comp) {
        if (this.next == comp) {
            this._setNext(null);
            this.syncnext = false;
            if (DEBUG) {
                System.out.println(String.valueOf(this.toDebugString()) + " remove next " + (comp != null ? comp.toDebugString() : null));
            }
            this.firePropertyChanged("http://www.simantics.org/Plant3D-0.1/HasNext");
            this.syncNext();
        } else if (this.previous == comp) {
            this._setPrevious(null);
            this.syncprev = false;
            if (DEBUG) {
                System.out.println(String.valueOf(this.toDebugString()) + " remove prev " + (comp != null ? comp.toDebugString() : null));
            }
            this.firePropertyChanged("http://www.simantics.org/Plant3D-0.1/HasPrevious");
            this.syncPrevious();
        } else if (this.branch0 == comp) {
            this.branch0 = null;
            this.syncbr0 = false;
            if (DEBUG) {
                System.out.println(String.valueOf(this.toDebugString()) + " remove br0 " + (comp != null ? comp.toDebugString() : null));
            }
            this.firePropertyChanged("http://www.simantics.org/Plant3D-0.1/HasBranch0");
            this.syncBranch0();
        }
    }

    protected void syncNext() {
        if (this.syncnext) {
            return;
        }
        this.syncnext = this._syncNext();
    }

    private boolean _syncNext() {
        PipeControlPoint pcp = this.getControlPoint();
        if (pcp != null) {
            if (this.next != null) {
                if (this.next.getControlPoint() != null) {
                    boolean br0;
                    boolean nxt = this.next.getPrevious() == this;
                    boolean bl = br0 = this.next.getBranch0() == this;
                    if (nxt) {
                        return this._connectNext(pcp, this.next.getControlPoint());
                    }
                    if (br0) {
                        return this._connectNext(pcp, this.next.getBranchPoint());
                    }
                    return false;
                }
                return false;
            }
            if (pcp.getNext() != null) {
                pcp.setNext(null);
                return true;
            }
        } else {
            return false;
        }
        return true;
    }

    protected void syncPrevious() {
        if (this.syncprev) {
            return;
        }
        this.syncprev = this._syncPrevious();
    }

    private boolean _syncPrevious() {
        PipeControlPoint pcp = this.getControlPoint();
        if (pcp != null) {
            if (this.previous != null) {
                if (this.previous.getControlPoint() != null) {
                    boolean br0;
                    boolean prev = this.previous.getNext() == this;
                    boolean bl = br0 = this.previous.getBranch0() == this;
                    if (prev) {
                        return this._connectPrev(pcp, this.previous.getControlPoint());
                    }
                    if (br0) {
                        return this._connectPrev(pcp, this.previous.getBranchPoint());
                    }
                    return false;
                }
                return false;
            }
            if (pcp.getPrevious() != null) {
                pcp.setPrevious(null);
                return true;
            }
        } else {
            return false;
        }
        return true;
    }

    protected void syncBranch0() {
        if (this.syncbr0) {
            return;
        }
        this.syncbr0 = this._syncBranch0();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean _syncBranch0() {
        if (this.getControlPoint() == null) return false;
        if (this.getControlPoint().isDualInline()) {
            this.branch0 = null;
            return false;
        }
        if (this.branch0 != null) {
            boolean prev;
            if (this.branch0.getControlPoint() == null) return false;
            PipeControlPoint branchPoint = this.getBranchPoint();
            if (branchPoint == null) {
                return false;
            }
            PipeControlPoint pcp = this.branch0.getControlPoint();
            boolean next = this.branch0.getPrevious() == this;
            boolean bl = prev = this.branch0.getNext() == this;
            if (next) {
                this._connectNext(branchPoint, pcp);
                return true;
            } else {
                if (!prev) return false;
                this._connectPrev(branchPoint, pcp);
            }
            return true;
        } else {
            if (this.getControlPoint().getChildPoints().size() <= 0) return true;
            return true;
        }
    }

    public void sync() {
        this.syncPrevious();
        this.syncNext();
        this.syncBranch0();
    }

    public void sync2() {
        this.getControlPoint()._setWorldOrientation(this.getWorldOrientation());
        this.getControlPoint()._setWorldPosition(this.getWorldPosition());
    }

    public Map<String, Object> updateParameterMap() {
        return Collections.emptyMap();
    }

    public abstract String getType();

    public abstract PipeControlPoint getControlPoint();

    public void remove() {
        PipeControlPoint pcp;
        if (DEBUG) {
            System.out.println(String.valueOf(this.toDebugString()) + " remove");
        }
        if ((pcp = this.getControlPoint()) != null && pcp.getPipelineComponent() != null) {
            if (pcp.isSizeChange()) {
                this.mergeWithAlternative();
            }
            pcp.remove();
        }
        this.setPipeRun(null);
        super.remove();
    }

    private void mergeWithAlternative() {
        PipeRun run = this.getPipeRun();
        PipeRun alternative = this.getAlternativePipeRun();
        if (alternative != null) {
            PipelineComponent p = this.getNext();
            while (p != null && p.getPipeRun() == alternative) {
                if (p.getParent() == alternative) {
                    p.deattach();
                    run.addChild(p);
                } else {
                    p.setPipeRun(run);
                }
                p.updateParameters();
                p.getControlPoint().requestUpdate();
                p = p.getNext();
            }
            this.setAlternativePipeRun(run);
            if (alternative.getChild().isEmpty()) {
                alternative.remove();
            }
        }
    }

    public void removeAndSplit() {
        PipeControlPoint pcp = this.getControlPoint();
        if (pcp != null && pcp.getPipelineComponent() != null) {
            pcp.removeAndSplit();
        }
        this.setPipeRun(null);
        super.remove();
    }

    @Override
    protected double[] getColor() {
        if (this.getControlPoint() == null || !this.getControlPoint().isFixed()) {
            return new double[]{0.7, 0.7, 0.7};
        }
        return new double[]{1.0, 0.0, 0.0};
    }

    @Override
    protected double[] getSelectedColor() {
        return new double[]{0.5, 0.0, 0.5};
    }

    public void setOrientation(Quat4d orientation) {
        if (MathTools.equals((Tuple4d)orientation, (Tuple4d)this.getOrientation())) {
            return;
        }
        super.setOrientation(orientation);
        if (this.getControlPoint() != null) {
            this.getControlPoint()._setWorldOrientation(this.getWorldOrientation());
            this.getControlPoint().requestUpdate();
        }
    }

    public void setPosition(Vector3d position) {
        if (MathTools.equals((Tuple3d)position, (Tuple3d)this.getPosition())) {
            return;
        }
        super.setPosition(position);
        if (this.getControlPoint() != null) {
            this.getControlPoint()._setWorldPosition(this.getWorldPosition());
            this.getControlPoint().requestUpdate();
        }
    }

    public void _setWorldPosition(Vector3d position) {
        Vector3d localPos = this.getLocalPosition(position);
        super.setPosition(localPos);
    }

    public void _setWorldOrientation(Quat4d orientation) {
        Quat4d localOr = this.getLocalOrientation(orientation);
        super.setOrientation(localOr);
    }

    @GetPropertyValue(name="Flow Length", value="flowlength", tabId="Default")
    public Double getFlowLength() {
        PipeControlPoint pcp = this.getControlPoint();
        if (pcp == null) {
            return null;
        }
        switch (pcp.getType()) {
            case INLINE: {
                return pcp.getLength();
            }
            case END: {
                return null;
            }
            case TURN: {
                double r = ((TurnComponent)this).getTurnRadius();
                double a = pcp.getTurnAngle();
                return a * r;
            }
        }
        return null;
    }

    public Double getDiameter() {
        return this.getPipeRun().getPipeDiameter();
    }

    public Double getDiameter2() {
        if (this.getAlternativePipeRun() == null) {
            return null;
        }
        return this.getAlternativePipeRun().getPipeDiameter();
    }

    public void getEnds(Tuple3d p1, Tuple3d p2) {
        this.getControlPoint().getControlPointEnds(p1, p2);
    }

    public void getEndDirections(Tuple3d v1, Tuple3d v2) {
        this.getControlPoint().getEndDirections(v1, v2);
    }

    public void getCentroid(Tuple3d p) {
        PipeControlPoint pcp = this.getControlPoint();
        if (pcp == null) {
            throw new IllegalStateException("No centroid defined");
        }
        switch (pcp.getType()) {
            case INLINE: 
            case END: {
                if (!pcp.isSizeChange()) {
                    p.set((Tuple3d)pcp.getWorldPosition());
                    return;
                }
                double r1 = this.getPipeRun().getInsideDiameter();
                double r2 = this.getAlternativePipeRun().getInsideDiameter();
                Vector3d p1 = new Vector3d();
                Vector3d p2 = new Vector3d();
                pcp.getInlineControlPointEnds((Tuple3d)p1, (Tuple3d)p2);
                double r12 = r1 + r2;
                r12 *= r12;
                double rmax = Math.max(r1, r2);
                double h = (r12 + 2.0 * rmax * rmax) / (4.0 * (r12 - r1 * r2));
                if (r1 < r2) {
                    h = 1.0 - h;
                }
                p2.sub((Tuple3d)p1);
                p1.scaleAdd(h, (Tuple3d)p2);
                p.set((Tuple3d)p1);
                return;
            }
            case TURN: {
                Vector3d loc = pcp.getRealPosition(PipeControlPoint.PositionType.PREVIOUS);
                double r = ((TurnComponent)this).getTurnRadius();
                double a = pcp.getTurnAngle();
                double pipeRadius = pcp.getPipeRun().getInsideDiameter() / 2.0;
                Vector3d inletDir = pcp.getPathLegDirection(PipeControlPoint.Direction.PREVIOUS);
                inletDir.scale(-1.0);
                inletDir.normalize();
                Vector3d outletDir = pcp.getPathLegDirection(PipeControlPoint.Direction.NEXT);
                Vector3d normal = new Vector3d(inletDir);
                normal.scaleAdd(-inletDir.dot(outletDir), (Tuple3d)outletDir);
                normal.normalize();
                Vector3d center = new Vector3d(normal);
                center.scaleAdd(r, (Tuple3d)loc);
                double c = r + pipeRadius * pipeRadius / (4.0 * r);
                double c1 = c * Math.sin(a) / a;
                double c2 = c * (1.0 - Math.cos(a)) / a;
                normal.scale(-c1);
                inletDir.scale(c2);
                center.add((Tuple3d)normal);
                center.add((Tuple3d)inletDir);
                p.set((Tuple3d)center);
                return;
            }
        }
        throw new IllegalStateException("No centroid defined");
    }

    public double getVolume() {
        PipeControlPoint pcp = this.getControlPoint();
        if (pcp == null) {
            throw new IllegalStateException("No centroid defined");
        }
        double pipeRadius = this.getPipeRun().getInsideDiameter() / 2.0;
        switch (pcp.getType()) {
            case INLINE: 
            case END: {
                if (!pcp.isSizeChange()) {
                    return pcp.getLength() * Math.PI * pipeRadius * pipeRadius;
                }
                double r1 = pipeRadius;
                double r2 = this.getAlternativePipeRun().getInsideDiameter() / 2.0;
                return pcp.getLength() * Math.PI * (r1 * r1 + r1 * r2 + r2 * r2) / 4.0;
            }
            case TURN: {
                double r = ((TurnComponent)this).getTurnRadius();
                double a = pcp.getTurnAngle();
                return r * a * Math.PI * pipeRadius * pipeRadius;
            }
        }
        throw new IllegalStateException("No centroid defined");
    }

    @GetPropertyValue(name="Error", value="error", tabId="Default")
    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        if (Objects.equals(this.error, error)) {
            return;
        }
        this.error = error;
        this.firePropertyChanged("error");
    }
}

