/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.plant3d.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.ActionFactory;
import org.simantics.db.request.Write;
import org.simantics.layer0.Layer0;
import org.simantics.plant3d.utils.P3DUtil;

public class NewPlantHandler
extends AbstractHandler
implements ActionFactory {
    public Runnable create(final Object target) {
        if (!(target instanceof Resource)) {
            return null;
        }
        return new Runnable(){

            @Override
            public void run() {
                NewPlantHandler.createNewPlantJob((Resource)target);
            }
        };
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Resource library = (Resource)Simantics.getProject().get();
        NewPlantHandler.createNewPlantJob(library);
        return null;
    }

    public static void createNewPlantJob(final Resource library) {
        Job job = new Job("Create Plant "){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask("Create Plant", -1);
                try {
                    Simantics.getSession().syncRequest((Write)new WriteRequest(){

                        public void perform(WriteGraph graph) throws DatabaseException {
                            Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
                            String modelName = NameUtils.findFreshName((ReadGraph)graph, (String)"Plant", (Resource)library);
                            Resource model = P3DUtil.createModel(graph, modelName);
                            graph.claim(library, l0.ConsistsOf, model);
                        }
                    });
                    return Status.OK_STATUS;
                }
                catch (DatabaseException e) {
                    return new Status(4, "org.simantics.plant3d", String.valueOf(this.getName()) + " failed.", (Throwable)e);
                }
            }
        };
        job.setUser(true);
        job.schedule();
    }
}

