/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.plant3d.gizmo;

import java.util.ArrayList;
import java.util.Collection;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector3d;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.simantics.g3d.math.MathTools;
import org.simantics.g3d.math.Ray;
import org.simantics.g3d.scenegraph.RenderListener;
import org.simantics.g3d.shape.Color4d;
import org.simantics.g3d.shape.Cone;
import org.simantics.g3d.shape.Cylinder;
import org.simantics.g3d.shape.Mesh;
import org.simantics.g3d.vtk.common.VtkView;
import org.simantics.g3d.vtk.gizmo.vtkGizmo;
import org.simantics.g3d.vtk.shape.MeshActor;
import org.simantics.g3d.vtk.swt.InteractiveVtkComposite;
import org.simantics.g3d.vtk.utils.vtkUtil;
import vtk.vtkObjectBase;
import vtk.vtkProp;
import vtk.vtkRenderer;

public class SplitPointSelectionGizmo
extends vtkGizmo {
    MeshActor actor;
    VtkView panel;
    private RenderListener listener;
    private MouseMoveListener mouseListener;
    Point3d start;
    Point3d end;
    Vector3d dir;
    Vector2d mousePos = new Vector2d();
    Vector3d pa = new Vector3d();
    Vector3d pb = new Vector3d();
    Tuple3d splitPoint = null;

    public SplitPointSelectionGizmo(VtkView panel) {
        this.panel = panel;
        int res = 16;
        Mesh cone_x = Cone.create((double)0.1, (int)res);
        cone_x.rotate(MathTools.getQuat((AxisAngle4d)new AxisAngle4d(0.0, 0.0, -1.0, 1.5707963267948966)));
        cone_x.translate(new Vector3d(0.8, 0.0, 0.0));
        Mesh tube_x = Cylinder.create((Vector3d)MathTools.ORIGIN, (Vector3d)new Vector3d(0.8, 0.0, 0.0), (double)0.05, (int)res);
        tube_x.add(cone_x);
        Color4d z_col = new Color4d(0.0, 1.0, 0.0, 1.0);
        tube_x.setColor(z_col);
        this.actor = new MeshActor();
        this.actor.setMesh(tube_x);
        panel.addDeletable((vtkObjectBase)this.actor);
        this.listener = new RenderListener(){

            public void preRender() {
                Ray ray = vtkUtil.createMouseRay((vtkRenderer)SplitPointSelectionGizmo.this.panel.getRenderer(), (double)SplitPointSelectionGizmo.this.mousePos.x, (double)SplitPointSelectionGizmo.this.mousePos.y);
                double[] mu = new double[2];
                if (MathTools.intersectStraightStraight((Tuple3d)SplitPointSelectionGizmo.this.start, (Vector3d)SplitPointSelectionGizmo.this.dir, (Tuple3d)ray.pos, (Vector3d)ray.dir, (Tuple3d)SplitPointSelectionGizmo.this.pa, (Tuple3d)SplitPointSelectionGizmo.this.pb, (double[])mu)) {
                    SplitPointSelectionGizmo.this.splitPoint = SplitPointSelectionGizmo.this.pa;
                    if (mu[0] < 0.0) {
                        SplitPointSelectionGizmo.this.splitPoint = SplitPointSelectionGizmo.this.start;
                    } else if (mu[0] > 1.0) {
                        SplitPointSelectionGizmo.this.splitPoint = SplitPointSelectionGizmo.this.end;
                    }
                    Vector3d dir = new Vector3d(SplitPointSelectionGizmo.this.splitPoint);
                    dir.sub((Tuple3d)SplitPointSelectionGizmo.this.pb);
                    double length = dir.length();
                    dir.scale(1.0 / length);
                    AxisAngle4d aa = MathTools.createRotation((Vector3d)MathTools.X_AXIS, (Vector3d)dir);
                    SplitPointSelectionGizmo.this.setRotation(aa);
                    SplitPointSelectionGizmo.this.setScale(length);
                    SplitPointSelectionGizmo.this.setPosition((Tuple3d)SplitPointSelectionGizmo.this.pb);
                    SplitPointSelectionGizmo.this.actor.SetVisibility(1);
                } else {
                    SplitPointSelectionGizmo.this.splitPoint = null;
                    SplitPointSelectionGizmo.this.actor.SetVisibility(0);
                }
            }

            public void postRender() {
            }
        };
        this.mouseListener = new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                SplitPointSelectionGizmo.this.mousePos.x = e.x;
                SplitPointSelectionGizmo.this.mousePos.y = e.y;
                SplitPointSelectionGizmo.this.panel.refresh();
            }
        };
    }

    public void setSplit(Point3d start, Point3d end) {
        this.start = start;
        this.end = end;
        this.dir = new Vector3d((Tuple3d)end);
        this.dir.sub((Tuple3d)start);
    }

    public void attach(VtkView renderingPart) {
        super.attach(renderingPart);
        this.panel.addListener(this.listener);
        ((InteractiveVtkComposite)this.panel).getComponent().addMouseMoveListener(this.mouseListener);
    }

    public void deattach() {
        this.panel.removeListener(this.listener);
        super.deattach();
    }

    public Collection<vtkProp> getGizmo() {
        ArrayList<vtkProp> coll = new ArrayList<vtkProp>();
        coll.add((vtkProp)this.actor);
        return coll;
    }

    public Tuple3d getSplitPoint() {
        return this.splitPoint;
    }
}

