/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g3d.shape;

import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Quat4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.simantics.g3d.math.MathTools;
import org.simantics.g3d.shape.Color4d;

public class Mesh {
    private List<Tuple3d> vertices;
    private List<Tuple3d> normals;
    private List<Color4d> colors;
    private List<Integer> indices;

    public Mesh(List<Tuple3d> vertices, List<Tuple3d> normals, List<Color4d> colors, List<Integer> indices) {
        this.vertices = vertices;
        this.normals = normals;
        this.colors = colors;
        this.indices = indices;
    }

    public Mesh(List<Tuple3d> vertices, List<Tuple3d> normals, List<Integer> indices) {
        this.vertices = vertices;
        this.normals = normals;
        this.indices = indices;
    }

    public static Mesh create(List<Vector3d> vertices, List<Vector3d> normals, List<Integer> indices) {
        ArrayList<Tuple3d> v = new ArrayList<Tuple3d>();
        ArrayList<Tuple3d> n = new ArrayList<Tuple3d>();
        v.addAll(vertices);
        n.addAll(normals);
        return new Mesh(v, n, indices);
    }

    public Mesh(List<Tuple3d> vertices, List<Integer> indices) {
        this.vertices = vertices;
        this.indices = indices;
    }

    public static Mesh create(List<Vector3d> vertices, List<Integer> indices) {
        ArrayList<Tuple3d> v = new ArrayList<Tuple3d>();
        v.addAll(vertices);
        return new Mesh(v, indices);
    }

    public List<Tuple3d> getVertices() {
        return this.vertices;
    }

    public List<Tuple3d> getNormals() {
        return this.normals;
    }

    public List<Integer> getIndices() {
        return this.indices;
    }

    public List<Color4d> getColors() {
        return this.colors;
    }

    public void createNormals() {
        this.normals = new ArrayList<Tuple3d>(this.vertices.size());
        int i = 0;
        while (i < this.vertices.size()) {
            this.normals.add((Tuple3d)new Vector3d());
            ++i;
        }
        Vector3d v1 = new Vector3d();
        Vector3d v2 = new Vector3d();
        Vector3d v3 = new Vector3d();
        Vector3d t1 = new Vector3d();
        Vector3d t2 = new Vector3d();
        Vector3d n = new Vector3d();
        int i2 = 0;
        while (i2 < this.indices.size()) {
            v1.set(this.vertices.get(i2));
            v2.set(this.vertices.get(i2 + 1));
            v3.set(this.vertices.get(i2 + 2));
            t1.sub((Tuple3d)v3, (Tuple3d)v1);
            t2.sub((Tuple3d)v2, (Tuple3d)v1);
            n.cross(t2, t1);
            this.normals.get(i2).add((Tuple3d)n);
            this.normals.get(i2 + 1).add((Tuple3d)n);
            this.normals.get(i2 + 2).add((Tuple3d)n);
            i2 += 3;
        }
        i2 = 0;
        while (i2 < this.normals.size()) {
            ((Vector3d)this.normals.get(i2)).normalize();
            ++i2;
        }
    }

    public void translate(Vector3d v) {
        int i = 0;
        while (i < this.vertices.size()) {
            this.vertices.get(i).add((Tuple3d)v);
            ++i;
        }
    }

    public void rotate(Quat4d q) {
        Vector3d t = new Vector3d();
        int i = 0;
        while (i < this.vertices.size()) {
            MathTools.rotate(q, this.vertices.get(i), (Tuple3d)t);
            this.vertices.get(i).set((Tuple3d)t);
            ++i;
        }
        if (this.normals != null) {
            i = 0;
            while (i < this.normals.size()) {
                MathTools.rotate(q, this.normals.get(i), (Tuple3d)t);
                t.normalize();
                this.normals.get(i).set((Tuple3d)t);
                ++i;
            }
        }
    }

    public void setColor(Color4d color) {
        this.colors = new ArrayList<Color4d>(this.vertices.size());
        int i = 0;
        while (i < this.vertices.size()) {
            this.colors.add(color);
            ++i;
        }
    }

    public void add(Mesh mesh) {
        int vindex = this.vertices.size();
        int triIndex = this.indices.size();
        this.vertices.addAll(mesh.getVertices());
        this.indices.addAll(mesh.indices);
        int i = triIndex;
        while (i < this.indices.size()) {
            this.indices.set(i, this.indices.get(i) + vindex);
            ++i;
        }
        if (this.normals != null) {
            boolean hasNormals = true;
            if (mesh.getNormals() == null) {
                mesh.createNormals();
                hasNormals = false;
            }
            this.normals.addAll(mesh.getNormals());
            if (!hasNormals) {
                mesh.normals = null;
            }
        }
        if (this.colors != null) {
            if (mesh.getColors() != null) {
                this.colors.addAll(mesh.getColors());
            } else {
                i = 0;
                while (i < mesh.getVertices().size()) {
                    this.colors.add(new Color4d(1.0, 1.0, 1.0, 0.0));
                    ++i;
                }
            }
        }
    }
}

