/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g3d.vtk.swt;

import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.simantics.g3d.tools.AdaptationUtils;
import org.simantics.g3d.vtk.swt.InteractiveVtkComposite;
import org.simantics.g3d.vtk.swt.vtkSwtAction;
import vtk.vtkCamera;
import vtk.vtkProp;
import vtk.vtkProp3D;
import vtk.vtkRenderWindow;
import vtk.vtkRenderer;

public class vtkCameraAndSelectorAction
extends vtkSwtAction
implements ISelectionProvider {
    protected vtkRenderer ren;
    protected int lastX;
    protected int lastY;
    protected vtkRenderWindow rw;
    protected vtkCamera cam;
    protected int InteractionMode = 1;
    protected double activeRate = 5.0;
    protected double passiveRate = 0.01;
    protected boolean doNotRotate = true;
    private double[] upDirection = new double[]{0.0, 1.0, 0.0};
    protected List<vtkProp> selectActors = new ArrayList<vtkProp>();
    protected List<vtkProp> hoverActor = new ArrayList<vtkProp>();
    private List<ISelectionChangedListener> selectionListeners = new ArrayList<ISelectionChangedListener>();
    private List<ISelectionChangedListener> hoverListeners = new ArrayList<ISelectionChangedListener>();

    public vtkCameraAndSelectorAction(InteractiveVtkComposite panel) {
        super(panel);
        this.ren = panel.getRenderer();
        this.rw = panel.getRenderWindow();
        this.cam = this.ren.GetActiveCamera();
    }

    public void setUpDirection(double[] upDirection) {
        this.upDirection = upDirection;
    }

    public void Lock() {
        this.panel.lock();
    }

    public void UnLock() {
        this.panel.unlock();
    }

    public void InteractionModeRotate() {
        this.InteractionMode = 1;
    }

    public void InteractionModeTranslate() {
        this.InteractionMode = 2;
    }

    public void InteractionModeZoom() {
        this.InteractionMode = 3;
    }

    public void resetCameraClippingRange() {
        this.Lock();
        this.ren.ResetCameraClippingRange();
        this.UnLock();
    }

    public void resetCamera() {
        this.Lock();
        this.ren.ResetCamera();
        this.UnLock();
    }

    @Override
    public boolean mousePressed(MouseEvent e) {
        if (this.ren.VisibleActorCount() == 0) {
            return false;
        }
        this.rw.SetDesiredUpdateRate(this.activeRate);
        this.lastX = e.getX();
        this.lastY = e.getY();
        if (e.getModifiers() == 8 || e.getModifiers() == 17) {
            this.InteractionModeTranslate();
        } else if (e.getModifiers() == 4) {
            this.InteractionModeZoom();
        } else {
            this.InteractionModeRotate();
        }
        return true;
    }

    @Override
    public boolean mouseReleased(MouseEvent e) {
        this.rw.SetDesiredUpdateRate(this.passiveRate);
        return true;
    }

    @Override
    public boolean mouseDragged(MouseEvent e) {
        if (this.ren.VisibleActorCount() == 0) {
            return false;
        }
        int x = e.getX();
        int y = e.getY();
        if (this.InteractionMode == 1) {
            this.cam.Elevation(this.clampElevationDelta(y - this.lastY));
            if (this.doNotRotate) {
                this.cam.SetViewUp(this.upDirection);
            }
            this.cam.Azimuth((double)(this.lastX - x));
            this.cam.OrthogonalizeViewUp();
            this.resetCameraClippingRange();
        }
        if (this.InteractionMode == 2) {
            double[] FPoint = this.cam.GetFocalPoint();
            double[] PPoint = this.cam.GetPosition();
            this.ren.SetWorldPoint(FPoint[0], FPoint[1], FPoint[2], 1.0);
            this.ren.WorldToDisplay();
            double[] APoint = this.ren.GetDisplayPoint();
            APoint[0] = APoint[0] - (double)(x - this.lastX);
            APoint[1] = APoint[1] + (double)(y - this.lastY);
            this.ren.SetDisplayPoint(APoint);
            this.ren.DisplayToWorld();
            double[] RPoint = this.ren.GetWorldPoint();
            if (RPoint[3] != 0.0) {
                RPoint[0] = RPoint[0] / RPoint[3];
                RPoint[1] = RPoint[1] / RPoint[3];
                RPoint[2] = RPoint[2] / RPoint[3];
            }
            this.cam.SetFocalPoint(RPoint);
            this.cam.SetPosition(RPoint[0] - FPoint[0] + PPoint[0], RPoint[1] - FPoint[1] + PPoint[1], RPoint[2] - FPoint[2] + PPoint[2]);
            this.resetCameraClippingRange();
        }
        if (this.InteractionMode == 3) {
            double zoomFactor = Math.pow(1.02, y - this.lastY);
            this.cam.Dolly(zoomFactor);
            if (this.cam.GetParallelProjection() == 1) {
                this.updateParallelScale();
            }
            this.resetCameraClippingRange();
        }
        this.lastX = x;
        this.lastY = y;
        this.panel.refresh();
        return true;
    }

    private static double dot(double[] a, double[] b) {
        return a[0] * b[0] + a[1] * b[1] + a[2] * b[2];
    }

    private double clampElevationDelta(double elevationDelta) {
        if (!this.doNotRotate) {
            return elevationDelta;
        }
        double[] direction = this.cam.GetDirectionOfProjection();
        double d = Math.min(1.0, Math.max(-1.0, vtkCameraAndSelectorAction.dot(direction, this.upDirection)));
        double elevation = Math.toDegrees(Math.acos(d)) + elevationDelta;
        if (elevation < 0.0) {
            elevationDelta -= elevation - 1.0E-5;
        } else if (elevation > 180.0) {
            elevationDelta -= elevation - 180.0 + 1.0E-5;
        }
        return elevationDelta;
    }

    @Override
    public boolean mouseWheelMoved(MouseWheelEvent e) {
        double zoomFactor = Math.pow(1.02, e.getWheelRotation());
        this.cam.Dolly(zoomFactor);
        this.updateParallelScale();
        this.resetCameraClippingRange();
        this.panel.refresh();
        return true;
    }

    private void updateParallelScale() {
        double distance = this.cam.GetDistance();
        double angle = this.cam.GetViewAngle();
        double scale = Math.tan(Math.toRadians(angle / 2.0)) * distance;
        this.cam.SetParallelScale(scale);
    }

    @Override
    public boolean mouseClicked(MouseEvent e) {
        if (!this.panel.getComponent().isFocusControl()) {
            return false;
        }
        if (e.getButton() != 1) {
            return false;
        }
        vtkProp[] spick = this.panel.pick(e.getX(), e.getY());
        if (spick != null && spick.length > 0) {
            vtkProp[] vtkPropArray = spick;
            int n = spick.length;
            int n2 = 0;
            while (n2 < n) {
                vtkProp selectActor = vtkPropArray[n2];
                if (!e.isControlDown()) {
                    this.selectActors.clear();
                    this.selectActors.add(selectActor);
                } else if (this.selectActors.contains(selectActor)) {
                    this.selectActors.remove(selectActor);
                } else {
                    this.selectActors.add(selectActor);
                }
                ++n2;
            }
            this.fireSelectionChanged();
        } else if (!e.isControlDown()) {
            this.selectActors.clear();
            this.fireSelectionChanged();
        }
        return true;
    }

    @Override
    public boolean mouseMoved(MouseEvent e) {
        this.lastX = e.getX();
        this.lastY = e.getY();
        if (!this.panel.getComponent().isFocusControl()) {
            return false;
        }
        ArrayList<vtkProp> prevHover = new ArrayList<vtkProp>();
        prevHover.addAll(this.hoverActor);
        this.hoverActor.clear();
        vtkProp[] pick = this.panel.pick(e.getX(), e.getY());
        if (pick != null) {
            vtkProp[] vtkPropArray = pick;
            int n = pick.length;
            int n2 = 0;
            while (n2 < n) {
                vtkProp p = vtkPropArray[n2];
                this.hoverActor.add(p);
                ++n2;
            }
        }
        if (!prevHover.containsAll(this.hoverActor) || !this.hoverActor.containsAll(prevHover)) {
            this.fireHoverChanged();
        }
        return true;
    }

    public List<vtkProp> getSelectActor() {
        return this.selectActors;
    }

    public List<vtkProp> getHoverActor() {
        return this.hoverActor;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.add(listener);
    }

    public ISelection getSelection() {
        return new StructuredSelection(this.selectActors);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
        this.setSelection(selection, false);
    }

    public void setSelection(ISelection selection, boolean fire) {
        Collection selectedProps = AdaptationUtils.adaptToCollection((Object)selection, vtkProp.class);
        this.selectActors.clear();
        this.selectActors.addAll(selectedProps);
        if (fire) {
            this.fireSelectionChanged();
        }
    }

    protected void fireSelectionChanged() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                SelectionChangedEvent evt = new SelectionChangedEvent((ISelectionProvider)vtkCameraAndSelectorAction.this, (ISelection)new StructuredSelection(vtkCameraAndSelectorAction.this.selectActors));
                for (ISelectionChangedListener l : vtkCameraAndSelectorAction.this.selectionListeners) {
                    l.selectionChanged(evt);
                }
            }
        });
    }

    public void addHoverChangedListener(ISelectionChangedListener listener) {
        this.hoverListeners.add(listener);
    }

    public ISelection getHoverSelection() {
        return new StructuredSelection(this.hoverActor);
    }

    public void removeHoverChangedListener(ISelectionChangedListener listener) {
        this.hoverListeners.remove(listener);
    }

    private void fireHoverChanged() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                StructuredSelection sel = null;
                sel = vtkCameraAndSelectorAction.this.hoverActor == null ? new StructuredSelection() : new StructuredSelection(vtkCameraAndSelectorAction.this.hoverActor);
                SelectionChangedEvent evt = new SelectionChangedEvent((ISelectionProvider)vtkCameraAndSelectorAction.this, (ISelection)sel);
                for (ISelectionChangedListener l : vtkCameraAndSelectorAction.this.hoverListeners) {
                    l.selectionChanged(evt);
                }
            }
        });
    }

    public void focus(double x, double y, double z) {
        this.Lock();
        this.cam.SetFocalPoint(x, y, z);
        if (this.doNotRotate) {
            double[] proj = this.cam.GetDirectionOfProjection();
            if (Math.abs(proj[1] * this.upDirection[2] - proj[2] * this.upDirection[1]) < 1.0E-6 && Math.abs(proj[2] * this.upDirection[0] - proj[0] * this.upDirection[2]) < 1.0E-6 && Math.abs(proj[0] * this.upDirection[1] - proj[1] * this.upDirection[0]) < 1.0E-6) {
                this.cam.SetViewUp(this.upDirection[1], this.upDirection[2], this.upDirection[0]);
            } else {
                this.cam.SetViewUp(this.upDirection);
            }
        }
        this.cam.OrthogonalizeViewUp();
        this.resetCameraClippingRange();
        this.UnLock();
    }

    public void fitToView(Collection<vtkProp3D> props) {
        if (props.isEmpty()) {
            return;
        }
        double[] bounds = new double[]{Double.MAX_VALUE, -1.7976931348623157E308, Double.MAX_VALUE, -1.7976931348623157E308, Double.MAX_VALUE, -1.7976931348623157E308};
        double[] b = new double[6];
        for (vtkProp3D prop : props) {
            prop.GetBounds(b);
            int i = 0;
            while (i < 6) {
                bounds[i] = Math.min(bounds[i], b[i]);
                i += 2;
            }
            i = 1;
            while (i < 6) {
                bounds[i] = Math.max(bounds[i], b[i]);
                i += 2;
            }
        }
        this.fitToView(bounds);
    }

    public void fitToView(double[] bounds) {
        Vector3d center = new Vector3d((bounds[0] + bounds[1]) / 2.0, (bounds[2] + bounds[3]) / 2.0, (bounds[4] + bounds[5]) / 2.0);
        Vector3d viewDir = new Vector3d(this.cam.GetDirectionOfProjection());
        Vector3d upDir = new Vector3d(this.cam.GetViewUp());
        viewDir.normalize();
        upDir.normalize();
        Vector3d sideDir = new Vector3d();
        sideDir.cross(viewDir, upDir);
        sideDir.normalize();
        double width = vtkCameraAndSelectorAction.getBoxWidth(bounds, sideDir);
        double height = vtkCameraAndSelectorAction.getBoxWidth(bounds, upDir);
        double depth = vtkCameraAndSelectorAction.getBoxWidth(bounds, viewDir);
        int[] size = this.rw.GetActualSize();
        double distance1 = height / 2.0 / Math.tan(Math.toRadians(this.cam.GetViewAngle()) / 2.0);
        double distance2 = distance1 * (width / (double)size[0] / (height / (double)size[1]));
        double distance = Math.max(distance1, distance2) + depth / 2.0;
        viewDir.scale(-distance);
        viewDir.add((Tuple3d)center);
        this.cam.SetPosition(viewDir.x, viewDir.y, viewDir.z);
        this.focus(center.x, center.y, center.z);
        if (this.cam.GetParallelProjection() == 1) {
            this.cam.SetParallelScale(Math.max(height, width * (double)size[1] / (double)size[0]) / 2.0);
        }
    }

    private static double getBoxWidth(double[] bounds, Vector3d dir) {
        double dx = bounds[1] - bounds[0];
        double dy = bounds[3] - bounds[2];
        double dz = bounds[5] - bounds[4];
        return Math.abs(dx * dir.x) + Math.abs(dy * dir.y) + Math.abs(dz * dir.z);
    }

    public void setViewDir(Vector3d direction) {
        Vector3d focal = new Vector3d(this.cam.GetFocalPoint());
        Vector3d pos = new Vector3d(this.cam.GetPosition());
        Vector3d dir = new Vector3d(pos);
        dir.sub((Tuple3d)focal);
        double distance = dir.length();
        dir.scaleAdd(distance, (Tuple3d)direction, (Tuple3d)focal);
        this.cam.SetPosition(dir.x, dir.y, dir.z);
        this.focus(focal.x, focal.y, focal.z);
        this.panel.refresh();
    }
}

