/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g3d.vtk.awt;

import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.vecmath.Point2d;
import javax.vecmath.Point2i;
import javax.vecmath.Point3d;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.simantics.g3d.tools.AdaptationUtils;
import org.simantics.g3d.vtk.awt.InteractiveVtkPanel;
import org.simantics.g3d.vtk.awt.vtkAwtAction;
import vtk.vtkCamera;
import vtk.vtkProp;
import vtk.vtkRenderWindow;
import vtk.vtkRenderer;

public class vtkCameraAndSelectorAction
extends vtkAwtAction
implements ISelectionProvider {
    protected vtkRenderer ren;
    protected int lastX;
    protected int lastY;
    protected vtkRenderWindow rw;
    protected vtkCamera cam;
    protected int InteractionMode = 1;
    protected double activeRate = 5.0;
    protected double passiveRate = 0.01;
    protected boolean doNotRotate = true;
    private List<vtkProp> selectActors = new ArrayList<vtkProp>();
    private List<vtkProp> hoverActor = new ArrayList<vtkProp>();
    private List<ISelectionChangedListener> selectionListeners = new ArrayList<ISelectionChangedListener>();
    private List<ISelectionChangedListener> hoverListeners = new ArrayList<ISelectionChangedListener>();

    public vtkCameraAndSelectorAction(InteractiveVtkPanel panel) {
        super(panel);
        this.ren = panel.GetRenderer();
        this.rw = panel.GetRenderWindow();
        this.cam = this.ren.GetActiveCamera();
    }

    public void Lock() {
        this.panel.lock();
    }

    public void UnLock() {
        this.panel.unlock();
    }

    public void InteractionModeRotate() {
        this.InteractionMode = 1;
    }

    public void InteractionModeTranslate() {
        this.InteractionMode = 2;
    }

    public void InteractionModeZoom() {
        this.InteractionMode = 3;
    }

    public void resetCameraClippingRange() {
        this.Lock();
        this.ren.ResetCameraClippingRange();
        this.UnLock();
    }

    public void resetCamera() {
        this.Lock();
        this.ren.ResetCamera();
        this.UnLock();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.ren.VisibleActorCount() == 0) {
            return;
        }
        this.rw.SetDesiredUpdateRate(this.activeRate);
        this.lastX = e.getX();
        this.lastY = e.getY();
        if (e.getModifiers() == 8 || e.getModifiers() == 17) {
            this.InteractionModeTranslate();
        } else if (e.getModifiers() == 4) {
            this.InteractionModeZoom();
        } else {
            this.InteractionModeRotate();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.rw.SetDesiredUpdateRate(this.passiveRate);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.ren.VisibleActorCount() == 0) {
            return;
        }
        int x = e.getX();
        int y = e.getY();
        if (this.InteractionMode == 1) {
            this.cam.Azimuth((double)(this.lastX - x));
            this.cam.Elevation((double)(y - this.lastY));
            if (this.doNotRotate) {
                this.cam.SetRoll(0.0);
            }
            this.cam.OrthogonalizeViewUp();
            this.resetCameraClippingRange();
            this.panel.UpdateLight();
        }
        if (this.InteractionMode == 2) {
            double[] APoint = new double[3];
            double[] FPoint = this.cam.GetFocalPoint();
            double[] PPoint = this.cam.GetPosition();
            this.ren.SetWorldPoint(FPoint[0], FPoint[1], FPoint[2], 1.0);
            this.ren.WorldToDisplay();
            double focalDepth = this.ren.GetDisplayPoint()[2];
            APoint[0] = (double)this.rw.GetSize()[0] / 2.0 + (double)(x - this.lastX);
            APoint[1] = (double)this.rw.GetSize()[1] / 2.0 - (double)(y - this.lastY);
            APoint[2] = focalDepth;
            this.ren.SetDisplayPoint(APoint);
            this.ren.DisplayToWorld();
            double[] RPoint = this.ren.GetWorldPoint();
            if (RPoint[3] != 0.0) {
                RPoint[0] = RPoint[0] / RPoint[3];
                RPoint[1] = RPoint[1] / RPoint[3];
                RPoint[2] = RPoint[2] / RPoint[3];
            }
            this.cam.SetFocalPoint((FPoint[0] - RPoint[0]) / 2.0 + FPoint[0], (FPoint[1] - RPoint[1]) / 2.0 + FPoint[1], (FPoint[2] - RPoint[2]) / 2.0 + FPoint[2]);
            this.cam.SetPosition((FPoint[0] - RPoint[0]) / 2.0 + PPoint[0], (FPoint[1] - RPoint[1]) / 2.0 + PPoint[1], (FPoint[2] - RPoint[2]) / 2.0 + PPoint[2]);
            this.resetCameraClippingRange();
        }
        if (this.InteractionMode == 3) {
            double zoomFactor = Math.pow(1.02, y - this.lastY);
            if (this.cam.GetParallelProjection() == 1) {
                this.cam.SetParallelScale(this.cam.GetParallelScale() / zoomFactor);
            } else {
                this.cam.Dolly(zoomFactor);
                this.resetCameraClippingRange();
            }
        }
        this.lastX = x;
        this.lastY = y;
        this.panel.Render();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (!this.panel.isFocusOwner()) {
            return;
        }
        if (e.getButton() != 1) {
            return;
        }
        this.lastX = e.getX();
        this.lastY = e.getY();
        vtkProp[] spick = this.panel.pick(e.getX(), e.getY());
        if (spick != null && spick.length > 0) {
            vtkProp[] vtkPropArray = spick;
            int n = spick.length;
            int n2 = 0;
            while (n2 < n) {
                vtkProp selectActor = vtkPropArray[n2];
                if (!e.isControlDown()) {
                    this.selectActors.clear();
                    this.selectActors.add(selectActor);
                } else if (this.selectActors.contains(selectActor)) {
                    this.selectActors.remove(selectActor);
                } else {
                    this.selectActors.add(selectActor);
                }
                ++n2;
            }
            this.fireSelectionChanged();
        } else if (!e.isControlDown()) {
            this.selectActors.clear();
            this.fireSelectionChanged();
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.lastX = e.getX();
        this.lastY = e.getY();
        if (!this.panel.isFocusOwner()) {
            return;
        }
        ArrayList<vtkProp> prevHover = new ArrayList<vtkProp>();
        prevHover.addAll(this.hoverActor);
        this.hoverActor.clear();
        vtkProp[] pick = this.panel.pick(e.getX(), e.getY());
        if (pick != null) {
            vtkProp[] vtkPropArray = pick;
            int n = pick.length;
            int n2 = 0;
            while (n2 < n) {
                vtkProp p = vtkPropArray[n2];
                this.hoverActor.add(p);
                ++n2;
            }
        }
        if (!prevHover.containsAll(this.hoverActor) || !this.hoverActor.containsAll(prevHover)) {
            this.fireHoverChanged();
        }
    }

    public Point2i getMousePositionAWT() {
        return new Point2i(this.lastX, this.lastY);
    }

    public Point2d getMousePosition() {
        return new Point2d((double)this.lastX, (double)(this.rw.GetSize()[1] - this.lastY));
    }

    public List<vtkProp> getSelectActor() {
        return this.selectActors;
    }

    public List<vtkProp> getHoverActor() {
        return this.hoverActor;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.add(listener);
    }

    public ISelection getSelection() {
        return new StructuredSelection(this.selectActors);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
        this.setSelection(selection, false);
    }

    public void setSelection(ISelection selection, boolean fire) {
        Collection selectedProps = AdaptationUtils.adaptToCollection((Object)selection, vtkProp.class);
        this.selectActors.clear();
        this.selectActors.addAll(selectedProps);
        if (fire) {
            this.fireSelectionChanged();
        }
    }

    private void fireSelectionChanged() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                SelectionChangedEvent evt = new SelectionChangedEvent((ISelectionProvider)vtkCameraAndSelectorAction.this, (ISelection)new StructuredSelection(vtkCameraAndSelectorAction.this.selectActors));
                for (ISelectionChangedListener l : vtkCameraAndSelectorAction.this.selectionListeners) {
                    l.selectionChanged(evt);
                }
            }
        });
    }

    public void addHoverChangedListener(ISelectionChangedListener listener) {
        this.hoverListeners.add(listener);
    }

    public ISelection getHoverSelection() {
        return new StructuredSelection(this.hoverActor);
    }

    public void removeHoverChangedListener(ISelectionChangedListener listener) {
        this.hoverListeners.remove(listener);
    }

    private void fireHoverChanged() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                StructuredSelection sel = null;
                sel = vtkCameraAndSelectorAction.this.hoverActor == null ? new StructuredSelection() : new StructuredSelection(vtkCameraAndSelectorAction.this.hoverActor);
                SelectionChangedEvent evt = new SelectionChangedEvent((ISelectionProvider)vtkCameraAndSelectorAction.this, (ISelection)sel);
                for (ISelectionChangedListener l : vtkCameraAndSelectorAction.this.hoverListeners) {
                    l.selectionChanged(evt);
                }
            }
        });
    }

    public vtkCamera getCamera() {
        return this.cam;
    }

    public Point3d getPosition() {
        double[] pos = this.cam.GetPosition();
        return new Point3d(pos);
    }

    public Point3d getFocus() {
        double[] pos = this.cam.GetFocalPoint();
        return new Point3d(pos);
    }

    public void setFocus(Point3d focus) {
        this.setFocus(focus.x, focus.y, focus.z);
    }

    public void setFocus(double x, double y, double z) {
        this.Lock();
        this.cam.SetFocalPoint(x, y, z);
        if (this.doNotRotate) {
            this.cam.SetRoll(0.0);
        }
        this.cam.OrthogonalizeViewUp();
        this.ren.ResetCameraClippingRange();
        this.panel.UpdateLight();
        this.UnLock();
    }

    public void setPosition(Point3d position) {
        this.setPosition(position.x, position.y, position.z);
    }

    public void setPosition(double x, double y, double z) {
        this.Lock();
        this.cam.SetPosition(x, y, z);
        if (this.doNotRotate) {
            this.cam.SetRoll(0.0);
        }
        this.cam.OrthogonalizeViewUp();
        this.ren.ResetCameraClippingRange();
        this.panel.UpdateLight();
        this.UnLock();
    }
}

