/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.koloboke.collect.impl;

import com.koloboke.collect.map.DoubleShortMap;


public interface InternalDoubleShortMapOps
        extends DoubleShortMap, InternalMapOps<Double, Short> {

    boolean containsEntry(double key, short value);

    void justPut(double key, short value);

    boolean containsEntry(long key, short value);

    void justPut(long key, short value);

    boolean allEntriesContainingIn(InternalDoubleShortMapOps map);

    void reversePutAllTo(InternalDoubleShortMapOps map);
}
