/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.koloboke.collect.map.hash;

import com.koloboke.collect.*;
import com.koloboke.collect.hash.*;
import com.koloboke.compile.CustomKeyEquivalence;
import com.koloboke.compile.KolobokeMap;
import java.util.function.Consumer;
import com.koloboke.collect.map.*;

import javax.annotation.Nonnull;

import java.util.Map;



/**
 * An immutable factory of {@code HashByteFloatMap}s.
 *
 * @see HashByteFloatMap
 * @see HashByteFloatMaps#getDefaultFactory()
 * @see KolobokeMap @KolobokeMap
 */
public interface HashByteFloatMapFactory
        extends ByteFloatMapFactory<HashByteFloatMapFactory>
        , ByteHashFactory<HashByteFloatMapFactory>
        {


    

    

    

    

    

    
    

    
    


    @Override
    @Nonnull
     HashByteFloatMap newMutableMap();

    @Override
    @Nonnull
     HashByteFloatMap newMutableMap(int expectedSize);

    


    @Override
    @Nonnull
     HashByteFloatMap newMutableMap(@Nonnull Map<Byte, Float> map1,
            @Nonnull Map<Byte, Float> map2, int expectedSize);

    @Override
    @Nonnull
     HashByteFloatMap newMutableMap(@Nonnull Map<Byte, Float> map1,
            @Nonnull Map<Byte, Float> map2,
            @Nonnull Map<Byte, Float> map3, int expectedSize);

    @Override
    @Nonnull
     HashByteFloatMap newMutableMap(@Nonnull Map<Byte, Float> map1,
            @Nonnull Map<Byte, Float> map2,
            @Nonnull Map<Byte, Float> map3,
            @Nonnull Map<Byte, Float> map4, int expectedSize);

    @Override
    @Nonnull
     HashByteFloatMap newMutableMap(@Nonnull Map<Byte, Float> map1,
            @Nonnull Map<Byte, Float> map2,
            @Nonnull Map<Byte, Float> map3,
            @Nonnull Map<Byte, Float> map4,
            @Nonnull Map<Byte, Float> map5, int expectedSize);



    @Override
    @Nonnull
     HashByteFloatMap newMutableMap(@Nonnull
            Consumer<com.koloboke.function.ByteFloatConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashByteFloatMap newMutableMap(
            @Nonnull byte[] keys, @Nonnull float[] values, int expectedSize);

    @Override
    @Nonnull
     HashByteFloatMap newMutableMap(
            @Nonnull Byte[] keys, @Nonnull Float[] values, int expectedSize);

    @Override
    @Nonnull
     HashByteFloatMap newMutableMap(@Nonnull Iterable<Byte> keys,
            @Nonnull Iterable<Float> values, int expectedSize);

    

    @Override
    @Nonnull
     HashByteFloatMap newMutableMap(
            @Nonnull Map<Byte, Float> map);

    @Override
    @Nonnull
     HashByteFloatMap newMutableMap(@Nonnull Map<Byte, Float> map1,
            @Nonnull Map<Byte, Float> map2);

    @Override
    @Nonnull
     HashByteFloatMap newMutableMap(@Nonnull Map<Byte, Float> map1,
            @Nonnull Map<Byte, Float> map2,
            @Nonnull Map<Byte, Float> map3);

    @Override
    @Nonnull
     HashByteFloatMap newMutableMap(@Nonnull Map<Byte, Float> map1,
            @Nonnull Map<Byte, Float> map2,
            @Nonnull Map<Byte, Float> map3,
            @Nonnull Map<Byte, Float> map4);

    @Override
    @Nonnull
     HashByteFloatMap newMutableMap(@Nonnull Map<Byte, Float> map1,
            @Nonnull Map<Byte, Float> map2,
            @Nonnull Map<Byte, Float> map3,
            @Nonnull Map<Byte, Float> map4,
            @Nonnull Map<Byte, Float> map5);



    @Override
    @Nonnull
     HashByteFloatMap newMutableMap(@Nonnull
            Consumer<com.koloboke.function.ByteFloatConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashByteFloatMap newMutableMap(
            @Nonnull byte[] keys, @Nonnull float[] values);

    @Override
    @Nonnull
     HashByteFloatMap newMutableMap(
            @Nonnull Byte[] keys, @Nonnull Float[] values);

    @Override
    @Nonnull
     HashByteFloatMap newMutableMap(@Nonnull Iterable<Byte> keys,
            @Nonnull Iterable<Float> values);


    @Override
    @Nonnull
     HashByteFloatMap newMutableMapOf(byte k1, float v1);

    @Override
    @Nonnull
     HashByteFloatMap newMutableMapOf(byte k1, float v1,
            byte k2, float v2);

    @Override
    @Nonnull
     HashByteFloatMap newMutableMapOf(byte k1, float v1,
            byte k2, float v2, byte k3, float v3);

    @Override
    @Nonnull
     HashByteFloatMap newMutableMapOf(byte k1, float v1,
            byte k2, float v2, byte k3, float v3,
            byte k4, float v4);

    @Override
    @Nonnull
     HashByteFloatMap newMutableMapOf(byte k1, float v1,
            byte k2, float v2, byte k3, float v3,
            byte k4, float v4, byte k5, float v5);
    @Override
    @Nonnull
     HashByteFloatMap newUpdatableMap();

    @Override
    @Nonnull
     HashByteFloatMap newUpdatableMap(int expectedSize);

    


    @Override
    @Nonnull
     HashByteFloatMap newUpdatableMap(@Nonnull Map<Byte, Float> map1,
            @Nonnull Map<Byte, Float> map2, int expectedSize);

    @Override
    @Nonnull
     HashByteFloatMap newUpdatableMap(@Nonnull Map<Byte, Float> map1,
            @Nonnull Map<Byte, Float> map2,
            @Nonnull Map<Byte, Float> map3, int expectedSize);

    @Override
    @Nonnull
     HashByteFloatMap newUpdatableMap(@Nonnull Map<Byte, Float> map1,
            @Nonnull Map<Byte, Float> map2,
            @Nonnull Map<Byte, Float> map3,
            @Nonnull Map<Byte, Float> map4, int expectedSize);

    @Override
    @Nonnull
     HashByteFloatMap newUpdatableMap(@Nonnull Map<Byte, Float> map1,
            @Nonnull Map<Byte, Float> map2,
            @Nonnull Map<Byte, Float> map3,
            @Nonnull Map<Byte, Float> map4,
            @Nonnull Map<Byte, Float> map5, int expectedSize);



    @Override
    @Nonnull
     HashByteFloatMap newUpdatableMap(@Nonnull
            Consumer<com.koloboke.function.ByteFloatConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashByteFloatMap newUpdatableMap(
            @Nonnull byte[] keys, @Nonnull float[] values, int expectedSize);

    @Override
    @Nonnull
     HashByteFloatMap newUpdatableMap(
            @Nonnull Byte[] keys, @Nonnull Float[] values, int expectedSize);

    @Override
    @Nonnull
     HashByteFloatMap newUpdatableMap(@Nonnull Iterable<Byte> keys,
            @Nonnull Iterable<Float> values, int expectedSize);

    

    @Override
    @Nonnull
     HashByteFloatMap newUpdatableMap(
            @Nonnull Map<Byte, Float> map);

    @Override
    @Nonnull
     HashByteFloatMap newUpdatableMap(@Nonnull Map<Byte, Float> map1,
            @Nonnull Map<Byte, Float> map2);

    @Override
    @Nonnull
     HashByteFloatMap newUpdatableMap(@Nonnull Map<Byte, Float> map1,
            @Nonnull Map<Byte, Float> map2,
            @Nonnull Map<Byte, Float> map3);

    @Override
    @Nonnull
     HashByteFloatMap newUpdatableMap(@Nonnull Map<Byte, Float> map1,
            @Nonnull Map<Byte, Float> map2,
            @Nonnull Map<Byte, Float> map3,
            @Nonnull Map<Byte, Float> map4);

    @Override
    @Nonnull
     HashByteFloatMap newUpdatableMap(@Nonnull Map<Byte, Float> map1,
            @Nonnull Map<Byte, Float> map2,
            @Nonnull Map<Byte, Float> map3,
            @Nonnull Map<Byte, Float> map4,
            @Nonnull Map<Byte, Float> map5);



    @Override
    @Nonnull
     HashByteFloatMap newUpdatableMap(@Nonnull
            Consumer<com.koloboke.function.ByteFloatConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashByteFloatMap newUpdatableMap(
            @Nonnull byte[] keys, @Nonnull float[] values);

    @Override
    @Nonnull
     HashByteFloatMap newUpdatableMap(
            @Nonnull Byte[] keys, @Nonnull Float[] values);

    @Override
    @Nonnull
     HashByteFloatMap newUpdatableMap(@Nonnull Iterable<Byte> keys,
            @Nonnull Iterable<Float> values);


    @Override
    @Nonnull
     HashByteFloatMap newUpdatableMapOf(byte k1, float v1);

    @Override
    @Nonnull
     HashByteFloatMap newUpdatableMapOf(byte k1, float v1,
            byte k2, float v2);

    @Override
    @Nonnull
     HashByteFloatMap newUpdatableMapOf(byte k1, float v1,
            byte k2, float v2, byte k3, float v3);

    @Override
    @Nonnull
     HashByteFloatMap newUpdatableMapOf(byte k1, float v1,
            byte k2, float v2, byte k3, float v3,
            byte k4, float v4);

    @Override
    @Nonnull
     HashByteFloatMap newUpdatableMapOf(byte k1, float v1,
            byte k2, float v2, byte k3, float v3,
            byte k4, float v4, byte k5, float v5);

    


    @Override
    @Nonnull
     HashByteFloatMap newImmutableMap(@Nonnull Map<Byte, Float> map1,
            @Nonnull Map<Byte, Float> map2, int expectedSize);

    @Override
    @Nonnull
     HashByteFloatMap newImmutableMap(@Nonnull Map<Byte, Float> map1,
            @Nonnull Map<Byte, Float> map2,
            @Nonnull Map<Byte, Float> map3, int expectedSize);

    @Override
    @Nonnull
     HashByteFloatMap newImmutableMap(@Nonnull Map<Byte, Float> map1,
            @Nonnull Map<Byte, Float> map2,
            @Nonnull Map<Byte, Float> map3,
            @Nonnull Map<Byte, Float> map4, int expectedSize);

    @Override
    @Nonnull
     HashByteFloatMap newImmutableMap(@Nonnull Map<Byte, Float> map1,
            @Nonnull Map<Byte, Float> map2,
            @Nonnull Map<Byte, Float> map3,
            @Nonnull Map<Byte, Float> map4,
            @Nonnull Map<Byte, Float> map5, int expectedSize);



    @Override
    @Nonnull
     HashByteFloatMap newImmutableMap(@Nonnull
            Consumer<com.koloboke.function.ByteFloatConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashByteFloatMap newImmutableMap(
            @Nonnull byte[] keys, @Nonnull float[] values, int expectedSize);

    @Override
    @Nonnull
     HashByteFloatMap newImmutableMap(
            @Nonnull Byte[] keys, @Nonnull Float[] values, int expectedSize);

    @Override
    @Nonnull
     HashByteFloatMap newImmutableMap(@Nonnull Iterable<Byte> keys,
            @Nonnull Iterable<Float> values, int expectedSize);

    

    @Override
    @Nonnull
     HashByteFloatMap newImmutableMap(
            @Nonnull Map<Byte, Float> map);

    @Override
    @Nonnull
     HashByteFloatMap newImmutableMap(@Nonnull Map<Byte, Float> map1,
            @Nonnull Map<Byte, Float> map2);

    @Override
    @Nonnull
     HashByteFloatMap newImmutableMap(@Nonnull Map<Byte, Float> map1,
            @Nonnull Map<Byte, Float> map2,
            @Nonnull Map<Byte, Float> map3);

    @Override
    @Nonnull
     HashByteFloatMap newImmutableMap(@Nonnull Map<Byte, Float> map1,
            @Nonnull Map<Byte, Float> map2,
            @Nonnull Map<Byte, Float> map3,
            @Nonnull Map<Byte, Float> map4);

    @Override
    @Nonnull
     HashByteFloatMap newImmutableMap(@Nonnull Map<Byte, Float> map1,
            @Nonnull Map<Byte, Float> map2,
            @Nonnull Map<Byte, Float> map3,
            @Nonnull Map<Byte, Float> map4,
            @Nonnull Map<Byte, Float> map5);



    @Override
    @Nonnull
     HashByteFloatMap newImmutableMap(@Nonnull
            Consumer<com.koloboke.function.ByteFloatConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashByteFloatMap newImmutableMap(
            @Nonnull byte[] keys, @Nonnull float[] values);

    @Override
    @Nonnull
     HashByteFloatMap newImmutableMap(
            @Nonnull Byte[] keys, @Nonnull Float[] values);

    @Override
    @Nonnull
     HashByteFloatMap newImmutableMap(@Nonnull Iterable<Byte> keys,
            @Nonnull Iterable<Float> values);


    @Override
    @Nonnull
     HashByteFloatMap newImmutableMapOf(byte k1, float v1);

    @Override
    @Nonnull
     HashByteFloatMap newImmutableMapOf(byte k1, float v1,
            byte k2, float v2);

    @Override
    @Nonnull
     HashByteFloatMap newImmutableMapOf(byte k1, float v1,
            byte k2, float v2, byte k3, float v3);

    @Override
    @Nonnull
     HashByteFloatMap newImmutableMapOf(byte k1, float v1,
            byte k2, float v2, byte k3, float v3,
            byte k4, float v4);

    @Override
    @Nonnull
     HashByteFloatMap newImmutableMapOf(byte k1, float v1,
            byte k2, float v2, byte k3, float v3,
            byte k4, float v4, byte k5, float v5);
}
