/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.client.domain;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;

public class LogEvent {
    public static final String SERIALIZED_NAME_TIME = "time";
    @SerializedName(value="time")
    private OffsetDateTime time;
    public static final String SERIALIZED_NAME_MESSAGE = "message";
    @SerializedName(value="message")
    private String message;

    @ApiModelProperty(value="Time event occurred, RFC3339Nano.")
    public OffsetDateTime getTime() {
        return this.time;
    }

    @ApiModelProperty(example="Halt and catch fire", value="A description of the event that occurred.")
    public String getMessage() {
        return this.message;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogEvent logEvent = (LogEvent)o;
        return Objects.equals(this.time, logEvent.time) && Objects.equals(this.message, logEvent.message);
    }

    public int hashCode() {
        return Objects.hash(this.time, this.message);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LogEvent {\n");
        sb.append("    time: ").append(this.toIndentedString(this.time)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

