/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.system.procs;

import com.impossibl.postgres.system.Context;
import com.impossibl.postgres.system.ConversionException;
import com.impossibl.postgres.system.procs.NumericBinaryDecoder;
import com.impossibl.postgres.system.procs.NumericBinaryEncoder;
import com.impossibl.postgres.system.procs.NumericTextDecoder;
import com.impossibl.postgres.system.procs.NumericTextEncoder;
import com.impossibl.postgres.system.procs.SimpleProcProvider;
import com.impossibl.postgres.types.Type;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.text.ParseException;

public class Int4s
extends SimpleProcProvider {
    public Int4s() {
        super((Type.Codec.Encoder<StringBuilder>)new TxtEncoder(), (Type.Codec.Decoder<CharSequence>)new TxtDecoder(), (Type.Codec.Encoder<ByteBuf>)new BinEncoder(), (Type.Codec.Decoder<ByteBuf>)new BinDecoder(), "int4", "xid", "cid", "regproc", "regtype", "regclass", "regoper", "regnamespace", "regrole");
    }

    private static Integer convertStringInput(Context context, String value) throws ConversionException {
        try {
            return context.getClientIntegerFormatter().parse(value).intValue();
        }
        catch (ParseException e) {
            throw new ConversionException("Invalid Long", e);
        }
    }

    private static String convertStringOutput(Context context, Number number) {
        return context.getClientIntegerFormatter().format(number);
    }

    static class TxtEncoder
    extends NumericTextEncoder<Integer> {
        TxtEncoder() {
            super((x$0, x$1) -> Int4s.convertStringInput(x$0, x$1), val -> val != false ? 1 : 0, Number::intValue);
        }

        @Override
        public Class<Integer> getDefaultClass() {
            return Integer.class;
        }

        @Override
        protected void encodeNativeValue(Context context, Type type, Integer value, Object sourceContext, StringBuilder buffer) throws IOException {
            buffer.append(value);
        }
    }

    static class TxtDecoder
    extends NumericTextDecoder<Integer> {
        TxtDecoder() {
            super((Context x$0, N x$1) -> Int4s.convertStringOutput(x$0, x$1));
        }

        @Override
        public Class<Integer> getDefaultClass() {
            return Integer.class;
        }

        @Override
        protected Integer decodeNativeValue(Context context, Type type, Short typeLength, Integer typeModifier, CharSequence buffer, Class<?> targetClass, Object targetContext) throws IOException, ParseException {
            return Integer.valueOf(buffer.toString());
        }
    }

    static class BinEncoder
    extends NumericBinaryEncoder<Integer> {
        BinEncoder() {
            super(4, (x$0, x$1) -> Int4s.convertStringInput(x$0, x$1), val -> val != false ? 1 : 0, Number::intValue);
        }

        @Override
        public Class<Integer> getDefaultClass() {
            return Integer.class;
        }

        @Override
        protected void encodeNativeValue(Context context, Type type, Integer value, Object sourceContext, ByteBuf buffer) throws IOException {
            buffer.writeInt(value.intValue());
        }
    }

    static class BinDecoder
    extends NumericBinaryDecoder<Integer> {
        BinDecoder() {
            super((Integer)4, (Context x$0, N x$1) -> Int4s.convertStringOutput(x$0, x$1));
        }

        @Override
        public Class<Integer> getDefaultClass() {
            return Integer.class;
        }

        @Override
        protected Integer decodeNativeValue(Context context, Type type, Short typeLength, Integer typeModifier, ByteBuf buffer, Class<?> targetClass, Object targetContext) throws IOException {
            return buffer.readInt();
        }
    }
}

