/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.protocol.v30;

import com.impossibl.postgres.protocol.Notice;
import com.impossibl.postgres.protocol.TransactionStatus;
import com.impossibl.postgres.protocol.v30.ProtocolChannel;
import com.impossibl.postgres.protocol.v30.ProtocolHandler;
import com.impossibl.postgres.protocol.v30.ServerRequest;
import com.impossibl.postgres.system.NoticeException;
import com.impossibl.postgres.system.Version;
import com.impossibl.postgres.utils.guava.Preconditions;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StartupRequest
implements ServerRequest {
    private Version protocolVersion;
    private Map<String, Object> startupParameters;
    private CompletionHandler handler;
    private int backendProcessId;
    private int backendSecretKey;
    private Map<String, String> parameterStatuses;
    private List<Notice> notices;

    StartupRequest(Version protocolVersion, Map<String, Object> startupParameters, CompletionHandler handler) {
        Preconditions.checkArgument(protocolVersion.getRevision() == null, "Protocol version cannot have a revision");
        this.protocolVersion = protocolVersion;
        this.startupParameters = startupParameters;
        this.handler = handler;
        this.parameterStatuses = new HashMap<String, String>();
        this.notices = new ArrayList<Notice>();
    }

    @Override
    public ProtocolHandler createHandler() {
        return new Handler();
    }

    @Override
    public void execute(ProtocolChannel channel) throws IOException {
        channel.writeStartup(this.protocolVersion.getMajor(), this.protocolVersion.getMinorValue(), this.startupParameters).flush();
    }

    private class Handler
    implements ProtocolHandler.Authentication,
    ProtocolHandler.BackendKeyData,
    ProtocolHandler.ParameterStatus,
    ProtocolHandler.NegotiateProtocolVersion,
    ProtocolHandler.ReadyForQuery,
    ProtocolHandler.CommandError {
        private Handler() {
        }

        public String toString() {
            return "Startup";
        }

        @Override
        public ProtocolHandler.Action negotiate(int maxSupportedMinorVersion, List<String> unrecognizedParameters) throws IOException {
            Version maxSupportedVersion = Version.get(StartupRequest.this.protocolVersion.getMajor(), maxSupportedMinorVersion, null);
            StartupRequest.this.handler.handleNegotiate(maxSupportedVersion, unrecognizedParameters);
            return ProtocolHandler.Action.Resume;
        }

        @Override
        public ProtocolHandler.Action backendKeyData(int processId, int secretKey) {
            StartupRequest.this.backendProcessId = processId;
            StartupRequest.this.backendSecretKey = secretKey;
            return ProtocolHandler.Action.Resume;
        }

        @Override
        public ProtocolHandler.Action parameterStatus(String name, String value) {
            StartupRequest.this.parameterStatuses.put(name, value);
            return ProtocolHandler.Action.Resume;
        }

        @Override
        public ProtocolHandler.Action authenticated() {
            return ProtocolHandler.Action.Resume;
        }

        @Override
        public void authenticateClear(ProtocolChannel channel) throws IOException {
            String password = StartupRequest.this.handler.authenticateClear();
            channel.writePassword(password).flush();
        }

        @Override
        public void authenticateMD5(byte[] salt, ProtocolChannel channel) throws IOException {
            String response = StartupRequest.this.handler.authenticateMD5(salt);
            channel.writePassword(response).flush();
        }

        @Override
        public void authenticateKerberos(ProtocolChannel channel) throws IOException {
            StartupRequest.this.handler.authenticateKerberos();
        }

        @Override
        public void authenticateSCM(ProtocolChannel channel) throws IOException {
            byte response = StartupRequest.this.handler.authenticateSCM();
            channel.writeSCM(response).flush();
        }

        @Override
        public void authenticateGSS(ByteBuf data, ProtocolChannel channel) throws IOException {
            data = StartupRequest.this.handler.authenticateGSS(data);
            channel.writePassword(data).flush();
            data.release();
        }

        @Override
        public void authenticateSSPI(ByteBuf data, ProtocolChannel channel) throws IOException {
            data = StartupRequest.this.handler.authenticateSSPI(data);
            channel.writePassword(data).flush();
            data.release();
        }

        @Override
        public void authenticateContinue(ByteBuf data, ProtocolChannel channel) throws IOException {
            data = StartupRequest.this.handler.authenticateContinue(data);
            channel.writePassword(data).flush();
            data.release();
        }

        @Override
        public ProtocolHandler.Action readyForQuery(TransactionStatus txnStatus) throws IOException {
            StartupRequest.this.handler.handleComplete(StartupRequest.this.backendProcessId, StartupRequest.this.backendSecretKey, StartupRequest.this.parameterStatuses, StartupRequest.this.notices);
            return ProtocolHandler.Action.Complete;
        }

        @Override
        public ProtocolHandler.Action error(Notice error) throws IOException {
            StartupRequest.this.handler.handleError(new NoticeException(error), StartupRequest.this.notices);
            return ProtocolHandler.Action.Complete;
        }

        @Override
        public void exception(Throwable cause) throws IOException {
            StartupRequest.this.handler.handleError(cause, StartupRequest.this.notices);
        }
    }

    static interface CompletionHandler {
        public String authenticateClear() throws IOException;

        public String authenticateMD5(byte[] var1) throws IOException;

        public void authenticateKerberos() throws IOException;

        public byte authenticateSCM() throws IOException;

        public ByteBuf authenticateGSS(ByteBuf var1) throws IOException;

        public ByteBuf authenticateSSPI(ByteBuf var1) throws IOException;

        public ByteBuf authenticateContinue(ByteBuf var1) throws IOException;

        public void handleNegotiate(Version var1, List<String> var2) throws IOException;

        public void handleComplete(int var1, int var2, Map<String, String> var3, List<Notice> var4) throws IOException;

        public void handleError(Throwable var1, List<Notice> var2) throws IOException;
    }
}

