/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.protocol.v30;

import com.impossibl.postgres.protocol.CopyFormat;
import com.impossibl.postgres.protocol.FieldFormat;
import com.impossibl.postgres.protocol.Notice;
import com.impossibl.postgres.protocol.ResultField;
import com.impossibl.postgres.protocol.TransactionStatus;
import com.impossibl.postgres.protocol.TypeRef;
import com.impossibl.postgres.protocol.v30.ProtocolChannel;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public interface ProtocolHandler {
    default public void exception(Channel channel, Throwable cause) throws IOException {
        this.exception(cause);
    }

    public void exception(Throwable var1) throws IOException;

    public static interface CopyFail
    extends ProtocolHandler {
        public void copyFail(String var1) throws IOException;
    }

    public static interface CopyDone
    extends ProtocolHandler {
        public void copyDone() throws IOException;
    }

    public static interface CopyData
    extends ProtocolHandler {
        public void copyData(ByteBuf var1) throws IOException;
    }

    public static interface CopyBothResponse
    extends ProtocolHandler {
        public ProtocolHandler copyBoth(CopyFormat var1, FieldFormat[] var2) throws IOException;
    }

    public static interface CopyOutResponse
    extends ProtocolHandler {
        public ProtocolHandler copyOut(CopyFormat var1, FieldFormat[] var2) throws IOException;
    }

    public static interface CopyInResponse
    extends ProtocolHandler {
        public InputStream copyIn(CopyFormat var1, FieldFormat[] var2) throws IOException;
    }

    public static interface Notification {
        public void notification(int var1, String var2, String var3) throws IOException;
    }

    public static interface ReadyForQuery
    extends ProtocolHandler {
        public Action readyForQuery(TransactionStatus var1) throws IOException;
    }

    public static interface CommandComplete
    extends ProtocolHandler {
        public Action commandComplete(String var1, Long var2, Long var3) throws IOException;
    }

    public static interface ReportNotice
    extends ProtocolHandler {
        public Action notice(Notice var1) throws IOException;
    }

    public static interface CommandError
    extends ProtocolHandler {
        public Action error(Notice var1) throws IOException;
    }

    public static interface FunctionResult
    extends ProtocolHandler {
        public Action functionResult(ByteBuf var1) throws IOException;
    }

    public static interface EmptyQuery
    extends ProtocolHandler {
        public Action emptyQuery() throws IOException;
    }

    public static interface CloseComplete
    extends ProtocolHandler {
        public Action closeComplete() throws IOException;
    }

    public static interface BindComplete
    extends ProtocolHandler {
        public Action bindComplete() throws IOException;
    }

    public static interface ParseComplete
    extends ProtocolHandler {
        public Action parseComplete() throws IOException;
    }

    public static interface NoData
    extends ProtocolHandler {
        public Action noData() throws IOException;
    }

    public static interface PortalSuspended
    extends ProtocolHandler {
        public Action portalSuspended() throws IOException;
    }

    public static interface DataRow
    extends ProtocolHandler {
        public Action rowData(ByteBuf var1) throws IOException;
    }

    public static interface RowDescription
    extends ProtocolHandler {
        public Action rowDescription(ResultField[] var1) throws IOException;
    }

    public static interface ParameterDescriptions
    extends ProtocolHandler {
        public Action parameterDescriptions(TypeRef[] var1) throws IOException;
    }

    public static interface ParameterStatus
    extends ProtocolHandler {
        public Action parameterStatus(String var1, String var2) throws IOException;
    }

    public static interface BackendKeyData
    extends ProtocolHandler {
        public Action backendKeyData(int var1, int var2) throws IOException;
    }

    public static interface Authentication
    extends ProtocolHandler {
        public Action authenticated() throws IOException;

        public void authenticateKerberos(ProtocolChannel var1) throws IOException;

        public void authenticateClear(ProtocolChannel var1) throws IOException;

        public void authenticateMD5(byte[] var1, ProtocolChannel var2) throws IOException;

        public void authenticateSCM(ProtocolChannel var1) throws IOException;

        public void authenticateGSS(ByteBuf var1, ProtocolChannel var2) throws IOException;

        public void authenticateSSPI(ByteBuf var1, ProtocolChannel var2) throws IOException;

        public void authenticateContinue(ByteBuf var1, ProtocolChannel var2) throws IOException;
    }

    public static interface NegotiateProtocolVersion
    extends ProtocolHandler {
        public Action negotiate(int var1, List<String> var2) throws IOException;
    }

    public static enum Action {
        Resume,
        ResumePassing,
        Complete,
        CompletePassing,
        Sync;

    }
}

