/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.jdbc;

import com.impossibl.postgres.types.Type;
import java.util.Arrays;
import java.util.Objects;

class StatementCacheKey {
    private String sql;
    private Type[] parameterTypes;

    StatementCacheKey(String sql, Type[] parameterTypes) {
        this.sql = sql;
        this.parameterTypes = (Type[])parameterTypes.clone();
    }

    public String getSql() {
        return this.sql;
    }

    public Type[] getParameterTypes() {
        return this.parameterTypes;
    }

    public String toString() {
        return "CachedStatementKey{sql='" + this.sql + '\'' + ", parameterTypes=" + Arrays.toString(this.parameterTypes) + '}';
    }

    public int hashCode() {
        int result = Objects.hash(this.sql);
        result = 31 * result + Arrays.hashCode(this.parameterTypes);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StatementCacheKey other = (StatementCacheKey)obj;
        if (this.parameterTypes == null ? other.parameterTypes != null : !Arrays.equals(this.parameterTypes, other.parameterTypes)) {
            return false;
        }
        if (this.sql == null) {
            return other.sql == null;
        }
        return this.sql.equals(other.sql);
    }
}

