/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.grpc;

import java.util.Objects;
import org.simantics.db.Resource;

public class TypedResource {
    private final Resource resource;
    private final Type type;
    private final String identifier;

    public TypedResource(Resource resource, Type type, String identifier) {
        this.resource = resource;
        this.type = type;
        this.identifier = identifier;
    }

    public Resource getResource() {
        return this.resource;
    }

    public Type getType() {
        return this.type;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String toString() {
        return String.valueOf(this.type.toString()) + " " + this.resource.toString();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.resource, this.type, this.identifier});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TypedResource other = (TypedResource)obj;
        return Objects.equals(this.resource, other.resource) && this.type == other.type && Objects.equals(this.identifier, other.identifier);
    }

    public static TypedResource component(Resource resource, String identifier) {
        return new TypedResource(resource, Type.COMPONENT, identifier);
    }

    public static TypedResource node(Resource resource, String identifier) {
        return new TypedResource(resource, Type.NODE, identifier);
    }

    public static TypedResource unknown(Resource component, String identifier) {
        return new TypedResource(component, Type.UNKNOWN, identifier);
    }

    public static enum Type {
        COMPONENT,
        NODE,
        UNKNOWN;

    }
}

