/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.grpc;

import java.util.Set;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceAsyncRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.RVI;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.procedure.AsyncMultiProcedure;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.district.network.grpc.TypedResource;
import org.simantics.district.network.ontology.DistrictNetworkResource;
import org.simantics.modeling.ModelingResources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.FluxSink;

public class ReactiveDiagramContentRequest
extends ResourceAsyncRead<TypedResource> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReactiveDiagramContentRequest.class);
    private FluxSink<TypedResource> sink;

    public ReactiveDiagramContentRequest(Resource diagramResource, FluxSink<TypedResource> sink) {
        super(diagramResource);
        this.sink = sink;
    }

    public void perform(AsyncReadGraph graph, AsyncProcedure<TypedResource> procedure) {
        try {
            Variable configurationVariable = Variables.getConfigurationContext((ReadGraph)graph, (Resource)this.resource);
            graph.forOrderedSet(this.resource, (AsyncMultiProcedure)new OrederedSetAsyncMultiProcedure(configurationVariable, procedure, this.sink));
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
    }

    private static String resolveIdentifier(ReadGraph graph, Variable configurationVariable, Resource resource) {
        String identifier = "";
        try {
            DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
            Resource mappedElement = graph.getSingleObject(resource, DN.MappedComponent);
            Resource mappedComponent = graph.getSingleObject(mappedElement, ModelingResources.getInstance((ReadGraph)graph).ElementToComponent);
            Variable componentVariable = Variables.getVariable((ReadGraph)graph, (Resource)mappedComponent);
            RVI possibleRVI = componentVariable.getPossibleRVI(graph);
            if (possibleRVI != null) {
                identifier = possibleRVI.asString(graph, configurationVariable);
            }
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
        return identifier;
    }

    private static class OrederedSetAsyncMultiProcedure
    implements AsyncMultiProcedure<Resource> {
        private final Variable configurationVariable;
        private final FluxSink<TypedResource> sink;
        private AsyncProcedure<TypedResource> procedure;

        public OrederedSetAsyncMultiProcedure(Variable configurationVariable, AsyncProcedure<TypedResource> procedure, FluxSink<TypedResource> sink) {
            this.configurationVariable = configurationVariable;
            this.procedure = procedure;
            this.sink = sink;
        }

        public void execute(AsyncReadGraph graph, Resource component) {
            TypedResource typedResource = TypedResource.component(component, ReactiveDiagramContentRequest.resolveIdentifier((ReadGraph)graph, this.configurationVariable, component));
            this.sink.next((Object)typedResource);
            DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
            graph.forTypes(component, (AsyncProcedure)new TypesAsyncProcedure(DIA, this.configurationVariable, component, this.sink));
        }

        public void finished(AsyncReadGraph graph) {
            LOGGER.info("Finished");
            this.sink.complete();
            this.procedure.execute(graph, null);
        }

        public void exception(AsyncReadGraph graph, Throwable throwable) {
            LOGGER.error("Excception occured during types {}", (Object)this, (Object)throwable);
            this.sink.error(throwable);
            this.procedure.exception(graph, throwable);
        }
    }

    private static class TypesAsyncProcedure
    implements AsyncProcedure<Set<Resource>> {
        private DiagramResource DIA;
        private Variable configurationVariable;
        private Resource component;
        private FluxSink<TypedResource> sink;

        public TypesAsyncProcedure(DiagramResource DIA, Variable configurationVariable, Resource component, FluxSink<TypedResource> sink) {
            this.DIA = DIA;
            this.configurationVariable = configurationVariable;
            this.component = component;
            this.sink = sink;
        }

        public void execute(AsyncReadGraph graph, Set<Resource> types) {
            if (types.contains(this.DIA.Connection)) {
                if (types.contains(this.DIA.RouteGraphConnection)) {
                    LOGGER.info("TODO:");
                } else {
                    LOGGER.info("TODO:");
                }
            } else if (types.contains(this.DIA.Element)) {
                this.sink.next((Object)TypedResource.node(this.component, ReactiveDiagramContentRequest.resolveIdentifier((ReadGraph)graph, this.configurationVariable, this.component)));
            } else {
                this.sink.next((Object)TypedResource.unknown(this.component, ReactiveDiagramContentRequest.resolveIdentifier((ReadGraph)graph, this.configurationVariable, this.component)));
            }
        }

        public void exception(AsyncReadGraph graph, Throwable throwable) {
            LOGGER.error("Excception occured during typesAsyncProcerure {}", (Object)this, (Object)throwable);
            this.sink.error(throwable);
        }
    }
}

