/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.grpc;

import java.util.ArrayList;
import java.util.List;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.procedure.adapter.TransientCacheAsyncListener;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.request.AsyncRead;
import org.simantics.db.request.Read;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.district.network.grpc.DistrictNetworkEdgeFeature;
import org.simantics.district.network.grpc.DistrictNetworkVertexFeature;
import org.simantics.district.network.grpc.Feature;
import org.simantics.district.network.grpc.Geometry;
import org.simantics.district.network.grpc.Properties;
import org.simantics.district.network.grpc.ReactiveDiagramContentRequest;
import org.simantics.district.network.grpc.TypedResource;
import org.simantics.district.network.ontology.DistrictNetworkResource;
import org.simantics.layer0.Layer0;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;

public class ReactiveDiagram {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReactiveDiagram.class);
    private static final Feature<Geometry> EMPTY_GEOM = new Feature<Geometry>(){

        @Override
        public Class<Geometry> type() {
            return null;
        }

        @Override
        public Geometry geometry() {
            return null;
        }

        @Override
        public Properties properties() {
            return null;
        }

        @Override
        public String id() {
            return null;
        }
    };
    public static final double[] EMPTY = new double[0];
    public static final short[] EMPTY_RGBA = new short[0];
    private short[][] colors = new short[][]{{34, 167, 240}, {236, 100, 75}, {135, 211, 124}};
    private List<Resource> mappings = new ArrayList<Resource>();

    public static void test(AsyncReadGraph graph, Resource diagramResource) {
        ReactiveDiagram.features((ReadGraph)graph, diagramResource).subscribe();
    }

    public static Flux<Feature<Geometry>> features(ReadGraph graph, Resource diagramResource) {
        return ReactiveDiagram.diagramComponents(graph, diagramResource).distinct().map(typedResource -> ReactiveDiagram.processTypedResource(graph, typedResource)).filter(geom -> geom != EMPTY_GEOM);
    }

    public static Flux<TypedResource> diagramComponents(ReadGraph graph, Resource diagramResource) {
        return Flux.create(sink -> {
            try {
                graph.syncRequest((AsyncRead)new ReactiveDiagramContentRequest(diagramResource, (FluxSink<TypedResource>)sink), (AsyncProcedure)new ReactiveDiagramContentProcedure((FluxSink<TypedResource>)sink));
            }
            catch (DatabaseException e) {
                LOGGER.error("Could not list diagram components", (Throwable)e);
                sink.error((Throwable)e);
            }
        });
    }

    public static <T extends Geometry> Feature<T> processTypedResource(ReadGraph graph, TypedResource typedResource) {
        DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        Resource component = typedResource.getResource();
        String identifier = typedResource.getIdentifier();
        switch (typedResource.getType()) {
            case COMPONENT: {
                try {
                    if (graph.isInstanceOf(component, DN.Vertex)) {
                        double[] coords = (double[])graph.getRelatedValue(component, DIA.HasLocation, (Binding)Bindings.DOUBLE_ARRAY);
                        Resource mapping = graph.getSingleObject(component, DN.HasMapping);
                        String mappingName = (String)graph.syncRequest((Read)new MappingTypeRead(mapping), (AsyncProcedure)TransientCacheAsyncListener.instance());
                        double elevation = (Double)graph.getRelatedValue(component, DN.Vertex_HasElevation, (Binding)Bindings.DOUBLE);
                        DistrictNetworkVertexFeature feature = new DistrictNetworkVertexFeature(identifier, coords, mappingName, elevation);
                        return feature;
                    }
                    Resource startVertex = graph.getSingleObject(component, DN.HasStartVertex);
                    Resource endVertex = graph.getSingleObject(component, DN.HasEndVertex);
                    double[] startCoords = (double[])graph.getRelatedValue2(startVertex, DIA.HasLocation, (Binding)Bindings.DOUBLE_ARRAY);
                    double[] endCoords = (double[])graph.getRelatedValue2(endVertex, DIA.HasLocation, (Binding)Bindings.DOUBLE_ARRAY);
                    double[] geometry = EMPTY;
                    try {
                        geometry = (double[])graph.getPossibleRelatedValue2(component, DN.Edge_HasGeometry, (Binding)Bindings.DOUBLE_ARRAY);
                    }
                    catch (Exception exception) {}
                    double[] result = ReactiveDiagram.mergeArray(startCoords, geometry);
                    double[] line = ReactiveDiagram.mergeArray(result, endCoords);
                    Resource mapping = graph.getSingleObject(component, DN.HasMapping);
                    String mappingName = (String)graph.syncRequest((Read)new MappingTypeRead(mapping), (AsyncProcedure)TransientCacheAsyncListener.instance());
                    return new DistrictNetworkEdgeFeature(identifier, line, mappingName);
                }
                catch (DatabaseException e) {
                    LOGGER.error("Could not process typed resource", (Throwable)e);
                }
            }
        }
        return EMPTY_GEOM;
    }

    public static double[] mergeArray(double[] firstArray, double[] secondArray) {
        if (firstArray == null) {
            return secondArray;
        }
        if (secondArray == null) {
            return firstArray;
        }
        int fal = firstArray.length;
        int sal = secondArray.length;
        double[] result = new double[fal + sal];
        System.arraycopy(firstArray, 0, result, 0, fal);
        System.arraycopy(secondArray, 0, result, fal, sal);
        return result;
    }

    private static class MappingTypeRead
    extends UnaryRead<Resource, String> {
        public MappingTypeRead(Resource mapping) {
            super((Object)mapping);
        }

        public String perform(ReadGraph graph) throws DatabaseException {
            return (String)graph.getRelatedValue((Resource)this.parameter, Layer0.getInstance((ReadGraph)graph).HasName);
        }
    }

    private static class ReactiveDiagramContentProcedure
    implements AsyncProcedure<TypedResource> {
        private FluxSink<TypedResource> sink;

        public ReactiveDiagramContentProcedure(FluxSink<TypedResource> sink) {
            this.sink = sink;
        }

        public void execute(AsyncReadGraph graph, TypedResource result) {
        }

        public void exception(AsyncReadGraph graph, Throwable throwable) {
            throwable.printStackTrace();
        }
    }
}

