/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.grpc;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.CompletableFuture;
import org.simantics.district.network.grpc.Activator;
import org.simantics.district.network.grpc.DistrictGrpcServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zeroturnaround.exec.ProcessExecutor;
import org.zeroturnaround.exec.StartedProcess;
import org.zeroturnaround.exec.stream.slf4j.Slf4jDebugOutputStream;
import org.zeroturnaround.process.PidProcess;
import org.zeroturnaround.process.PidUtil;
import org.zeroturnaround.process.Processes;
import org.zeroturnaround.process.SystemProcess;

public class GrpcWebProxy {
    private static final Logger LOGGER = LoggerFactory.getLogger(GrpcWebProxy.class);
    private static SystemProcess process;
    private static final int GRPCWEBPROXY_HTTP_PORT;

    static {
        GRPCWEBPROXY_HTTP_PORT = Integer.parseInt(GrpcWebProxy.getenv("GRPCWEBPROXY_HTTP_PORT", "6790"));
    }

    private static String getenv(String key, String defaultValue) {
        String value = System.getenv(key);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public static CompletableFuture<Void> start() {
        if (process == null) {
            return CompletableFuture.runAsync(() -> {
                try {
                    GrpcWebProxy.start0();
                }
                catch (Exception e) {
                    LOGGER.error("Could not start grpcwebproxy", (Throwable)e);
                    throw new IllegalStateException(e);
                }
            });
        }
        LOGGER.info("grpcwebproxy already started");
        return CompletableFuture.completedFuture(null);
    }

    private static void start0() throws IOException, InterruptedException, URISyntaxException {
        Path grpcwebproxyexe = Activator.getGrpcwebproxyexe();
        GrpcWebProxy.terminateExistingProcess();
        String[] command = new String[]{grpcwebproxyexe.toAbsolutePath().toString(), "--backend_addr=localhost:" + DistrictGrpcServer.DISTRICT_GRPC_SERVER_PORT, "--server_http_debug_port=" + GRPCWEBPROXY_HTTP_PORT, "--run_tls_server=false", "--server_http_max_read_timeout=10000000s", "--server_http_max_write_timeout=1000000s", "--allow_all_origins"};
        StartedProcess startedProcess = new ProcessExecutor().directory(grpcwebproxyexe.getParent().toFile()).destroyOnExit().command(command).redirectOutput((OutputStream)new Slf4jDebugOutputStream(LOGGER){

            protected void processLine(String line) {
                String utf8Line = new String(line.getBytes(), StandardCharsets.UTF_8);
                this.log.debug(utf8Line);
            }
        }).start();
        Process nativeProcess = startedProcess.getProcess();
        process = Processes.newStandardProcess((Process)nativeProcess);
        int pid = PidUtil.getPid((Process)nativeProcess);
        Path pidFile = GrpcWebProxy.pidFile();
        LOGGER.info("Writing pid-file to {} with pid={}", (Object)pidFile, (Object)pid);
        Files.write(pidFile, String.valueOf(pid).getBytes(), StandardOpenOption.CREATE);
    }

    private static boolean terminateExistingProcess() throws IOException, InterruptedException {
        Path pidFile = GrpcWebProxy.pidFile();
        if (Files.exists(pidFile, new LinkOption[0])) {
            String pid = new String(Files.readAllBytes(pidFile));
            PidProcess handle = Processes.newPidProcess((int)Integer.valueOf(pid));
            GrpcWebProxy.stopProcess((SystemProcess)handle);
            return true;
        }
        return false;
    }

    public static void stop() throws IOException, InterruptedException {
        if (process != null) {
            GrpcWebProxy.stopProcess(process);
            process = null;
        }
    }

    private static boolean stopProcess(SystemProcess handle) throws IOException, InterruptedException {
        Path path;
        boolean destroyRequested = false;
        handle.destroyForcefully();
        if (handle.isAlive()) {
            handle.destroyForcefully();
            destroyRequested = true;
        }
        if (Files.exists(path = GrpcWebProxy.pidFile(), new LinkOption[0])) {
            try {
                Files.delete(path);
            }
            catch (IOException e) {
                LOGGER.error("Could not delete pid file {}", (Object)path, (Object)e);
            }
        }
        return destroyRequested;
    }

    private static Path pidFile() {
        return Activator.getPluginMetadataPath().resolve("grpcwebproxy.pid");
    }
}

