/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.grpc;

import com.google.gson.JsonObject;
import com.mapbox.geojson.Feature;
import com.mapbox.geojson.FeatureCollection;
import com.mapbox.geojson.Geometry;
import com.mapbox.geojson.LineString;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.procedure.adapter.TransientCacheListener;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.district.network.grpc.Properties;
import org.simantics.district.network.grpc.ReactiveDiagram;
import org.simantics.district.network.grpc.impl.Line;
import org.simantics.district.network.grpc.impl.Point;
import org.simantics.district.network.grpc.impl.PropertiesImpl;

public class GeoJSONExport {
    public static void doExport(String diagramURI, String filePath) throws DatabaseException, IOException {
        String geoJSON = (String)Simantics.getSession().syncRequest((Read)new GeoJSONRead(diagramURI), (Listener)TransientCacheListener.instance());
        Path path = Paths.get(filePath, new String[0]);
        Files.write(path, geoJSON.getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
    }

    private static Feature processLine(Line line, String id, PropertiesImpl properties) {
        double[] coords = line.getCoords();
        ArrayList<com.mapbox.geojson.Point> lngLats = new ArrayList<com.mapbox.geojson.Point>(coords.length / 2);
        int i = 0;
        while (i < coords.length) {
            lngLats.add(com.mapbox.geojson.Point.fromLngLat((double)coords[i], (double)coords[i + 1]));
            i += 2;
        }
        return Feature.fromGeometry((Geometry)LineString.fromLngLats(lngLats), (JsonObject)properties.asJsonObject(), (String)id);
    }

    private static Feature processPoint(Point p, String id, PropertiesImpl properties) {
        return Feature.fromGeometry((Geometry)com.mapbox.geojson.Point.fromLngLat((double)p.coordinates()[0], (double)p.coordinates()[1]), (JsonObject)properties.asJsonObject(), (String)id);
    }

    static /* synthetic */ Feature access$0(Line line, String string, PropertiesImpl propertiesImpl) {
        return GeoJSONExport.processLine(line, string, propertiesImpl);
    }

    static /* synthetic */ Feature access$1(Point point, String string, PropertiesImpl propertiesImpl) {
        return GeoJSONExport.processPoint(point, string, propertiesImpl);
    }

    private static class GeoJSONRead
    extends UnaryRead<String, String> {
        public GeoJSONRead(String diagramURI) {
            super((Object)diagramURI);
        }

        public String perform(ReadGraph graph) throws DatabaseException {
            Resource diagramResource = graph.getPossibleResource((String)this.parameter);
            List features = (List)ReactiveDiagram.features(graph, diagramResource).map(feature -> {
                Properties properties = feature.properties();
                if (feature.type().equals(Line.class)) {
                    return GeoJSONExport.processLine((Line)feature.geometry(), feature.id(), (PropertiesImpl)properties);
                }
                if (feature.type().equals(Point.class)) {
                    return GeoJSONExport.processPoint((Point)feature.geometry(), feature.id(), (PropertiesImpl)properties);
                }
                System.err.println("error!!!");
                return null;
            }).collect(Collectors.toList()).block();
            FeatureCollection collection = FeatureCollection.fromFeatures((List)features);
            return collection.toJson();
        }
    }
}

