/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.grpc;

import org.simantics.district.network.grpc.Feature;
import org.simantics.district.network.grpc.Geometry;
import org.simantics.district.network.grpc.Properties;
import org.simantics.district.network.grpc.impl.Point;
import org.simantics.district.network.grpc.impl.PropertiesImpl;

public class DistrictNetworkVertexFeature
implements Feature<Point> {
    private String id;
    private final double[] coords;
    private String mappingName;
    private double elevation;

    public DistrictNetworkVertexFeature(String id, double[] coords, String mappingName, double elevation) {
        this.id = id;
        this.coords = coords;
        this.mappingName = mappingName;
        this.elevation = elevation;
    }

    @Override
    public Point geometry() {
        return Point.fromCoords(this.coords, Geometry.Dimension.TWO);
    }

    @Override
    public Properties properties() {
        PropertiesImpl p = new PropertiesImpl();
        p.put("id", this.id);
        p.put("mapping", this.mappingName);
        p.put("elevation", this.elevation);
        return p;
    }

    @Override
    public Class<Point> type() {
        return Point.class;
    }

    @Override
    public String id() {
        return this.id;
    }
}

