/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.grpc;

import com.google.gson.JsonObject;
import com.mapbox.geojson.Feature;
import com.mapbox.geojson.GeoJson;
import com.mapbox.geojson.Geometry;
import com.mapbox.geojson.LineString;
import fi.semantum.geobuf.Encode;
import fi.semantum.geobuf.gen.ReactorGeobufServiceGrpc;
import fi.semantum.geobuf.gen.Services;
import geobuf.Geobuf;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Publisher;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.PossibleActiveModel;
import org.simantics.db.layer0.request.PossibleURI;
import org.simantics.db.request.Read;
import org.simantics.district.network.grpc.DistrictNetworkEdgeFeature;
import org.simantics.district.network.grpc.DistrictNetworkVertexFeature;
import org.simantics.district.network.grpc.EventBrokerImpl;
import org.simantics.district.network.grpc.Properties;
import org.simantics.district.network.grpc.ReactiveDiagram;
import org.simantics.district.network.grpc.impl.Line;
import org.simantics.district.network.grpc.impl.Point;
import org.simantics.district.network.grpc.impl.PropertiesImpl;
import org.simantics.district.network.ontology.DistrictNetworkResource;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.simulation.ontology.SimulationResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class DistrictGrpcServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(DistrictGrpcServer.class);
    private static Server server;
    public static final int DISTRICT_GRPC_SERVER_PORT;

    static {
        DISTRICT_GRPC_SERVER_PORT = Integer.parseInt(DistrictGrpcServer.getenv("DISTRICT_GRPC_SERVER_PORT", "6789"));
    }

    private static String getenv(String key, String defaultValue) {
        String value = System.getenv(key);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public static CompletableFuture<Void> startServer() {
        if (server == null) {
            LOGGER.info("Starting District GRPC Server...");
            return CompletableFuture.runAsync(() -> {
                try {
                    server = ServerBuilder.forPort((int)DISTRICT_GRPC_SERVER_PORT).addService((BindableService)new GeobufService()).build().start();
                    LOGGER.info("District GRPC Server started at port {}!", (Object)DISTRICT_GRPC_SERVER_PORT);
                }
                catch (IOException e) {
                    LOGGER.error("Could not start District GRPC Server", (Throwable)e);
                    throw new IllegalStateException(e);
                }
            });
        }
        LOGGER.info("Server is already started");
        return CompletableFuture.completedFuture(null);
    }

    public static void stopServer() {
        if (server != null) {
            LOGGER.info("Shutting down District GRPC Server");
            server.shutdown();
        }
    }

    private static JsonObject propertiesToJson(Properties properties) {
        return ((PropertiesImpl)properties).asJsonObject();
    }

    static /* synthetic */ Logger access$0() {
        return LOGGER;
    }

    static /* synthetic */ JsonObject access$1(Properties properties) {
        return DistrictGrpcServer.propertiesToJson(properties);
    }

    public static class GeobufService
    extends ReactorGeobufServiceGrpc.GeobufServiceImplBase {
        private EventBrokerImpl eventBrokerImpl = new EventBrokerImpl();

        public Flux<Services.GeobufResponse> geobufs(Mono<Services.GeobufRequest> request) {
            return request.flatMapMany(requestV -> {
                String URI2 = null;
                String clientId = requestV.getClientId();
                Flux eventFeatures = this.eventBrokerImpl.featureChanges(clientId, URI2).map(event -> {
                    String id = event.id();
                    event.topic();
                    PropertiesImpl p = (PropertiesImpl)event.properties();
                    p.put("changeEvent", true);
                    Object staticInfromation = p.get("staticInformation");
                    if (staticInfromation != null) {
                        LOGGER.debug("got static information");
                    }
                    LOGGER.debug("Got event for id {}", (Object)id);
                    com.mapbox.geojson.Point point = com.mapbox.geojson.Point.fromLngLat((double)0.0, (double)0.0);
                    Feature f = Feature.fromGeometry((Geometry)point, (JsonObject)p.asJsonObject(), (String)id);
                    Geobuf.Data data = new Encode().encode((GeoJson)f);
                    return Services.GeobufResponse.newBuilder().setGeobuf(data).build();
                }).doOnError(t -> LOGGER.error("Could not map feature changes for {}", (Object)clientId, t));
                request.doOnCancel(() -> LOGGER.info("request was canceled"));
                request.doOnError(t -> LOGGER.error("Request encountered error", t));
                return Flux.mergeSequential((Publisher[])new Publisher[]{this.currentFeatures(URI2), eventFeatures});
            });
        }

        private Flux<Services.GeobufResponse> currentFeatures(final String URI2) {
            return Flux.create(sink -> Simantics.getSession().asyncRequest((Read)new ReadRequest((FluxSink)sink){
                private final /* synthetic */ FluxSink val$sink;
                {
                    this.val$sink = fluxSink;
                }

                public void run(ReadGraph graph) {
                    String finalURI = null;
                    if (URI2 == null) {
                        try {
                            finalURI = "";
                            Resource model = (Resource)graph.syncRequest((Read)new PossibleActiveModel(Simantics.getProjectResource()));
                            Resource configuration = graph.getSingleObject(model, SimulationResource.getInstance((ReadGraph)graph).HasConfiguration);
                            Collection networkComposites = (Collection)graph.syncRequest((Read)new ObjectsWithType(configuration, Layer0.getInstance((ReadGraph)graph).ConsistsOf, DistrictNetworkResource.getInstance((ReadGraph)graph).Composite));
                            for (Resource networkComposite : networkComposites) {
                                Resource networkDiagram = graph.getSingleObject(networkComposite, ModelingResources.getInstance((ReadGraph)graph).CompositeToDiagram);
                                finalURI = (String)graph.syncRequest((Read)new PossibleURI(networkDiagram));
                            }
                        }
                        catch (DatabaseException e) {
                            LOGGER.error("Could not resolve active model diagram URI", (Throwable)e);
                            this.val$sink.error((Throwable)e);
                        }
                    } else {
                        finalURI = URI2;
                    }
                    if (finalURI == null) {
                        IllegalStateException ex = new IllegalStateException("No active model and therefore no diagram");
                        this.val$sink.error((Throwable)ex);
                        throw ex;
                    }
                    try {
                        Resource diagramResource = graph.getResource(finalURI);
                        ReactiveDiagram.features(graph, diagramResource).doOnNext(feature -> this.val$sink.next(feature)).doOnComplete(() -> this.val$sink.complete()).subscribe();
                    }
                    catch (Exception e) {
                        LOGGER.error("Could not stream diagram features for uri {}", (Object)finalURI, (Object)e);
                        this.val$sink.error((Throwable)e);
                    }
                }
            })).publishOn(Schedulers.parallel()).map(feature -> {
                if (feature instanceof DistrictNetworkVertexFeature) {
                    DistrictNetworkVertexFeature feat = (DistrictNetworkVertexFeature)feature;
                    String id = feat.id();
                    Point p = feat.geometry();
                    double[] coords = p.coordinates();
                    com.mapbox.geojson.Point point = com.mapbox.geojson.Point.fromLngLat((double)coords[0], (double)coords[1]);
                    Feature f = Feature.fromGeometry((Geometry)point, (JsonObject)DistrictGrpcServer.propertiesToJson(feat.properties()), (String)id);
                    return Services.GeobufResponse.newBuilder().setGeobuf(new Encode().encode((GeoJson)f)).build();
                }
                DistrictNetworkEdgeFeature feat = (DistrictNetworkEdgeFeature)feature;
                Line line = feat.geometry();
                String id = feat.id();
                double[] coords = line.getCoords();
                ArrayList<com.mapbox.geojson.Point> points = new ArrayList<com.mapbox.geojson.Point>();
                int i = 0;
                while (i < coords.length) {
                    double x = coords[i];
                    double y = coords[i + 1];
                    com.mapbox.geojson.Point fromLngLat = com.mapbox.geojson.Point.fromLngLat((double)x, (double)y);
                    points.add(fromLngLat);
                    i += 2;
                }
                LineString ls = LineString.fromLngLats(points);
                Feature f = Feature.fromGeometry((Geometry)ls, (JsonObject)DistrictGrpcServer.propertiesToJson(feat.properties()), (String)id);
                return Services.GeobufResponse.newBuilder().setGeobuf(new Encode().encode((GeoJson)f)).build();
            });
        }

        public Mono<Services.UpdatesResponse> updates(Mono<Services.UpdatesRequest> request) {
            return request.flatMap(requestV -> {
                String clientId = requestV.getClientId();
                boolean enabled = requestV.getEnabled();
                String diagramURI = null;
                if (enabled) {
                    this.eventBrokerImpl.requestChanges(clientId, diagramURI);
                } else {
                    this.eventBrokerImpl.unrequestChanges(clientId, diagramURI);
                }
                return Mono.just((Object)Services.UpdatesResponse.newBuilder().build());
            });
        }
    }
}

