package org.simantics.structural2.scl;

import gnu.trove.map.hash.THashMap;

import java.util.Map;

import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.structural.stubs.StructuralResource2;

public class ReadComponentTypeConnectionsRequest extends ResourceRead<Map<String, Resource>> {

	public ReadComponentTypeConnectionsRequest(Resource resource) {
		super(resource);
	}

	@Override
	public Map<String, Resource> perform(ReadGraph graph)
			throws DatabaseException {
		THashMap<String, Resource> result = 
				new THashMap<String, Resource>();
		
		Layer0 L0 = Layer0.getInstance(graph);
		StructuralResource2 STR = StructuralResource2.getInstance(graph);
		for(Resource relation : graph.getObjects(resource, L0.DomainOf)) {
			if(graph.isSubrelationOf(relation, STR.IsConnectedTo)) {
				String name = graph.getRelatedValue(relation, L0.HasName, Bindings.STRING);				
				result.put(name, relation);
			}
		}
		
		return result;
	}

}
