package org.simantics.structural2.scl;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.structural.stubs.StructuralResource2;

public class FindPossibleComponentTypeRequest extends ResourceRead<Resource> {

	public FindPossibleComponentTypeRequest(Resource resource) {
		super(resource);
	}

	@Override
	public Resource perform(ReadGraph graph) throws DatabaseException {		
		StructuralResource2 STR = StructuralResource2.getInstance(graph);		
		Resource type = graph.getPossibleObject(resource, STR.Defines);
		if(type != null)
			return type;		

		Layer0 L0 = Layer0.getInstance(graph);
		Resource parent = graph.getPossibleObject(resource, L0.PartOf);
		if(parent != null && graph.isInstanceOf(parent, STR.Composite))
			return graph.syncRequest(new FindPossibleComponentTypeRequest(parent));
		else
			return null;
	}

}
