package org.simantics.scl.compiler.top;


public interface SCLCompilerConfiguration {

    static final String KEY_PREFIX = "org.simantics.scl.compiler.";
    
    public static final boolean DEBUG = parseBoolean("debug", false);
    public static final boolean ENABLE_TIMING = parseBoolean("enableTiming", false);
    
    public static final boolean SHOW_SSA_BEFORE_OPTIMIZATION        = parseBoolean("showSsaBeforeOptimization", false);
    public static final boolean SHOW_SSA_BEFORE_LAMBDA_LIFTING      = parseBoolean("showSsaBeforeLambdaLifting", false);
    public static final boolean SHOW_FINAL_SSA                      = parseBoolean("showFinalSsa", false);
    public static final boolean SHOW_COMPILED_BYTECODE              = parseBoolean("showCompiledBytecode", false);
    public static final boolean SHOW_DECOMPILED_BYTECODE            = parseBoolean("showDecompiledBytecode", false);
    
    public static final boolean SHOW_EXPRESSION_BEFORE_EVALUATION   = parseBoolean("showExpressionBeforeEvaluation", false);
    public static final boolean SHOW_INTERPRETED_EXPRESSION         = parseBoolean("showInterpretedExpression", false);
    
    public static final boolean SHOW_COMPILED_RULES                 = parseBoolean("showCompiledRules", false);
    
    public static final boolean VALIDATE_AFTER_OPTIMIZATIONS        = parseBoolean("validateAfterOptimizations", false);
    public static final boolean TRACE_CONSTRAINT_SOLVER             = parseBoolean("traceConstraintSolver", false);
    public static final boolean PRINT_OPTIMIZATION_TRANSFORMATIONS  = parseBoolean("printOptimizationTransformations", false);
    
    public static final boolean NULL_CHECK_THREAD_LOCAL_VARIABLES   = parseBoolean("nullCheckThreadLocalVariables", false);
    
    public static final boolean TRACE_METHOD_CREATION               = parseBoolean("traceMethodCreation", false);
    
    public static final boolean TRACE_MODULE_UPDATE                 = parseBoolean("traceModuleUpdate", false);
    
    // Flags related to too long method sizes
    public static final boolean TRACE_MAX_METHOD_SIZE               = parseBoolean("traceMaxMethodSize", false);
    public static final boolean EVERY_RULE_ENFORCEMENT_IN_SEPARATE_METHOD = parseBoolean("everyRuleEnforcementInSeparateMethod", true);
    public static final boolean EVERY_DATALOG_STRATUM_IN_SEPARATE_METHOD = parseBoolean("everyDatalogStratumInSeparateMethod", true);
    
    public static final boolean ALLOW_OVERLOADING = parseBoolean("allowOverloading", true);

    public static boolean debugFilter(String name) {
        return true;
    }

    static boolean parseBoolean(String property, boolean defaultValue) {
        return defaultValue || Boolean.parseBoolean(System.getProperty(KEY_PREFIX + property));
    }
}
