package org.simantics.scl.compiler.source;

import org.simantics.scl.compiler.errors.Failable;
import org.simantics.scl.compiler.module.Module;
import org.simantics.scl.compiler.module.options.ModuleCompilationOptions;
import org.simantics.scl.compiler.module.repository.ModuleRepository;
import org.simantics.scl.compiler.module.repository.UpdateListener;

/**
 * ModuleSource is a recipe for creating a module in a given environment.
 * 
 * @author Hannu Niemist&ouml;
 */
public interface ModuleSource {
    String getModuleName();
    ClassLoader getClassLoader();
    Failable<Module> compileModule(ModuleRepository environment, UpdateListener listener, ModuleCompilationOptions options);
    double getPriority();
}
