package org.simantics.scl.compiler.runtime;

import java.util.Collection;

import org.simantics.scl.compiler.environment.Environment;

import gnu.trove.map.hash.THashMap;

public class RuntimeEnvironmentImpl implements RuntimeEnvironment {

    private final Environment environment;
    private final THashMap<String, RuntimeModule> runtimeModuleMap;
    private final ClassLoader parentClassLoader;
    private MutableClassLoader classLoader;
    
    public RuntimeEnvironmentImpl(Environment environment,
            ClassLoader parentClassLoader,
            THashMap<String, RuntimeModule> runtimeModuleMap) {
        this.environment = environment;
        this.parentClassLoader = parentClassLoader;
        this.runtimeModuleMap = runtimeModuleMap;
    }

    @Override
    public Environment getEnvironment() {
        return environment;
    }

    @Override
    public RuntimeModule getRuntimeModule(String name) {
        return runtimeModuleMap.get(name);
    }

    @Override
    public synchronized MutableClassLoader getMutableClassLoader() {
        if(classLoader == null)
            classLoader = new ExpressionClassLoader(
                    parentClassLoader, runtimeModuleMap, "Expression");
        return classLoader;
    }

    @Override
    public Collection<RuntimeModule> getRuntimeModules() {
        return runtimeModuleMap.values();
    }

}
