package org.simantics.scl.compiler.internal.interpreted;

import java.util.Arrays;

public class IListLiteral implements IExpression {

    private final IExpression[] componentExpressions;

    public IListLiteral(IExpression[] componentExpressions) {
        this.componentExpressions = componentExpressions;
    }

    @Override
    public Object execute(Object[] variableBindings) {
        Object[] components = new Object[componentExpressions.length];
        for(int i=0;i<componentExpressions.length;++i)
            components[i] = componentExpressions[i].execute(variableBindings);
        return Arrays.asList(components);
    }
    
    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append('[');
        for(int i=0;i<componentExpressions.length;++i) {
            if(i > 0)
                b.append(", ");
            b.append(componentExpressions[i]);
        }
        b.append(']');
        return b.toString();
    }
}
