package org.simantics.scl.compiler.elaboration.expressions;

import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.internal.codegen.references.IVal;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.exceptions.UnificationException;
import org.simantics.scl.compiler.types.util.Typed;

public class Variable implements Typed {
    public static final Variable[] EMPTY_ARRAY = new Variable[0];
    
    String name;
    Type type;
    transient private IVal val;

    public Variable(String name) {
        this.name = name;
    }

    public Variable(String name, Type type) {
        this.name = name;
        this.type = type;
    }

    @Override
    public Type getType() {
        return type;
    }

    public String getName() {
        return name;
    }
    
    public void setType(Type type) {
        if(type == null)
            throw new NullPointerException();
        if(this.type != null)
            try {
                Types.unify(type, this.type);
            } catch(UnificationException e) {
                throw new InternalCompilerError(e.getMessage());
            }
        else
            this.type = type;
    }

    @Override
    public String toString() {
        return name; // + "$" + hashCode();
    }
    
    public void setVal(IVal val) {
        this.val = val;
        val.setLabel(name);
    }
    
    public IVal getVal() {
        if(val == null)
            throw new InternalCompilerError("Variable " + name + " (with type " + type + ") is not given value anywhere.");
        return val;
    }

    public Variable copy() {
        return new Variable(name, type);
    }

    public void setName(String name) {
        this.name = name;
    }

    public static Variable[] concat(Variable[] a,
            Variable[] b) {
        Variable[] result = new Variable[a.length + b.length];
        System.arraycopy(a, 0, result, 0, a.length);
        System.arraycopy(b, 0, result, a.length, b.length);
        return result;
    }
}
